/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeletePlatformVersionResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DeletePlatformVersionResponse> {
    private static final SdkField<PlatformSummary> PLATFORM_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeletePlatformVersionResponse.getter(DeletePlatformVersionResponse::platformSummary)).setter(DeletePlatformVersionResponse.setter(Builder::platformSummary)).constructor(PlatformSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_SUMMARY_FIELD));
    private final PlatformSummary platformSummary;

    private DeletePlatformVersionResponse(BuilderImpl builder) {
        super(builder);
        this.platformSummary = builder.platformSummary;
    }

    public PlatformSummary platformSummary() {
        return this.platformSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platformSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePlatformVersionResponse)) {
            return false;
        }
        DeletePlatformVersionResponse other = (DeletePlatformVersionResponse)((Object)obj);
        return Objects.equals(this.platformSummary(), other.platformSummary());
    }

    public String toString() {
        return ToString.builder((String)"DeletePlatformVersionResponse").add("PlatformSummary", (Object)this.platformSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformSummary": {
                return Optional.ofNullable(clazz.cast(this.platformSummary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePlatformVersionResponse, T> g) {
        return obj -> g.apply((DeletePlatformVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private PlatformSummary platformSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePlatformVersionResponse model) {
            super(model);
            this.platformSummary(model.platformSummary);
        }

        public final PlatformSummary.Builder getPlatformSummary() {
            return this.platformSummary != null ? this.platformSummary.toBuilder() : null;
        }

        @Override
        public final Builder platformSummary(PlatformSummary platformSummary) {
            this.platformSummary = platformSummary;
            return this;
        }

        public final void setPlatformSummary(PlatformSummary.BuilderImpl platformSummary) {
            this.platformSummary = platformSummary != null ? platformSummary.build() : null;
        }

        @Override
        public DeletePlatformVersionResponse build() {
            return new DeletePlatformVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeletePlatformVersionResponse> {
        public Builder platformSummary(PlatformSummary var1);

        default public Builder platformSummary(Consumer<PlatformSummary.Builder> platformSummary) {
            return this.platformSummary((PlatformSummary)((PlatformSummary.Builder)PlatformSummary.builder().applyMutation(platformSummary)).build());
        }
    }
}

