/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkClient;
import software.amazon.awssdk.services.elasticbeanstalk.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.waiters.ElasticBeanstalkWaiter;
import software.amazon.awssdk.services.elasticbeanstalk.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultElasticBeanstalkWaiter
implements ElasticBeanstalkWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final ElasticBeanstalkClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeEnvironmentsResponse> environmentExistsWaiter;
    private final Waiter<DescribeEnvironmentsResponse> environmentUpdatedWaiter;
    private final Waiter<DescribeEnvironmentsResponse> environmentTerminatedWaiter;

    private DefaultElasticBeanstalkWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (ElasticBeanstalkClient)ElasticBeanstalkClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.environmentExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeEnvironmentsResponse.class).acceptors(DefaultElasticBeanstalkWaiter.environmentExistsWaiterAcceptors())).overrideConfiguration(DefaultElasticBeanstalkWaiter.environmentExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.environmentUpdatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeEnvironmentsResponse.class).acceptors(DefaultElasticBeanstalkWaiter.environmentUpdatedWaiterAcceptors())).overrideConfiguration(DefaultElasticBeanstalkWaiter.environmentUpdatedWaiterConfig(builder.overrideConfiguration))).build();
        this.environmentTerminatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeEnvironmentsResponse.class).acceptors(DefaultElasticBeanstalkWaiter.environmentTerminatedWaiterAcceptors())).overrideConfiguration(DefaultElasticBeanstalkWaiter.environmentTerminatedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeEnvironmentsResponse> waitUntilEnvironmentExists(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        return this.environmentExistsWaiter.run(() -> this.client.describeEnvironments(this.applyWaitersUserAgent(describeEnvironmentsRequest)));
    }

    @Override
    public WaiterResponse<DescribeEnvironmentsResponse> waitUntilEnvironmentExists(DescribeEnvironmentsRequest describeEnvironmentsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.environmentExistsWaiter.run(() -> this.client.describeEnvironments(this.applyWaitersUserAgent(describeEnvironmentsRequest)), DefaultElasticBeanstalkWaiter.environmentExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeEnvironmentsResponse> waitUntilEnvironmentTerminated(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        return this.environmentTerminatedWaiter.run(() -> this.client.describeEnvironments(this.applyWaitersUserAgent(describeEnvironmentsRequest)));
    }

    @Override
    public WaiterResponse<DescribeEnvironmentsResponse> waitUntilEnvironmentTerminated(DescribeEnvironmentsRequest describeEnvironmentsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.environmentTerminatedWaiter.run(() -> this.client.describeEnvironments(this.applyWaitersUserAgent(describeEnvironmentsRequest)), DefaultElasticBeanstalkWaiter.environmentTerminatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeEnvironmentsResponse> waitUntilEnvironmentUpdated(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        return this.environmentUpdatedWaiter.run(() -> this.client.describeEnvironments(this.applyWaitersUserAgent(describeEnvironmentsRequest)));
    }

    @Override
    public WaiterResponse<DescribeEnvironmentsResponse> waitUntilEnvironmentUpdated(DescribeEnvironmentsRequest describeEnvironmentsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.environmentUpdatedWaiter.run(() -> this.client.describeEnvironments(this.applyWaitersUserAgent(describeEnvironmentsRequest)), DefaultElasticBeanstalkWaiter.environmentUpdatedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeEnvironmentsResponse>> environmentExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeEnvironmentsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeEnvironmentsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Environments").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Ready"));
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Environments").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Launching"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeEnvironmentsResponse>> environmentUpdatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeEnvironmentsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeEnvironmentsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Environments").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Ready"));
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Environments").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Updating"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeEnvironmentsResponse>> environmentTerminatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeEnvironmentsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeEnvironmentsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Environments").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Terminated"));
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Environments").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Terminating"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration environmentExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration environmentUpdatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration environmentTerminatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static ElasticBeanstalkWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends ElasticBeanstalkRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticBeanstalkRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements ElasticBeanstalkWaiter.Builder {
        private ElasticBeanstalkClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public ElasticBeanstalkWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public ElasticBeanstalkWaiter.Builder client(ElasticBeanstalkClient client) {
            this.client = client;
            return this;
        }

        @Override
        public ElasticBeanstalkWaiter build() {
            return new DefaultElasticBeanstalkWaiter(this);
        }
    }
}

