/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationDeploymentStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSettingsListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfigurationTemplateResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, CreateConfigurationTemplateResponse> {
    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateConfigurationTemplateResponse.getter(CreateConfigurationTemplateResponse::solutionStackName)).setter(CreateConfigurationTemplateResponse.setter(Builder::solutionStackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()}).build();
    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateConfigurationTemplateResponse.getter(CreateConfigurationTemplateResponse::platformArn)).setter(CreateConfigurationTemplateResponse.setter(Builder::platformArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()}).build();
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateConfigurationTemplateResponse.getter(CreateConfigurationTemplateResponse::applicationName)).setter(CreateConfigurationTemplateResponse.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateConfigurationTemplateResponse.getter(CreateConfigurationTemplateResponse::templateName)).setter(CreateConfigurationTemplateResponse.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateConfigurationTemplateResponse.getter(CreateConfigurationTemplateResponse::description)).setter(CreateConfigurationTemplateResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateConfigurationTemplateResponse.getter(CreateConfigurationTemplateResponse::environmentName)).setter(CreateConfigurationTemplateResponse.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateConfigurationTemplateResponse.getter(CreateConfigurationTemplateResponse::deploymentStatusAsString)).setter(CreateConfigurationTemplateResponse.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()}).build();
    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CreateConfigurationTemplateResponse.getter(CreateConfigurationTemplateResponse::dateCreated)).setter(CreateConfigurationTemplateResponse.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()}).build();
    private static final SdkField<Instant> DATE_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CreateConfigurationTemplateResponse.getter(CreateConfigurationTemplateResponse::dateUpdated)).setter(CreateConfigurationTemplateResponse.setter(Builder::dateUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateUpdated").build()}).build();
    private static final SdkField<List<ConfigurationOptionSetting>> OPTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateConfigurationTemplateResponse.getter(CreateConfigurationTemplateResponse::optionSettings)).setter(CreateConfigurationTemplateResponse.setter(Builder::optionSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationOptionSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_STACK_NAME_FIELD, PLATFORM_ARN_FIELD, APPLICATION_NAME_FIELD, TEMPLATE_NAME_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_NAME_FIELD, DEPLOYMENT_STATUS_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, OPTION_SETTINGS_FIELD));
    private final String solutionStackName;
    private final String platformArn;
    private final String applicationName;
    private final String templateName;
    private final String description;
    private final String environmentName;
    private final String deploymentStatus;
    private final Instant dateCreated;
    private final Instant dateUpdated;
    private final List<ConfigurationOptionSetting> optionSettings;

    private CreateConfigurationTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.applicationName = builder.applicationName;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.environmentName = builder.environmentName;
        this.deploymentStatus = builder.deploymentStatus;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.optionSettings = builder.optionSettings;
    }

    public String solutionStackName() {
        return this.solutionStackName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String templateName() {
        return this.templateName;
    }

    public String description() {
        return this.description;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public ConfigurationDeploymentStatus deploymentStatus() {
        return ConfigurationDeploymentStatus.fromValue(this.deploymentStatus);
    }

    public String deploymentStatusAsString() {
        return this.deploymentStatus;
    }

    public Instant dateCreated() {
        return this.dateCreated;
    }

    public Instant dateUpdated() {
        return this.dateUpdated;
    }

    public List<ConfigurationOptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationTemplateResponse)) {
            return false;
        }
        CreateConfigurationTemplateResponse other = (CreateConfigurationTemplateResponse)((Object)obj);
        return Objects.equals(this.solutionStackName(), other.solutionStackName()) && Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.deploymentStatusAsString(), other.deploymentStatusAsString()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateUpdated(), other.dateUpdated()) && Objects.equals(this.optionSettings(), other.optionSettings());
    }

    public String toString() {
        return ToString.builder((String)"CreateConfigurationTemplateResponse").add("SolutionStackName", (Object)this.solutionStackName()).add("PlatformArn", (Object)this.platformArn()).add("ApplicationName", (Object)this.applicationName()).add("TemplateName", (Object)this.templateName()).add("Description", (Object)this.description()).add("EnvironmentName", (Object)this.environmentName()).add("DeploymentStatus", (Object)this.deploymentStatusAsString()).add("DateCreated", (Object)this.dateCreated()).add("DateUpdated", (Object)this.dateUpdated()).add("OptionSettings", this.optionSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SolutionStackName": {
                return Optional.ofNullable(clazz.cast(this.solutionStackName()));
            }
            case "PlatformArn": {
                return Optional.ofNullable(clazz.cast(this.platformArn()));
            }
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "DeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusAsString()));
            }
            case "DateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "DateUpdated": {
                return Optional.ofNullable(clazz.cast(this.dateUpdated()));
            }
            case "OptionSettings": {
                return Optional.ofNullable(clazz.cast(this.optionSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationTemplateResponse, T> g) {
        return obj -> g.apply((CreateConfigurationTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private String solutionStackName;
        private String platformArn;
        private String applicationName;
        private String templateName;
        private String description;
        private String environmentName;
        private String deploymentStatus;
        private Instant dateCreated;
        private Instant dateUpdated;
        private List<ConfigurationOptionSetting> optionSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationTemplateResponse model) {
            super(model);
            this.solutionStackName(model.solutionStackName);
            this.platformArn(model.platformArn);
            this.applicationName(model.applicationName);
            this.templateName(model.templateName);
            this.description(model.description);
            this.environmentName(model.environmentName);
            this.deploymentStatus(model.deploymentStatus);
            this.dateCreated(model.dateCreated);
            this.dateUpdated(model.dateUpdated);
            this.optionSettings(model.optionSettings);
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(ConfigurationDeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus.toString());
            return this;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getDateUpdated() {
            return this.dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public final Collection<ConfigurationOptionSetting.Builder> getOptionSettings() {
            return this.optionSettings != null ? (Collection)this.optionSettings.stream().map(ConfigurationOptionSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder> ... optionSettings) {
            this.optionSettings(Stream.of(optionSettings).map(c -> (ConfigurationOptionSetting)((ConfigurationOptionSetting.Builder)ConfigurationOptionSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copyFromBuilder(optionSettings);
        }

        @Override
        public CreateConfigurationTemplateResponse build() {
            return new CreateConfigurationTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConfigurationTemplateResponse> {
        public Builder solutionStackName(String var1);

        public Builder platformArn(String var1);

        public Builder applicationName(String var1);

        public Builder templateName(String var1);

        public Builder description(String var1);

        public Builder environmentName(String var1);

        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(ConfigurationDeploymentStatus var1);

        public Builder dateCreated(Instant var1);

        public Builder dateUpdated(Instant var1);

        public Builder optionSettings(Collection<ConfigurationOptionSetting> var1);

        public Builder optionSettings(ConfigurationOptionSetting ... var1);

        public Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder> ... var1);
    }
}

