/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaxAgeRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaxAgeRule> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(MaxAgeRule.getter(MaxAgeRule::enabled)).setter(MaxAgeRule.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Integer> MAX_AGE_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAgeInDays").getter(MaxAgeRule.getter(MaxAgeRule::maxAgeInDays)).setter(MaxAgeRule.setter(Builder::maxAgeInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAgeInDays").build()}).build();
    private static final SdkField<Boolean> DELETE_SOURCE_FROM_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteSourceFromS3").getter(MaxAgeRule.getter(MaxAgeRule::deleteSourceFromS3)).setter(MaxAgeRule.setter(Builder::deleteSourceFromS3)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteSourceFromS3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, MAX_AGE_IN_DAYS_FIELD, DELETE_SOURCE_FROM_S3_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Integer maxAgeInDays;
    private final Boolean deleteSourceFromS3;

    private MaxAgeRule(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.maxAgeInDays = builder.maxAgeInDays;
        this.deleteSourceFromS3 = builder.deleteSourceFromS3;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Integer maxAgeInDays() {
        return this.maxAgeInDays;
    }

    public final Boolean deleteSourceFromS3() {
        return this.deleteSourceFromS3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAgeInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteSourceFromS3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaxAgeRule)) {
            return false;
        }
        MaxAgeRule other = (MaxAgeRule)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.maxAgeInDays(), other.maxAgeInDays()) && Objects.equals(this.deleteSourceFromS3(), other.deleteSourceFromS3());
    }

    public final String toString() {
        return ToString.builder((String)"MaxAgeRule").add("Enabled", (Object)this.enabled()).add("MaxAgeInDays", (Object)this.maxAgeInDays()).add("DeleteSourceFromS3", (Object)this.deleteSourceFromS3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "MaxAgeInDays": {
                return Optional.ofNullable(clazz.cast(this.maxAgeInDays()));
            }
            case "DeleteSourceFromS3": {
                return Optional.ofNullable(clazz.cast(this.deleteSourceFromS3()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaxAgeRule, T> g) {
        return obj -> g.apply((MaxAgeRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Integer maxAgeInDays;
        private Boolean deleteSourceFromS3;

        private BuilderImpl() {
        }

        private BuilderImpl(MaxAgeRule model) {
            this.enabled(model.enabled);
            this.maxAgeInDays(model.maxAgeInDays);
            this.deleteSourceFromS3(model.deleteSourceFromS3);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getMaxAgeInDays() {
            return this.maxAgeInDays;
        }

        public final void setMaxAgeInDays(Integer maxAgeInDays) {
            this.maxAgeInDays = maxAgeInDays;
        }

        @Override
        public final Builder maxAgeInDays(Integer maxAgeInDays) {
            this.maxAgeInDays = maxAgeInDays;
            return this;
        }

        public final Boolean getDeleteSourceFromS3() {
            return this.deleteSourceFromS3;
        }

        public final void setDeleteSourceFromS3(Boolean deleteSourceFromS3) {
            this.deleteSourceFromS3 = deleteSourceFromS3;
        }

        @Override
        public final Builder deleteSourceFromS3(Boolean deleteSourceFromS3) {
            this.deleteSourceFromS3 = deleteSourceFromS3;
            return this;
        }

        public MaxAgeRule build() {
            return new MaxAgeRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaxAgeRule> {
        public Builder enabled(Boolean var1);

        public Builder maxAgeInDays(Integer var1);

        public Builder deleteSourceFromS3(Boolean var1);
    }
}

