/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPlatformVersionsResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, ListPlatformVersionsResponse> {
    private static final SdkField<List<PlatformSummary>> PLATFORM_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListPlatformVersionsResponse.getter(ListPlatformVersionsResponse::platformSummaryList)).setter(ListPlatformVersionsResponse.setter(Builder::platformSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlatformSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPlatformVersionsResponse.getter(ListPlatformVersionsResponse::nextToken)).setter(ListPlatformVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<PlatformSummary> platformSummaryList;
    private final String nextToken;

    private ListPlatformVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.platformSummaryList = builder.platformSummaryList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasPlatformSummaryList() {
        return this.platformSummaryList != null && !(this.platformSummaryList instanceof SdkAutoConstructList);
    }

    public List<PlatformSummary> platformSummaryList() {
        return this.platformSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.platformSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformVersionsResponse)) {
            return false;
        }
        ListPlatformVersionsResponse other = (ListPlatformVersionsResponse)((Object)obj);
        return Objects.equals(this.platformSummaryList(), other.platformSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListPlatformVersionsResponse").add("PlatformSummaryList", this.platformSummaryList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformSummaryList": {
                return Optional.ofNullable(clazz.cast(this.platformSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPlatformVersionsResponse, T> g) {
        return obj -> g.apply((ListPlatformVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<PlatformSummary> platformSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlatformVersionsResponse model) {
            super(model);
            this.platformSummaryList(model.platformSummaryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<PlatformSummary.Builder> getPlatformSummaryList() {
            return this.platformSummaryList != null ? (Collection)this.platformSummaryList.stream().map(PlatformSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder platformSummaryList(Collection<PlatformSummary> platformSummaryList) {
            this.platformSummaryList = PlatformSummaryListCopier.copy(platformSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformSummaryList(PlatformSummary ... platformSummaryList) {
            this.platformSummaryList(Arrays.asList(platformSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformSummaryList(Consumer<PlatformSummary.Builder> ... platformSummaryList) {
            this.platformSummaryList(Stream.of(platformSummaryList).map(c -> (PlatformSummary)((PlatformSummary.Builder)PlatformSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlatformSummaryList(Collection<PlatformSummary.BuilderImpl> platformSummaryList) {
            this.platformSummaryList = PlatformSummaryListCopier.copyFromBuilder(platformSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPlatformVersionsResponse build() {
            return new ListPlatformVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPlatformVersionsResponse> {
        public Builder platformSummaryList(Collection<PlatformSummary> var1);

        public Builder platformSummaryList(PlatformSummary ... var1);

        public Builder platformSummaryList(Consumer<PlatformSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

