/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.SingleInstanceHealth;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstancesHealthResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribeInstancesHealthResponse> {
    private static final SdkField<List<SingleInstanceHealth>> INSTANCE_HEALTH_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeInstancesHealthResponse.getter(DescribeInstancesHealthResponse::instanceHealthList)).setter(DescribeInstancesHealthResponse.setter(Builder::instanceHealthList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceHealthList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SingleInstanceHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> REFRESHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeInstancesHealthResponse.getter(DescribeInstancesHealthResponse::refreshedAt)).setter(DescribeInstancesHealthResponse.setter(Builder::refreshedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshedAt").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeInstancesHealthResponse.getter(DescribeInstancesHealthResponse::nextToken)).setter(DescribeInstancesHealthResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_HEALTH_LIST_FIELD, REFRESHED_AT_FIELD, NEXT_TOKEN_FIELD));
    private final List<SingleInstanceHealth> instanceHealthList;
    private final Instant refreshedAt;
    private final String nextToken;

    private DescribeInstancesHealthResponse(BuilderImpl builder) {
        super(builder);
        this.instanceHealthList = builder.instanceHealthList;
        this.refreshedAt = builder.refreshedAt;
        this.nextToken = builder.nextToken;
    }

    public boolean hasInstanceHealthList() {
        return this.instanceHealthList != null && !(this.instanceHealthList instanceof SdkAutoConstructList);
    }

    public List<SingleInstanceHealth> instanceHealthList() {
        return this.instanceHealthList;
    }

    public Instant refreshedAt() {
        return this.refreshedAt;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceHealthList());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesHealthResponse)) {
            return false;
        }
        DescribeInstancesHealthResponse other = (DescribeInstancesHealthResponse)((Object)obj);
        return Objects.equals(this.instanceHealthList(), other.instanceHealthList()) && Objects.equals(this.refreshedAt(), other.refreshedAt()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstancesHealthResponse").add("InstanceHealthList", this.instanceHealthList()).add("RefreshedAt", (Object)this.refreshedAt()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceHealthList": {
                return Optional.ofNullable(clazz.cast(this.instanceHealthList()));
            }
            case "RefreshedAt": {
                return Optional.ofNullable(clazz.cast(this.refreshedAt()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstancesHealthResponse, T> g) {
        return obj -> g.apply((DescribeInstancesHealthResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<SingleInstanceHealth> instanceHealthList = DefaultSdkAutoConstructList.getInstance();
        private Instant refreshedAt;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesHealthResponse model) {
            super(model);
            this.instanceHealthList(model.instanceHealthList);
            this.refreshedAt(model.refreshedAt);
            this.nextToken(model.nextToken);
        }

        public final Collection<SingleInstanceHealth.Builder> getInstanceHealthList() {
            return this.instanceHealthList != null ? (Collection)this.instanceHealthList.stream().map(SingleInstanceHealth::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceHealthList(Collection<SingleInstanceHealth> instanceHealthList) {
            this.instanceHealthList = InstanceHealthListCopier.copy(instanceHealthList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceHealthList(SingleInstanceHealth ... instanceHealthList) {
            this.instanceHealthList(Arrays.asList(instanceHealthList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceHealthList(Consumer<SingleInstanceHealth.Builder> ... instanceHealthList) {
            this.instanceHealthList(Stream.of(instanceHealthList).map(c -> (SingleInstanceHealth)((SingleInstanceHealth.Builder)SingleInstanceHealth.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceHealthList(Collection<SingleInstanceHealth.BuilderImpl> instanceHealthList) {
            this.instanceHealthList = InstanceHealthListCopier.copyFromBuilder(instanceHealthList);
        }

        public final Instant getRefreshedAt() {
            return this.refreshedAt;
        }

        @Override
        public final Builder refreshedAt(Instant refreshedAt) {
            this.refreshedAt = refreshedAt;
            return this;
        }

        public final void setRefreshedAt(Instant refreshedAt) {
            this.refreshedAt = refreshedAt;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstancesHealthResponse build() {
            return new DescribeInstancesHealthResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstancesHealthResponse> {
        public Builder instanceHealthList(Collection<SingleInstanceHealth> var1);

        public Builder instanceHealthList(SingleInstanceHealth ... var1);

        public Builder instanceHealthList(Consumer<SingleInstanceHealth.Builder> ... var1);

        public Builder refreshedAt(Instant var1);

        public Builder nextToken(String var1);
    }
}

