/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckDnsAvailabilityRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, CheckDnsAvailabilityRequest> {
    private static final SdkField<String> CNAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CheckDnsAvailabilityRequest.getter(CheckDnsAvailabilityRequest::cnamePrefix)).setter(CheckDnsAvailabilityRequest.setter(Builder::cnamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CNAMEPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CNAME_PREFIX_FIELD));
    private final String cnamePrefix;

    private CheckDnsAvailabilityRequest(BuilderImpl builder) {
        super(builder);
        this.cnamePrefix = builder.cnamePrefix;
    }

    public String cnamePrefix() {
        return this.cnamePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cnamePrefix());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDnsAvailabilityRequest)) {
            return false;
        }
        CheckDnsAvailabilityRequest other = (CheckDnsAvailabilityRequest)((Object)obj);
        return Objects.equals(this.cnamePrefix(), other.cnamePrefix());
    }

    public String toString() {
        return ToString.builder((String)"CheckDnsAvailabilityRequest").add("CNAMEPrefix", (Object)this.cnamePrefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CNAMEPrefix": {
                return Optional.ofNullable(clazz.cast(this.cnamePrefix()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckDnsAvailabilityRequest, T> g) {
        return obj -> g.apply((CheckDnsAvailabilityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String cnamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDnsAvailabilityRequest model) {
            super(model);
            this.cnamePrefix(model.cnamePrefix);
        }

        public final String getCnamePrefix() {
            return this.cnamePrefix;
        }

        @Override
        public final Builder cnamePrefix(String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
            return this;
        }

        public final void setCnamePrefix(String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckDnsAvailabilityRequest build() {
            return new CheckDnsAvailabilityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckDnsAvailabilityRequest> {
        public Builder cnamePrefix(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

