/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.AZMode;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupNameListCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.PreferredAvailabilityZoneListCopier;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupIdsListCopier;
import software.amazon.awssdk.services.elasticache.model.SnapshotArnsListCopier;
import software.amazon.awssdk.services.elasticache.model.Tag;
import software.amazon.awssdk.services.elasticache.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCacheClusterRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, CreateCacheClusterRequest> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::cacheClusterId)).setter(CreateCacheClusterRequest.setter(Builder::cacheClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()}).build();
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::replicationGroupId)).setter(CreateCacheClusterRequest.setter(Builder::replicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build()}).build();
    private static final SdkField<String> AZ_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::azModeAsString)).setter(CreateCacheClusterRequest.setter(Builder::azMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AZMode").build()}).build();
    private static final SdkField<String> PREFERRED_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::preferredAvailabilityZone)).setter(CreateCacheClusterRequest.setter(Builder::preferredAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZone").build()}).build();
    private static final SdkField<List<String>> PREFERRED_AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::preferredAvailabilityZones)).setter(CreateCacheClusterRequest.setter(Builder::preferredAvailabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZones").build(), ListTrait.builder().memberLocationName("PreferredAvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZone").build()}).build()).build()}).build();
    private static final SdkField<Integer> NUM_CACHE_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::numCacheNodes)).setter(CreateCacheClusterRequest.setter(Builder::numCacheNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheNodes").build()}).build();
    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::cacheNodeType)).setter(CreateCacheClusterRequest.setter(Builder::cacheNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::engine)).setter(CreateCacheClusterRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::engineVersion)).setter(CreateCacheClusterRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::cacheParameterGroupName)).setter(CreateCacheClusterRequest.setter(Builder::cacheParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build()}).build();
    private static final SdkField<String> CACHE_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::cacheSubnetGroupName)).setter(CreateCacheClusterRequest.setter(Builder::cacheSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroupName").build()}).build();
    private static final SdkField<List<String>> CACHE_SECURITY_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::cacheSecurityGroupNames)).setter(CreateCacheClusterRequest.setter(Builder::cacheSecurityGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupNames").build(), ListTrait.builder().memberLocationName("CacheSecurityGroupName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupName").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::securityGroupIds)).setter(CreateCacheClusterRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::tags)).setter(CreateCacheClusterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SNAPSHOT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::snapshotArns)).setter(CreateCacheClusterRequest.setter(Builder::snapshotArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArns").build(), ListTrait.builder().memberLocationName("SnapshotArn").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArn").build()}).build()).build()}).build();
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::snapshotName)).setter(CreateCacheClusterRequest.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::preferredMaintenanceWindow)).setter(CreateCacheClusterRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::port)).setter(CreateCacheClusterRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> NOTIFICATION_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::notificationTopicArn)).setter(CreateCacheClusterRequest.setter(Builder::notificationTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicArn").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::autoMinorVersionUpgrade)).setter(CreateCacheClusterRequest.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::snapshotRetentionLimit)).setter(CreateCacheClusterRequest.setter(Builder::snapshotRetentionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build()}).build();
    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::snapshotWindow)).setter(CreateCacheClusterRequest.setter(Builder::snapshotWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()}).build();
    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCacheClusterRequest.getter(CreateCacheClusterRequest::authToken)).setter(CreateCacheClusterRequest.setter(Builder::authToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD, REPLICATION_GROUP_ID_FIELD, AZ_MODE_FIELD, PREFERRED_AVAILABILITY_ZONE_FIELD, PREFERRED_AVAILABILITY_ZONES_FIELD, NUM_CACHE_NODES_FIELD, CACHE_NODE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, CACHE_PARAMETER_GROUP_NAME_FIELD, CACHE_SUBNET_GROUP_NAME_FIELD, CACHE_SECURITY_GROUP_NAMES_FIELD, SECURITY_GROUP_IDS_FIELD, TAGS_FIELD, SNAPSHOT_ARNS_FIELD, SNAPSHOT_NAME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PORT_FIELD, NOTIFICATION_TOPIC_ARN_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, SNAPSHOT_WINDOW_FIELD, AUTH_TOKEN_FIELD));
    private final String cacheClusterId;
    private final String replicationGroupId;
    private final String azMode;
    private final String preferredAvailabilityZone;
    private final List<String> preferredAvailabilityZones;
    private final Integer numCacheNodes;
    private final String cacheNodeType;
    private final String engine;
    private final String engineVersion;
    private final String cacheParameterGroupName;
    private final String cacheSubnetGroupName;
    private final List<String> cacheSecurityGroupNames;
    private final List<String> securityGroupIds;
    private final List<Tag> tags;
    private final List<String> snapshotArns;
    private final String snapshotName;
    private final String preferredMaintenanceWindow;
    private final Integer port;
    private final String notificationTopicArn;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final String authToken;

    private CreateCacheClusterRequest(BuilderImpl builder) {
        super(builder);
        this.cacheClusterId = builder.cacheClusterId;
        this.replicationGroupId = builder.replicationGroupId;
        this.azMode = builder.azMode;
        this.preferredAvailabilityZone = builder.preferredAvailabilityZone;
        this.preferredAvailabilityZones = builder.preferredAvailabilityZones;
        this.numCacheNodes = builder.numCacheNodes;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.snapshotArns = builder.snapshotArns;
        this.snapshotName = builder.snapshotName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.port = builder.port;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.authToken = builder.authToken;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public AZMode azMode() {
        return AZMode.fromValue(this.azMode);
    }

    public String azModeAsString() {
        return this.azMode;
    }

    public String preferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public List<String> preferredAvailabilityZones() {
        return this.preferredAvailabilityZones;
    }

    public Integer numCacheNodes() {
        return this.numCacheNodes;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public String cacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public List<String> cacheSecurityGroupNames() {
        return this.cacheSecurityGroupNames;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<String> snapshotArns() {
        return this.snapshotArns;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Integer port() {
        return this.port;
    }

    public String notificationTopicArn() {
        return this.notificationTopicArn;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public String snapshotWindow() {
        return this.snapshotWindow;
    }

    public String authToken() {
        return this.authToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredAvailabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.numCacheNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSecurityGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.authToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCacheClusterRequest)) {
            return false;
        }
        CreateCacheClusterRequest other = (CreateCacheClusterRequest)((Object)obj);
        return Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.azModeAsString(), other.azModeAsString()) && Objects.equals(this.preferredAvailabilityZone(), other.preferredAvailabilityZone()) && Objects.equals(this.preferredAvailabilityZones(), other.preferredAvailabilityZones()) && Objects.equals(this.numCacheNodes(), other.numCacheNodes()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.cacheParameterGroupName(), other.cacheParameterGroupName()) && Objects.equals(this.cacheSubnetGroupName(), other.cacheSubnetGroupName()) && Objects.equals(this.cacheSecurityGroupNames(), other.cacheSecurityGroupNames()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.snapshotArns(), other.snapshotArns()) && Objects.equals(this.snapshotName(), other.snapshotName()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.notificationTopicArn(), other.notificationTopicArn()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.authToken(), other.authToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateCacheClusterRequest").add("CacheClusterId", (Object)this.cacheClusterId()).add("ReplicationGroupId", (Object)this.replicationGroupId()).add("AZMode", (Object)this.azModeAsString()).add("PreferredAvailabilityZone", (Object)this.preferredAvailabilityZone()).add("PreferredAvailabilityZones", this.preferredAvailabilityZones()).add("NumCacheNodes", (Object)this.numCacheNodes()).add("CacheNodeType", (Object)this.cacheNodeType()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("CacheParameterGroupName", (Object)this.cacheParameterGroupName()).add("CacheSubnetGroupName", (Object)this.cacheSubnetGroupName()).add("CacheSecurityGroupNames", this.cacheSecurityGroupNames()).add("SecurityGroupIds", this.securityGroupIds()).add("Tags", this.tags()).add("SnapshotArns", this.snapshotArns()).add("SnapshotName", (Object)this.snapshotName()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("Port", (Object)this.port()).add("NotificationTopicArn", (Object)this.notificationTopicArn()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("SnapshotWindow", (Object)this.snapshotWindow()).add("AuthToken", (Object)this.authToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheClusterId": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterId()));
            }
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "AZMode": {
                return Optional.ofNullable(clazz.cast(this.azModeAsString()));
            }
            case "PreferredAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.preferredAvailabilityZone()));
            }
            case "PreferredAvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.preferredAvailabilityZones()));
            }
            case "NumCacheNodes": {
                return Optional.ofNullable(clazz.cast(this.numCacheNodes()));
            }
            case "CacheNodeType": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeType()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "CacheParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheParameterGroupName()));
            }
            case "CacheSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheSubnetGroupName()));
            }
            case "CacheSecurityGroupNames": {
                return Optional.ofNullable(clazz.cast(this.cacheSecurityGroupNames()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SnapshotArns": {
                return Optional.ofNullable(clazz.cast(this.snapshotArns()));
            }
            case "SnapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "NotificationTopicArn": {
                return Optional.ofNullable(clazz.cast(this.notificationTopicArn()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "SnapshotWindow": {
                return Optional.ofNullable(clazz.cast(this.snapshotWindow()));
            }
            case "AuthToken": {
                return Optional.ofNullable(clazz.cast(this.authToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCacheClusterRequest, T> g) {
        return obj -> g.apply((CreateCacheClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private String replicationGroupId;
        private String azMode;
        private String preferredAvailabilityZone;
        private List<String> preferredAvailabilityZones = DefaultSdkAutoConstructList.getInstance();
        private Integer numCacheNodes;
        private String cacheNodeType;
        private String engine;
        private String engineVersion;
        private String cacheParameterGroupName;
        private String cacheSubnetGroupName;
        private List<String> cacheSecurityGroupNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> snapshotArns = DefaultSdkAutoConstructList.getInstance();
        private String snapshotName;
        private String preferredMaintenanceWindow;
        private Integer port;
        private String notificationTopicArn;
        private Boolean autoMinorVersionUpgrade;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private String authToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCacheClusterRequest model) {
            super(model);
            this.cacheClusterId(model.cacheClusterId);
            this.replicationGroupId(model.replicationGroupId);
            this.azMode(model.azMode);
            this.preferredAvailabilityZone(model.preferredAvailabilityZone);
            this.preferredAvailabilityZones(model.preferredAvailabilityZones);
            this.numCacheNodes(model.numCacheNodes);
            this.cacheNodeType(model.cacheNodeType);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.cacheParameterGroupName(model.cacheParameterGroupName);
            this.cacheSubnetGroupName(model.cacheSubnetGroupName);
            this.cacheSecurityGroupNames(model.cacheSecurityGroupNames);
            this.securityGroupIds(model.securityGroupIds);
            this.tags(model.tags);
            this.snapshotArns(model.snapshotArns);
            this.snapshotName(model.snapshotName);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.port(model.port);
            this.notificationTopicArn(model.notificationTopicArn);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.snapshotWindow(model.snapshotWindow);
            this.authToken(model.authToken);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getAzModeAsString() {
            return this.azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(AZMode azMode) {
            this.azMode(azMode.toString());
            return this;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        public final String getPreferredAvailabilityZone() {
            return this.preferredAvailabilityZone;
        }

        @Override
        public final Builder preferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
            return this;
        }

        public final void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
        }

        public final Collection<String> getPreferredAvailabilityZones() {
            return this.preferredAvailabilityZones;
        }

        @Override
        public final Builder preferredAvailabilityZones(Collection<String> preferredAvailabilityZones) {
            this.preferredAvailabilityZones = PreferredAvailabilityZoneListCopier.copy(preferredAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredAvailabilityZones(String ... preferredAvailabilityZones) {
            this.preferredAvailabilityZones(Arrays.asList(preferredAvailabilityZones));
            return this;
        }

        public final void setPreferredAvailabilityZones(Collection<String> preferredAvailabilityZones) {
            this.preferredAvailabilityZones = PreferredAvailabilityZoneListCopier.copy(preferredAvailabilityZones);
        }

        public final Integer getNumCacheNodes() {
            return this.numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            return this.cacheSecurityGroupNames;
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<String> getSnapshotArns() {
            return this.snapshotArns;
        }

        @Override
        public final Builder snapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotArns(String ... snapshotArns) {
            this.snapshotArns(Arrays.asList(snapshotArns));
            return this;
        }

        public final void setSnapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getNotificationTopicArn() {
            return this.notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final String getAuthToken() {
            return this.authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCacheClusterRequest build() {
            return new CreateCacheClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCacheClusterRequest> {
        public Builder cacheClusterId(String var1);

        public Builder replicationGroupId(String var1);

        public Builder azMode(String var1);

        public Builder azMode(AZMode var1);

        public Builder preferredAvailabilityZone(String var1);

        public Builder preferredAvailabilityZones(Collection<String> var1);

        public Builder preferredAvailabilityZones(String ... var1);

        public Builder numCacheNodes(Integer var1);

        public Builder cacheNodeType(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder cacheParameterGroupName(String var1);

        public Builder cacheSubnetGroupName(String var1);

        public Builder cacheSecurityGroupNames(Collection<String> var1);

        public Builder cacheSecurityGroupNames(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder snapshotArns(Collection<String> var1);

        public Builder snapshotArns(String ... var1);

        public Builder snapshotName(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder port(Integer var1);

        public Builder notificationTopicArn(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder authToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

