/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.UpdateActionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProcessedUpdateAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProcessedUpdateAction> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProcessedUpdateAction.getter(ProcessedUpdateAction::replicationGroupId)).setter(ProcessedUpdateAction.setter(Builder::replicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build()}).build();
    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProcessedUpdateAction.getter(ProcessedUpdateAction::serviceUpdateName)).setter(ProcessedUpdateAction.setter(Builder::serviceUpdateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()}).build();
    private static final SdkField<String> UPDATE_ACTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProcessedUpdateAction.getter(ProcessedUpdateAction::updateActionStatusAsString)).setter(ProcessedUpdateAction.setter(Builder::updateActionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateActionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD, SERVICE_UPDATE_NAME_FIELD, UPDATE_ACTION_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String replicationGroupId;
    private final String serviceUpdateName;
    private final String updateActionStatus;

    private ProcessedUpdateAction(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.serviceUpdateName = builder.serviceUpdateName;
        this.updateActionStatus = builder.updateActionStatus;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String serviceUpdateName() {
        return this.serviceUpdateName;
    }

    public UpdateActionStatus updateActionStatus() {
        return UpdateActionStatus.fromValue(this.updateActionStatus);
    }

    public String updateActionStatusAsString() {
        return this.updateActionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateActionStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessedUpdateAction)) {
            return false;
        }
        ProcessedUpdateAction other = (ProcessedUpdateAction)obj;
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.serviceUpdateName(), other.serviceUpdateName()) && Objects.equals(this.updateActionStatusAsString(), other.updateActionStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ProcessedUpdateAction").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("ServiceUpdateName", (Object)this.serviceUpdateName()).add("UpdateActionStatus", (Object)this.updateActionStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "ServiceUpdateName": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateName()));
            }
            case "UpdateActionStatus": {
                return Optional.ofNullable(clazz.cast(this.updateActionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessedUpdateAction, T> g) {
        return obj -> g.apply((ProcessedUpdateAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String serviceUpdateName;
        private String updateActionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessedUpdateAction model) {
            this.replicationGroupId(model.replicationGroupId);
            this.serviceUpdateName(model.serviceUpdateName);
            this.updateActionStatus(model.updateActionStatus);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getServiceUpdateName() {
            return this.serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        public final String getUpdateActionStatusAsString() {
            return this.updateActionStatus;
        }

        @Override
        public final Builder updateActionStatus(String updateActionStatus) {
            this.updateActionStatus = updateActionStatus;
            return this;
        }

        @Override
        public final Builder updateActionStatus(UpdateActionStatus updateActionStatus) {
            this.updateActionStatus(updateActionStatus.toString());
            return this;
        }

        public final void setUpdateActionStatus(String updateActionStatus) {
            this.updateActionStatus = updateActionStatus;
        }

        public ProcessedUpdateAction build() {
            return new ProcessedUpdateAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProcessedUpdateAction> {
        public Builder replicationGroupId(String var1);

        public Builder serviceUpdateName(String var1);

        public Builder updateActionStatus(String var1);

        public Builder updateActionStatus(UpdateActionStatus var1);
    }
}

