/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.elasticache.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.elasticache.model.ApiCallRateForCustomerExceededException;
import software.amazon.awssdk.services.elasticache.model.AuthorizationAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest;
import software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse;
import software.amazon.awssdk.services.elasticache.model.CacheClusterAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheClusterNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupInUseException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.ClusterQuotaForCustomerExceededException;
import software.amazon.awssdk.services.elasticache.model.CopySnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.CopySnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest;
import software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeEventsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheException;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountRequest;
import software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountResponse;
import software.amazon.awssdk.services.elasticache.model.InsufficientCacheClusterCapacityException;
import software.amazon.awssdk.services.elasticache.model.InvalidArnException;
import software.amazon.awssdk.services.elasticache.model.InvalidCacheClusterStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidCacheParameterGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidCacheSecurityGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.elasticache.model.InvalidParameterValueException;
import software.amazon.awssdk.services.elasticache.model.InvalidReplicationGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidSnapshotStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidSubnetException;
import software.amazon.awssdk.services.elasticache.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsRequest;
import software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsResponse;
import software.amazon.awssdk.services.elasticache.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.elasticache.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationResponse;
import software.amazon.awssdk.services.elasticache.model.NoOperationException;
import software.amazon.awssdk.services.elasticache.model.NodeGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.NodeGroupsPerReplicationGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.NodeQuotaForClusterExceededException;
import software.amazon.awssdk.services.elasticache.model.NodeQuotaForCustomerExceededException;
import software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest;
import software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingResponse;
import software.amazon.awssdk.services.elasticache.model.RebootCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.RebootCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodeAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodeNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodeQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOfferingNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest;
import software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressResponse;
import software.amazon.awssdk.services.elasticache.model.ServiceLinkedRoleNotFoundException;
import software.amazon.awssdk.services.elasticache.model.SnapshotAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.SnapshotFeatureNotSupportedException;
import software.amazon.awssdk.services.elasticache.model.SnapshotNotFoundException;
import software.amazon.awssdk.services.elasticache.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.SubnetInUseException;
import software.amazon.awssdk.services.elasticache.model.TagNotFoundException;
import software.amazon.awssdk.services.elasticache.model.TagQuotaPerResourceExceededException;
import software.amazon.awssdk.services.elasticache.model.TestFailoverNotAvailableException;
import software.amazon.awssdk.services.elasticache.model.TestFailoverRequest;
import software.amazon.awssdk.services.elasticache.model.TestFailoverResponse;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheClustersIterable;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheEngineVersionsIterable;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParameterGroupsIterable;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheParametersIterable;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSecurityGroupsIterable;
import software.amazon.awssdk.services.elasticache.paginators.DescribeCacheSubnetGroupsIterable;
import software.amazon.awssdk.services.elasticache.paginators.DescribeEngineDefaultParametersIterable;
import software.amazon.awssdk.services.elasticache.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.elasticache.paginators.DescribeReplicationGroupsIterable;
import software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesIterable;
import software.amazon.awssdk.services.elasticache.paginators.DescribeReservedCacheNodesOfferingsIterable;
import software.amazon.awssdk.services.elasticache.paginators.DescribeSnapshotsIterable;
import software.amazon.awssdk.services.elasticache.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.AuthorizeCacheSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DecreaseReplicaCountRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheClustersRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheParametersRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeEngineDefaultParametersRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeReplicationGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeReservedCacheNodesOfferingsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeReservedCacheNodesRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.IncreaseReplicaCountRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ListAllowedNodeTypeModificationsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyCacheSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyReplicationGroupShardConfigurationRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.PurchaseReservedCacheNodesOfferingRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.RebootCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ResetCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.RevokeCacheSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.TestFailoverRequestMarshaller;

@SdkInternalApi
final class DefaultElastiCacheClient
implements ElastiCacheClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElastiCacheClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "elasticache";
    }

    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) throws CacheClusterNotFoundException, SnapshotNotFoundException, TagQuotaPerResourceExceededException, InvalidArnException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddTagsToResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AddTagsToResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsToResourceRequest).withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AuthorizeCacheSecurityGroupIngressResponse authorizeCacheSecurityGroupIngress(AuthorizeCacheSecurityGroupIngressRequest authorizeCacheSecurityGroupIngressRequest) throws CacheSecurityGroupNotFoundException, InvalidCacheSecurityGroupStateException, AuthorizationAlreadyExistsException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AuthorizeCacheSecurityGroupIngressResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AuthorizeCacheSecurityGroupIngressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AuthorizeCacheSecurityGroupIngress").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)authorizeCacheSecurityGroupIngressRequest).withMarshaller((Marshaller)new AuthorizeCacheSecurityGroupIngressRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CopySnapshotResponse copySnapshot(CopySnapshotRequest copySnapshotRequest) throws SnapshotAlreadyExistsException, SnapshotNotFoundException, SnapshotQuotaExceededException, InvalidSnapshotStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopySnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CopySnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopySnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copySnapshotRequest).withMarshaller((Marshaller)new CopySnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateCacheClusterResponse createCacheCluster(CreateCacheClusterRequest createCacheClusterRequest) throws ReplicationGroupNotFoundException, InvalidReplicationGroupStateException, CacheClusterAlreadyExistsException, InsufficientCacheClusterCapacityException, CacheSecurityGroupNotFoundException, CacheSubnetGroupNotFoundException, ClusterQuotaForCustomerExceededException, NodeQuotaForClusterExceededException, NodeQuotaForCustomerExceededException, CacheParameterGroupNotFoundException, InvalidVpcNetworkStateException, TagQuotaPerResourceExceededException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateCacheClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateCacheClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCacheCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCacheClusterRequest).withMarshaller((Marshaller)new CreateCacheClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateCacheParameterGroupResponse createCacheParameterGroup(CreateCacheParameterGroupRequest createCacheParameterGroupRequest) throws CacheParameterGroupQuotaExceededException, CacheParameterGroupAlreadyExistsException, InvalidCacheParameterGroupStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateCacheParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateCacheParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCacheParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCacheParameterGroupRequest).withMarshaller((Marshaller)new CreateCacheParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateCacheSecurityGroupResponse createCacheSecurityGroup(CreateCacheSecurityGroupRequest createCacheSecurityGroupRequest) throws CacheSecurityGroupAlreadyExistsException, CacheSecurityGroupQuotaExceededException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateCacheSecurityGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateCacheSecurityGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCacheSecurityGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCacheSecurityGroupRequest).withMarshaller((Marshaller)new CreateCacheSecurityGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateCacheSubnetGroupResponse createCacheSubnetGroup(CreateCacheSubnetGroupRequest createCacheSubnetGroupRequest) throws CacheSubnetGroupAlreadyExistsException, CacheSubnetGroupQuotaExceededException, CacheSubnetQuotaExceededException, InvalidSubnetException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateCacheSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateCacheSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCacheSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCacheSubnetGroupRequest).withMarshaller((Marshaller)new CreateCacheSubnetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateReplicationGroupResponse createReplicationGroup(CreateReplicationGroupRequest createReplicationGroupRequest) throws CacheClusterNotFoundException, InvalidCacheClusterStateException, ReplicationGroupAlreadyExistsException, InsufficientCacheClusterCapacityException, CacheSecurityGroupNotFoundException, CacheSubnetGroupNotFoundException, ClusterQuotaForCustomerExceededException, NodeQuotaForClusterExceededException, NodeQuotaForCustomerExceededException, CacheParameterGroupNotFoundException, InvalidVpcNetworkStateException, TagQuotaPerResourceExceededException, NodeGroupsPerReplicationGroupQuotaExceededException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateReplicationGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateReplicationGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReplicationGroupRequest).withMarshaller((Marshaller)new CreateReplicationGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws SnapshotAlreadyExistsException, CacheClusterNotFoundException, ReplicationGroupNotFoundException, InvalidCacheClusterStateException, InvalidReplicationGroupStateException, SnapshotQuotaExceededException, SnapshotFeatureNotSupportedException, InvalidParameterCombinationException, InvalidParameterValueException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSnapshotRequest).withMarshaller((Marshaller)new CreateSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DecreaseReplicaCountResponse decreaseReplicaCount(DecreaseReplicaCountRequest decreaseReplicaCountRequest) throws ReplicationGroupNotFoundException, InvalidReplicationGroupStateException, InvalidCacheClusterStateException, InvalidVpcNetworkStateException, InsufficientCacheClusterCapacityException, ClusterQuotaForCustomerExceededException, NodeGroupsPerReplicationGroupQuotaExceededException, NodeQuotaForCustomerExceededException, ServiceLinkedRoleNotFoundException, NoOperationException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DecreaseReplicaCountResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DecreaseReplicaCountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DecreaseReplicaCount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)decreaseReplicaCountRequest).withMarshaller((Marshaller)new DecreaseReplicaCountRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteCacheClusterResponse deleteCacheCluster(DeleteCacheClusterRequest deleteCacheClusterRequest) throws CacheClusterNotFoundException, InvalidCacheClusterStateException, SnapshotAlreadyExistsException, SnapshotFeatureNotSupportedException, SnapshotQuotaExceededException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteCacheClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteCacheClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCacheCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCacheClusterRequest).withMarshaller((Marshaller)new DeleteCacheClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteCacheParameterGroupResponse deleteCacheParameterGroup(DeleteCacheParameterGroupRequest deleteCacheParameterGroupRequest) throws InvalidCacheParameterGroupStateException, CacheParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteCacheParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteCacheParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCacheParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCacheParameterGroupRequest).withMarshaller((Marshaller)new DeleteCacheParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteCacheSecurityGroupResponse deleteCacheSecurityGroup(DeleteCacheSecurityGroupRequest deleteCacheSecurityGroupRequest) throws InvalidCacheSecurityGroupStateException, CacheSecurityGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteCacheSecurityGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteCacheSecurityGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCacheSecurityGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCacheSecurityGroupRequest).withMarshaller((Marshaller)new DeleteCacheSecurityGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteCacheSubnetGroupResponse deleteCacheSubnetGroup(DeleteCacheSubnetGroupRequest deleteCacheSubnetGroupRequest) throws CacheSubnetGroupInUseException, CacheSubnetGroupNotFoundException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteCacheSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteCacheSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCacheSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCacheSubnetGroupRequest).withMarshaller((Marshaller)new DeleteCacheSubnetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteReplicationGroupResponse deleteReplicationGroup(DeleteReplicationGroupRequest deleteReplicationGroupRequest) throws ReplicationGroupNotFoundException, InvalidReplicationGroupStateException, SnapshotAlreadyExistsException, SnapshotFeatureNotSupportedException, SnapshotQuotaExceededException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteReplicationGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteReplicationGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReplicationGroupRequest).withMarshaller((Marshaller)new DeleteReplicationGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws SnapshotNotFoundException, InvalidSnapshotStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSnapshotRequest).withMarshaller((Marshaller)new DeleteSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeCacheClustersResponse describeCacheClusters(DescribeCacheClustersRequest describeCacheClustersRequest) throws CacheClusterNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCacheClustersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeCacheClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCacheClusters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCacheClustersRequest).withMarshaller((Marshaller)new DescribeCacheClustersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeCacheClustersIterable describeCacheClustersPaginator(DescribeCacheClustersRequest describeCacheClustersRequest) throws CacheClusterNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        return new DescribeCacheClustersIterable(this, this.applyPaginatorUserAgent(describeCacheClustersRequest));
    }

    @Override
    public DescribeCacheEngineVersionsResponse describeCacheEngineVersions(DescribeCacheEngineVersionsRequest describeCacheEngineVersionsRequest) throws AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCacheEngineVersionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeCacheEngineVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCacheEngineVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCacheEngineVersionsRequest).withMarshaller((Marshaller)new DescribeCacheEngineVersionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeCacheEngineVersionsIterable describeCacheEngineVersionsPaginator(DescribeCacheEngineVersionsRequest describeCacheEngineVersionsRequest) throws AwsServiceException, SdkClientException, ElastiCacheException {
        return new DescribeCacheEngineVersionsIterable(this, this.applyPaginatorUserAgent(describeCacheEngineVersionsRequest));
    }

    @Override
    public DescribeCacheParameterGroupsResponse describeCacheParameterGroups(DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest) throws CacheParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCacheParameterGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeCacheParameterGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCacheParameterGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCacheParameterGroupsRequest).withMarshaller((Marshaller)new DescribeCacheParameterGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeCacheParameterGroupsIterable describeCacheParameterGroupsPaginator(DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest) throws CacheParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        return new DescribeCacheParameterGroupsIterable(this, this.applyPaginatorUserAgent(describeCacheParameterGroupsRequest));
    }

    @Override
    public DescribeCacheParametersResponse describeCacheParameters(DescribeCacheParametersRequest describeCacheParametersRequest) throws CacheParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCacheParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeCacheParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCacheParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCacheParametersRequest).withMarshaller((Marshaller)new DescribeCacheParametersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeCacheParametersIterable describeCacheParametersPaginator(DescribeCacheParametersRequest describeCacheParametersRequest) throws CacheParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        return new DescribeCacheParametersIterable(this, this.applyPaginatorUserAgent(describeCacheParametersRequest));
    }

    @Override
    public DescribeCacheSecurityGroupsResponse describeCacheSecurityGroups(DescribeCacheSecurityGroupsRequest describeCacheSecurityGroupsRequest) throws CacheSecurityGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCacheSecurityGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeCacheSecurityGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCacheSecurityGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCacheSecurityGroupsRequest).withMarshaller((Marshaller)new DescribeCacheSecurityGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeCacheSecurityGroupsIterable describeCacheSecurityGroupsPaginator(DescribeCacheSecurityGroupsRequest describeCacheSecurityGroupsRequest) throws CacheSecurityGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        return new DescribeCacheSecurityGroupsIterable(this, this.applyPaginatorUserAgent(describeCacheSecurityGroupsRequest));
    }

    @Override
    public DescribeCacheSubnetGroupsResponse describeCacheSubnetGroups(DescribeCacheSubnetGroupsRequest describeCacheSubnetGroupsRequest) throws CacheSubnetGroupNotFoundException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCacheSubnetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeCacheSubnetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCacheSubnetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCacheSubnetGroupsRequest).withMarshaller((Marshaller)new DescribeCacheSubnetGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeCacheSubnetGroupsIterable describeCacheSubnetGroupsPaginator(DescribeCacheSubnetGroupsRequest describeCacheSubnetGroupsRequest) throws CacheSubnetGroupNotFoundException, AwsServiceException, SdkClientException, ElastiCacheException {
        return new DescribeCacheSubnetGroupsIterable(this, this.applyPaginatorUserAgent(describeCacheSubnetGroupsRequest));
    }

    @Override
    public DescribeEngineDefaultParametersResponse describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEngineDefaultParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEngineDefaultParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEngineDefaultParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEngineDefaultParametersRequest).withMarshaller((Marshaller)new DescribeEngineDefaultParametersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEngineDefaultParametersIterable describeEngineDefaultParametersPaginator(DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        return new DescribeEngineDefaultParametersIterable(this, this.applyPaginatorUserAgent(describeEngineDefaultParametersRequest));
    }

    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest) throws InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        return new DescribeEventsIterable(this, this.applyPaginatorUserAgent(describeEventsRequest));
    }

    @Override
    public DescribeReplicationGroupsResponse describeReplicationGroups(DescribeReplicationGroupsRequest describeReplicationGroupsRequest) throws ReplicationGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReplicationGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeReplicationGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReplicationGroupsRequest).withMarshaller((Marshaller)new DescribeReplicationGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeReplicationGroupsIterable describeReplicationGroupsPaginator(DescribeReplicationGroupsRequest describeReplicationGroupsRequest) throws ReplicationGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        return new DescribeReplicationGroupsIterable(this, this.applyPaginatorUserAgent(describeReplicationGroupsRequest));
    }

    @Override
    public DescribeReservedCacheNodesResponse describeReservedCacheNodes(DescribeReservedCacheNodesRequest describeReservedCacheNodesRequest) throws ReservedCacheNodeNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReservedCacheNodesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeReservedCacheNodesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedCacheNodes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReservedCacheNodesRequest).withMarshaller((Marshaller)new DescribeReservedCacheNodesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeReservedCacheNodesIterable describeReservedCacheNodesPaginator(DescribeReservedCacheNodesRequest describeReservedCacheNodesRequest) throws ReservedCacheNodeNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        return new DescribeReservedCacheNodesIterable(this, this.applyPaginatorUserAgent(describeReservedCacheNodesRequest));
    }

    @Override
    public DescribeReservedCacheNodesOfferingsResponse describeReservedCacheNodesOfferings(DescribeReservedCacheNodesOfferingsRequest describeReservedCacheNodesOfferingsRequest) throws ReservedCacheNodesOfferingNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeReservedCacheNodesOfferingsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeReservedCacheNodesOfferingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedCacheNodesOfferings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReservedCacheNodesOfferingsRequest).withMarshaller((Marshaller)new DescribeReservedCacheNodesOfferingsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeReservedCacheNodesOfferingsIterable describeReservedCacheNodesOfferingsPaginator(DescribeReservedCacheNodesOfferingsRequest describeReservedCacheNodesOfferingsRequest) throws ReservedCacheNodesOfferingNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        return new DescribeReservedCacheNodesOfferingsIterable(this, this.applyPaginatorUserAgent(describeReservedCacheNodesOfferingsRequest));
    }

    @Override
    public DescribeSnapshotsResponse describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) throws CacheClusterNotFoundException, SnapshotNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeSnapshotsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSnapshotsRequest).withMarshaller((Marshaller)new DescribeSnapshotsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeSnapshotsIterable describeSnapshotsPaginator(DescribeSnapshotsRequest describeSnapshotsRequest) throws CacheClusterNotFoundException, SnapshotNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        return new DescribeSnapshotsIterable(this, this.applyPaginatorUserAgent(describeSnapshotsRequest));
    }

    @Override
    public IncreaseReplicaCountResponse increaseReplicaCount(IncreaseReplicaCountRequest increaseReplicaCountRequest) throws ReplicationGroupNotFoundException, InvalidReplicationGroupStateException, InvalidCacheClusterStateException, InvalidVpcNetworkStateException, InsufficientCacheClusterCapacityException, ClusterQuotaForCustomerExceededException, NodeGroupsPerReplicationGroupQuotaExceededException, NodeQuotaForCustomerExceededException, NoOperationException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(IncreaseReplicaCountResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (IncreaseReplicaCountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("IncreaseReplicaCount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)increaseReplicaCountRequest).withMarshaller((Marshaller)new IncreaseReplicaCountRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListAllowedNodeTypeModificationsResponse listAllowedNodeTypeModifications(ListAllowedNodeTypeModificationsRequest listAllowedNodeTypeModificationsRequest) throws CacheClusterNotFoundException, ReplicationGroupNotFoundException, InvalidParameterCombinationException, InvalidParameterValueException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListAllowedNodeTypeModificationsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListAllowedNodeTypeModificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAllowedNodeTypeModifications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAllowedNodeTypeModificationsRequest).withMarshaller((Marshaller)new ListAllowedNodeTypeModificationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws CacheClusterNotFoundException, SnapshotNotFoundException, InvalidArnException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyCacheClusterResponse modifyCacheCluster(ModifyCacheClusterRequest modifyCacheClusterRequest) throws InvalidCacheClusterStateException, InvalidCacheSecurityGroupStateException, InsufficientCacheClusterCapacityException, CacheClusterNotFoundException, NodeQuotaForClusterExceededException, NodeQuotaForCustomerExceededException, CacheSecurityGroupNotFoundException, CacheParameterGroupNotFoundException, InvalidVpcNetworkStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyCacheClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyCacheClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyCacheCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyCacheClusterRequest).withMarshaller((Marshaller)new ModifyCacheClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyCacheParameterGroupResponse modifyCacheParameterGroup(ModifyCacheParameterGroupRequest modifyCacheParameterGroupRequest) throws CacheParameterGroupNotFoundException, InvalidCacheParameterGroupStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyCacheParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyCacheParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyCacheParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyCacheParameterGroupRequest).withMarshaller((Marshaller)new ModifyCacheParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyCacheSubnetGroupResponse modifyCacheSubnetGroup(ModifyCacheSubnetGroupRequest modifyCacheSubnetGroupRequest) throws CacheSubnetGroupNotFoundException, CacheSubnetQuotaExceededException, SubnetInUseException, InvalidSubnetException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyCacheSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyCacheSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyCacheSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyCacheSubnetGroupRequest).withMarshaller((Marshaller)new ModifyCacheSubnetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyReplicationGroupResponse modifyReplicationGroup(ModifyReplicationGroupRequest modifyReplicationGroupRequest) throws ReplicationGroupNotFoundException, InvalidReplicationGroupStateException, InvalidCacheClusterStateException, InvalidCacheSecurityGroupStateException, InsufficientCacheClusterCapacityException, CacheClusterNotFoundException, NodeQuotaForClusterExceededException, NodeQuotaForCustomerExceededException, CacheSecurityGroupNotFoundException, CacheParameterGroupNotFoundException, InvalidVpcNetworkStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyReplicationGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyReplicationGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyReplicationGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyReplicationGroupRequest).withMarshaller((Marshaller)new ModifyReplicationGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyReplicationGroupShardConfigurationResponse modifyReplicationGroupShardConfiguration(ModifyReplicationGroupShardConfigurationRequest modifyReplicationGroupShardConfigurationRequest) throws ReplicationGroupNotFoundException, InvalidReplicationGroupStateException, InvalidCacheClusterStateException, InvalidVpcNetworkStateException, InsufficientCacheClusterCapacityException, NodeGroupsPerReplicationGroupQuotaExceededException, NodeQuotaForCustomerExceededException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyReplicationGroupShardConfigurationResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyReplicationGroupShardConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyReplicationGroupShardConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyReplicationGroupShardConfigurationRequest).withMarshaller((Marshaller)new ModifyReplicationGroupShardConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PurchaseReservedCacheNodesOfferingResponse purchaseReservedCacheNodesOffering(PurchaseReservedCacheNodesOfferingRequest purchaseReservedCacheNodesOfferingRequest) throws ReservedCacheNodesOfferingNotFoundException, ReservedCacheNodeAlreadyExistsException, ReservedCacheNodeQuotaExceededException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PurchaseReservedCacheNodesOfferingResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (PurchaseReservedCacheNodesOfferingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurchaseReservedCacheNodesOffering").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)purchaseReservedCacheNodesOfferingRequest).withMarshaller((Marshaller)new PurchaseReservedCacheNodesOfferingRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RebootCacheClusterResponse rebootCacheCluster(RebootCacheClusterRequest rebootCacheClusterRequest) throws InvalidCacheClusterStateException, CacheClusterNotFoundException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RebootCacheClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RebootCacheClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootCacheCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebootCacheClusterRequest).withMarshaller((Marshaller)new RebootCacheClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) throws CacheClusterNotFoundException, SnapshotNotFoundException, InvalidArnException, TagNotFoundException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveTagsFromResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RemoveTagsFromResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsFromResourceRequest).withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ResetCacheParameterGroupResponse resetCacheParameterGroup(ResetCacheParameterGroupRequest resetCacheParameterGroupRequest) throws InvalidCacheParameterGroupStateException, CacheParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResetCacheParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ResetCacheParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetCacheParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resetCacheParameterGroupRequest).withMarshaller((Marshaller)new ResetCacheParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RevokeCacheSecurityGroupIngressResponse revokeCacheSecurityGroupIngress(RevokeCacheSecurityGroupIngressRequest revokeCacheSecurityGroupIngressRequest) throws CacheSecurityGroupNotFoundException, AuthorizationNotFoundException, InvalidCacheSecurityGroupStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RevokeCacheSecurityGroupIngressResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RevokeCacheSecurityGroupIngressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeCacheSecurityGroupIngress").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)revokeCacheSecurityGroupIngressRequest).withMarshaller((Marshaller)new RevokeCacheSecurityGroupIngressRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public TestFailoverResponse testFailover(TestFailoverRequest testFailoverRequest) throws ApiCallRateForCustomerExceededException, InvalidCacheClusterStateException, InvalidReplicationGroupStateException, NodeGroupNotFoundException, ReplicationGroupNotFoundException, TestFailoverNotAvailableException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TestFailoverResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (TestFailoverResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestFailover").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testFailoverRequest).withMarshaller((Marshaller)new TestFailoverRequestMarshaller(this.protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("ReservedCacheNodeAlreadyExists").exceptionBuilderSupplier(ReservedCacheNodeAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheSubnetGroupNotFoundFault").exceptionBuilderSupplier(CacheSubnetGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheClusterNotFound").exceptionBuilderSupplier(CacheClusterNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetInUse").exceptionBuilderSupplier(SubnetInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheClusterAlreadyExists").exceptionBuilderSupplier(CacheClusterAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterValue").exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheSecurityGroupAlreadyExists").exceptionBuilderSupplier(CacheSecurityGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault").exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidReplicationGroupState").exceptionBuilderSupplier(InvalidReplicationGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCacheSecurityGroupState").exceptionBuilderSupplier(InvalidCacheSecurityGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QuotaExceeded.CacheSecurityGroup").exceptionBuilderSupplier(CacheSecurityGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault").exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheParameterGroupQuotaExceeded").exceptionBuilderSupplier(CacheParameterGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedCacheNodesOfferingNotFound").exceptionBuilderSupplier(ReservedCacheNodesOfferingNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheParameterGroupAlreadyExists").exceptionBuilderSupplier(CacheParameterGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidARN").exceptionBuilderSupplier(InvalidArnException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault").exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceeded").exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheParameterGroupNotFound").exceptionBuilderSupplier(CacheParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagNotFound").exceptionBuilderSupplier(TagNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceeded").exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault").exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceeded").exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceeded").exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCacheClusterState").exceptionBuilderSupplier(InvalidCacheClusterStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheSubnetQuotaExceededFault").exceptionBuilderSupplier(CacheSubnetQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotFeatureNotSupportedFault").exceptionBuilderSupplier(SnapshotFeatureNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NodeGroupNotFoundFault").exceptionBuilderSupplier(NodeGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSnapshotState").exceptionBuilderSupplier(InvalidSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheSubnetGroupAlreadyExists").exceptionBuilderSupplier(CacheSubnetGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheSubnetGroupQuotaExceeded").exceptionBuilderSupplier(CacheSubnetGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReplicationGroupAlreadyExists").exceptionBuilderSupplier(ReplicationGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientCacheClusterCapacity").exceptionBuilderSupplier(InsufficientCacheClusterCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterCombination").exceptionBuilderSupplier(InvalidParameterCombinationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedCacheNodeNotFound").exceptionBuilderSupplier(ReservedCacheNodeNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault").exceptionBuilderSupplier(SnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheSubnetGroupInUse").exceptionBuilderSupplier(CacheSubnetGroupInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CacheSecurityGroupNotFound").exceptionBuilderSupplier(CacheSecurityGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCacheParameterGroupState").exceptionBuilderSupplier(InvalidCacheParameterGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded").exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReplicationGroupNotFoundFault").exceptionBuilderSupplier(ReplicationGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationAlreadyExists").exceptionBuilderSupplier(AuthorizationAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoOperationFault").exceptionBuilderSupplier(NoOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NodeGroupsPerReplicationGroupQuotaExceeded").exceptionBuilderSupplier(NodeGroupsPerReplicationGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedCacheNodeQuotaExceeded").exceptionBuilderSupplier(ReservedCacheNodeQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationNotFound").exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ElastiCacheException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ElastiCacheRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.5.26").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElastiCacheRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

