/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.UserIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserGroupPendingChanges
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserGroupPendingChanges> {
    private static final SdkField<List<String>> USER_IDS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserIdsToRemove").getter(UserGroupPendingChanges.getter(UserGroupPendingChanges::userIdsToRemove)).setter(UserGroupPendingChanges.setter(Builder::userIdsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USER_IDS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserIdsToAdd").getter(UserGroupPendingChanges.getter(UserGroupPendingChanges::userIdsToAdd)).setter(UserGroupPendingChanges.setter(Builder::userIdsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_IDS_TO_REMOVE_FIELD, USER_IDS_TO_ADD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserGroupPendingChanges.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> userIdsToRemove;
    private final List<String> userIdsToAdd;

    private UserGroupPendingChanges(BuilderImpl builder) {
        this.userIdsToRemove = builder.userIdsToRemove;
        this.userIdsToAdd = builder.userIdsToAdd;
    }

    public final boolean hasUserIdsToRemove() {
        return this.userIdsToRemove != null && !(this.userIdsToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> userIdsToRemove() {
        return this.userIdsToRemove;
    }

    public final boolean hasUserIdsToAdd() {
        return this.userIdsToAdd != null && !(this.userIdsToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> userIdsToAdd() {
        return this.userIdsToAdd;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIdsToRemove() ? this.userIdsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIdsToAdd() ? this.userIdsToAdd() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserGroupPendingChanges)) {
            return false;
        }
        UserGroupPendingChanges other = (UserGroupPendingChanges)obj;
        return this.hasUserIdsToRemove() == other.hasUserIdsToRemove() && Objects.equals(this.userIdsToRemove(), other.userIdsToRemove()) && this.hasUserIdsToAdd() == other.hasUserIdsToAdd() && Objects.equals(this.userIdsToAdd(), other.userIdsToAdd());
    }

    public final String toString() {
        return ToString.builder((String)"UserGroupPendingChanges").add("UserIdsToRemove", this.hasUserIdsToRemove() ? this.userIdsToRemove() : null).add("UserIdsToAdd", this.hasUserIdsToAdd() ? this.userIdsToAdd() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserIdsToRemove": {
                return Optional.ofNullable(clazz.cast(this.userIdsToRemove()));
            }
            case "UserIdsToAdd": {
                return Optional.ofNullable(clazz.cast(this.userIdsToAdd()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("UserIdsToRemove", USER_IDS_TO_REMOVE_FIELD);
        map.put("UserIdsToAdd", USER_IDS_TO_ADD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserGroupPendingChanges, T> g) {
        return obj -> g.apply((UserGroupPendingChanges)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> userIdsToRemove = DefaultSdkAutoConstructList.getInstance();
        private List<String> userIdsToAdd = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserGroupPendingChanges model) {
            this.userIdsToRemove(model.userIdsToRemove);
            this.userIdsToAdd(model.userIdsToAdd);
        }

        public final Collection<String> getUserIdsToRemove() {
            if (this.userIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userIdsToRemove;
        }

        public final void setUserIdsToRemove(Collection<String> userIdsToRemove) {
            this.userIdsToRemove = UserIdListCopier.copy(userIdsToRemove);
        }

        @Override
        public final Builder userIdsToRemove(Collection<String> userIdsToRemove) {
            this.userIdsToRemove = UserIdListCopier.copy(userIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdsToRemove(String ... userIdsToRemove) {
            this.userIdsToRemove(Arrays.asList(userIdsToRemove));
            return this;
        }

        public final Collection<String> getUserIdsToAdd() {
            if (this.userIdsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userIdsToAdd;
        }

        public final void setUserIdsToAdd(Collection<String> userIdsToAdd) {
            this.userIdsToAdd = UserIdListCopier.copy(userIdsToAdd);
        }

        @Override
        public final Builder userIdsToAdd(Collection<String> userIdsToAdd) {
            this.userIdsToAdd = UserIdListCopier.copy(userIdsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdsToAdd(String ... userIdsToAdd) {
            this.userIdsToAdd(Arrays.asList(userIdsToAdd));
            return this;
        }

        public UserGroupPendingChanges build() {
            return new UserGroupPendingChanges(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserGroupPendingChanges> {
        public Builder userIdsToRemove(Collection<String> var1);

        public Builder userIdsToRemove(String ... var1);

        public Builder userIdsToAdd(Collection<String> var1);

        public Builder userIdsToAdd(String ... var1);
    }
}

