/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalReplicationGroupMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlobalReplicationGroupMember> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationGroupId").getter(GlobalReplicationGroupMember.getter(GlobalReplicationGroupMember::replicationGroupId)).setter(GlobalReplicationGroupMember.setter(Builder::replicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build()}).build();
    private static final SdkField<String> REPLICATION_GROUP_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationGroupRegion").getter(GlobalReplicationGroupMember.getter(GlobalReplicationGroupMember::replicationGroupRegion)).setter(GlobalReplicationGroupMember.setter(Builder::replicationGroupRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupRegion").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(GlobalReplicationGroupMember.getter(GlobalReplicationGroupMember::role)).setter(GlobalReplicationGroupMember.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> AUTOMATIC_FAILOVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomaticFailover").getter(GlobalReplicationGroupMember.getter(GlobalReplicationGroupMember::automaticFailoverAsString)).setter(GlobalReplicationGroupMember.setter(Builder::automaticFailover)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailover").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GlobalReplicationGroupMember.getter(GlobalReplicationGroupMember::status)).setter(GlobalReplicationGroupMember.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD, REPLICATION_GROUP_REGION_FIELD, ROLE_FIELD, AUTOMATIC_FAILOVER_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GlobalReplicationGroupMember.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String replicationGroupId;
    private final String replicationGroupRegion;
    private final String role;
    private final String automaticFailover;
    private final String status;

    private GlobalReplicationGroupMember(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupRegion = builder.replicationGroupRegion;
        this.role = builder.role;
        this.automaticFailover = builder.automaticFailover;
        this.status = builder.status;
    }

    public final String replicationGroupId() {
        return this.replicationGroupId;
    }

    public final String replicationGroupRegion() {
        return this.replicationGroupRegion;
    }

    public final String role() {
        return this.role;
    }

    public final AutomaticFailoverStatus automaticFailover() {
        return AutomaticFailoverStatus.fromValue(this.automaticFailover);
    }

    public final String automaticFailoverAsString() {
        return this.automaticFailover;
    }

    public final String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticFailoverAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalReplicationGroupMember)) {
            return false;
        }
        GlobalReplicationGroupMember other = (GlobalReplicationGroupMember)obj;
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.replicationGroupRegion(), other.replicationGroupRegion()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.automaticFailoverAsString(), other.automaticFailoverAsString()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"GlobalReplicationGroupMember").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("ReplicationGroupRegion", (Object)this.replicationGroupRegion()).add("Role", (Object)this.role()).add("AutomaticFailover", (Object)this.automaticFailoverAsString()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "ReplicationGroupRegion": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupRegion()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "AutomaticFailover": {
                return Optional.ofNullable(clazz.cast(this.automaticFailoverAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ReplicationGroupId", REPLICATION_GROUP_ID_FIELD);
        map.put("ReplicationGroupRegion", REPLICATION_GROUP_REGION_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("AutomaticFailover", AUTOMATIC_FAILOVER_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlobalReplicationGroupMember, T> g) {
        return obj -> g.apply((GlobalReplicationGroupMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String replicationGroupRegion;
        private String role;
        private String automaticFailover;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalReplicationGroupMember model) {
            this.replicationGroupId(model.replicationGroupId);
            this.replicationGroupRegion(model.replicationGroupRegion);
            this.role(model.role);
            this.automaticFailover(model.automaticFailover);
            this.status(model.status);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final String getReplicationGroupRegion() {
            return this.replicationGroupRegion;
        }

        public final void setReplicationGroupRegion(String replicationGroupRegion) {
            this.replicationGroupRegion = replicationGroupRegion;
        }

        @Override
        public final Builder replicationGroupRegion(String replicationGroupRegion) {
            this.replicationGroupRegion = replicationGroupRegion;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getAutomaticFailover() {
            return this.automaticFailover;
        }

        public final void setAutomaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
        }

        @Override
        public final Builder automaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
            return this;
        }

        @Override
        public final Builder automaticFailover(AutomaticFailoverStatus automaticFailover) {
            this.automaticFailover(automaticFailover == null ? null : automaticFailover.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public GlobalReplicationGroupMember build() {
            return new GlobalReplicationGroupMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlobalReplicationGroupMember> {
        public Builder replicationGroupId(String var1);

        public Builder replicationGroupRegion(String var1);

        public Builder role(String var1);

        public Builder automaticFailover(String var1);

        public Builder automaticFailover(AutomaticFailoverStatus var1);

        public Builder status(String var1);
    }
}

