/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.GlobalNodeGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DecreaseNodeGroupsInGlobalReplicationGroupRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, DecreaseNodeGroupsInGlobalReplicationGroupRequest> {
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalReplicationGroupId").getter(DecreaseNodeGroupsInGlobalReplicationGroupRequest.getter(DecreaseNodeGroupsInGlobalReplicationGroupRequest::globalReplicationGroupId)).setter(DecreaseNodeGroupsInGlobalReplicationGroupRequest.setter(Builder::globalReplicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupId").build()}).build();
    private static final SdkField<Integer> NODE_GROUP_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NodeGroupCount").getter(DecreaseNodeGroupsInGlobalReplicationGroupRequest.getter(DecreaseNodeGroupsInGlobalReplicationGroupRequest::nodeGroupCount)).setter(DecreaseNodeGroupsInGlobalReplicationGroupRequest.setter(Builder::nodeGroupCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupCount").build()}).build();
    private static final SdkField<List<String>> GLOBAL_NODE_GROUPS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalNodeGroupsToRemove").getter(DecreaseNodeGroupsInGlobalReplicationGroupRequest.getter(DecreaseNodeGroupsInGlobalReplicationGroupRequest::globalNodeGroupsToRemove)).setter(DecreaseNodeGroupsInGlobalReplicationGroupRequest.setter(Builder::globalNodeGroupsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNodeGroupsToRemove").build(), ListTrait.builder().memberLocationName("GlobalNodeGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNodeGroupId").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GLOBAL_NODE_GROUPS_TO_RETAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalNodeGroupsToRetain").getter(DecreaseNodeGroupsInGlobalReplicationGroupRequest.getter(DecreaseNodeGroupsInGlobalReplicationGroupRequest::globalNodeGroupsToRetain)).setter(DecreaseNodeGroupsInGlobalReplicationGroupRequest.setter(Builder::globalNodeGroupsToRetain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNodeGroupsToRetain").build(), ListTrait.builder().memberLocationName("GlobalNodeGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNodeGroupId").build()}).build()).build()}).build();
    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApplyImmediately").getter(DecreaseNodeGroupsInGlobalReplicationGroupRequest.getter(DecreaseNodeGroupsInGlobalReplicationGroupRequest::applyImmediately)).setter(DecreaseNodeGroupsInGlobalReplicationGroupRequest.setter(Builder::applyImmediately)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_REPLICATION_GROUP_ID_FIELD, NODE_GROUP_COUNT_FIELD, GLOBAL_NODE_GROUPS_TO_REMOVE_FIELD, GLOBAL_NODE_GROUPS_TO_RETAIN_FIELD, APPLY_IMMEDIATELY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DecreaseNodeGroupsInGlobalReplicationGroupRequest.memberNameToFieldInitializer();
    private final String globalReplicationGroupId;
    private final Integer nodeGroupCount;
    private final List<String> globalNodeGroupsToRemove;
    private final List<String> globalNodeGroupsToRetain;
    private final Boolean applyImmediately;

    private DecreaseNodeGroupsInGlobalReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.globalReplicationGroupId = builder.globalReplicationGroupId;
        this.nodeGroupCount = builder.nodeGroupCount;
        this.globalNodeGroupsToRemove = builder.globalNodeGroupsToRemove;
        this.globalNodeGroupsToRetain = builder.globalNodeGroupsToRetain;
        this.applyImmediately = builder.applyImmediately;
    }

    public final String globalReplicationGroupId() {
        return this.globalReplicationGroupId;
    }

    public final Integer nodeGroupCount() {
        return this.nodeGroupCount;
    }

    public final boolean hasGlobalNodeGroupsToRemove() {
        return this.globalNodeGroupsToRemove != null && !(this.globalNodeGroupsToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> globalNodeGroupsToRemove() {
        return this.globalNodeGroupsToRemove;
    }

    public final boolean hasGlobalNodeGroupsToRetain() {
        return this.globalNodeGroupsToRetain != null && !(this.globalNodeGroupsToRetain instanceof SdkAutoConstructList);
    }

    public final List<String> globalNodeGroupsToRetain() {
        return this.globalNodeGroupsToRetain;
    }

    public final Boolean applyImmediately() {
        return this.applyImmediately;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalReplicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalNodeGroupsToRemove() ? this.globalNodeGroupsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalNodeGroupsToRetain() ? this.globalNodeGroupsToRetain() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecreaseNodeGroupsInGlobalReplicationGroupRequest)) {
            return false;
        }
        DecreaseNodeGroupsInGlobalReplicationGroupRequest other = (DecreaseNodeGroupsInGlobalReplicationGroupRequest)((Object)obj);
        return Objects.equals(this.globalReplicationGroupId(), other.globalReplicationGroupId()) && Objects.equals(this.nodeGroupCount(), other.nodeGroupCount()) && this.hasGlobalNodeGroupsToRemove() == other.hasGlobalNodeGroupsToRemove() && Objects.equals(this.globalNodeGroupsToRemove(), other.globalNodeGroupsToRemove()) && this.hasGlobalNodeGroupsToRetain() == other.hasGlobalNodeGroupsToRetain() && Objects.equals(this.globalNodeGroupsToRetain(), other.globalNodeGroupsToRetain()) && Objects.equals(this.applyImmediately(), other.applyImmediately());
    }

    public final String toString() {
        return ToString.builder((String)"DecreaseNodeGroupsInGlobalReplicationGroupRequest").add("GlobalReplicationGroupId", (Object)this.globalReplicationGroupId()).add("NodeGroupCount", (Object)this.nodeGroupCount()).add("GlobalNodeGroupsToRemove", this.hasGlobalNodeGroupsToRemove() ? this.globalNodeGroupsToRemove() : null).add("GlobalNodeGroupsToRetain", this.hasGlobalNodeGroupsToRetain() ? this.globalNodeGroupsToRetain() : null).add("ApplyImmediately", (Object)this.applyImmediately()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.globalReplicationGroupId()));
            }
            case "NodeGroupCount": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupCount()));
            }
            case "GlobalNodeGroupsToRemove": {
                return Optional.ofNullable(clazz.cast(this.globalNodeGroupsToRemove()));
            }
            case "GlobalNodeGroupsToRetain": {
                return Optional.ofNullable(clazz.cast(this.globalNodeGroupsToRetain()));
            }
            case "ApplyImmediately": {
                return Optional.ofNullable(clazz.cast(this.applyImmediately()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GlobalReplicationGroupId", GLOBAL_REPLICATION_GROUP_ID_FIELD);
        map.put("NodeGroupCount", NODE_GROUP_COUNT_FIELD);
        map.put("GlobalNodeGroupsToRemove", GLOBAL_NODE_GROUPS_TO_REMOVE_FIELD);
        map.put("GlobalNodeGroupsToRetain", GLOBAL_NODE_GROUPS_TO_RETAIN_FIELD);
        map.put("ApplyImmediately", APPLY_IMMEDIATELY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DecreaseNodeGroupsInGlobalReplicationGroupRequest, T> g) {
        return obj -> g.apply((DecreaseNodeGroupsInGlobalReplicationGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String globalReplicationGroupId;
        private Integer nodeGroupCount;
        private List<String> globalNodeGroupsToRemove = DefaultSdkAutoConstructList.getInstance();
        private List<String> globalNodeGroupsToRetain = DefaultSdkAutoConstructList.getInstance();
        private Boolean applyImmediately;

        private BuilderImpl() {
        }

        private BuilderImpl(DecreaseNodeGroupsInGlobalReplicationGroupRequest model) {
            super(model);
            this.globalReplicationGroupId(model.globalReplicationGroupId);
            this.nodeGroupCount(model.nodeGroupCount);
            this.globalNodeGroupsToRemove(model.globalNodeGroupsToRemove);
            this.globalNodeGroupsToRetain(model.globalNodeGroupsToRetain);
            this.applyImmediately(model.applyImmediately);
        }

        public final String getGlobalReplicationGroupId() {
            return this.globalReplicationGroupId;
        }

        public final void setGlobalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
        }

        @Override
        public final Builder globalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        public final Integer getNodeGroupCount() {
            return this.nodeGroupCount;
        }

        public final void setNodeGroupCount(Integer nodeGroupCount) {
            this.nodeGroupCount = nodeGroupCount;
        }

        @Override
        public final Builder nodeGroupCount(Integer nodeGroupCount) {
            this.nodeGroupCount = nodeGroupCount;
            return this;
        }

        public final Collection<String> getGlobalNodeGroupsToRemove() {
            if (this.globalNodeGroupsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.globalNodeGroupsToRemove;
        }

        public final void setGlobalNodeGroupsToRemove(Collection<String> globalNodeGroupsToRemove) {
            this.globalNodeGroupsToRemove = GlobalNodeGroupIdListCopier.copy(globalNodeGroupsToRemove);
        }

        @Override
        public final Builder globalNodeGroupsToRemove(Collection<String> globalNodeGroupsToRemove) {
            this.globalNodeGroupsToRemove = GlobalNodeGroupIdListCopier.copy(globalNodeGroupsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalNodeGroupsToRemove(String ... globalNodeGroupsToRemove) {
            this.globalNodeGroupsToRemove(Arrays.asList(globalNodeGroupsToRemove));
            return this;
        }

        public final Collection<String> getGlobalNodeGroupsToRetain() {
            if (this.globalNodeGroupsToRetain instanceof SdkAutoConstructList) {
                return null;
            }
            return this.globalNodeGroupsToRetain;
        }

        public final void setGlobalNodeGroupsToRetain(Collection<String> globalNodeGroupsToRetain) {
            this.globalNodeGroupsToRetain = GlobalNodeGroupIdListCopier.copy(globalNodeGroupsToRetain);
        }

        @Override
        public final Builder globalNodeGroupsToRetain(Collection<String> globalNodeGroupsToRetain) {
            this.globalNodeGroupsToRetain = GlobalNodeGroupIdListCopier.copy(globalNodeGroupsToRetain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalNodeGroupsToRetain(String ... globalNodeGroupsToRetain) {
            this.globalNodeGroupsToRetain(Arrays.asList(globalNodeGroupsToRetain));
            return this;
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DecreaseNodeGroupsInGlobalReplicationGroupRequest build() {
            return new DecreaseNodeGroupsInGlobalReplicationGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DecreaseNodeGroupsInGlobalReplicationGroupRequest> {
        public Builder globalReplicationGroupId(String var1);

        public Builder nodeGroupCount(Integer var1);

        public Builder globalNodeGroupsToRemove(Collection<String> var1);

        public Builder globalNodeGroupsToRemove(String ... var1);

        public Builder globalNodeGroupsToRetain(Collection<String> var1);

        public Builder globalNodeGroupsToRetain(String ... var1);

        public Builder applyImmediately(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

