/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.DataStorageUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataStorage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataStorage> {
    private static final SdkField<Integer> MAXIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Maximum").getter(DataStorage.getter(DataStorage::maximum)).setter(DataStorage.setter(Builder::maximum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()}).build();
    private static final SdkField<Integer> MINIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Minimum").getter(DataStorage.getter(DataStorage::minimum)).setter(DataStorage.setter(Builder::minimum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Minimum").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(DataStorage.getter(DataStorage::unitAsString)).setter(DataStorage.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_FIELD, MINIMUM_FIELD, UNIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataStorage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer maximum;
    private final Integer minimum;
    private final String unit;

    private DataStorage(BuilderImpl builder) {
        this.maximum = builder.maximum;
        this.minimum = builder.minimum;
        this.unit = builder.unit;
    }

    public final Integer maximum() {
        return this.maximum;
    }

    public final Integer minimum() {
        return this.minimum;
    }

    public final DataStorageUnit unit() {
        return DataStorageUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataStorage)) {
            return false;
        }
        DataStorage other = (DataStorage)obj;
        return Objects.equals(this.maximum(), other.maximum()) && Objects.equals(this.minimum(), other.minimum()) && Objects.equals(this.unitAsString(), other.unitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DataStorage").add("Maximum", (Object)this.maximum()).add("Minimum", (Object)this.minimum()).add("Unit", (Object)this.unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Maximum": {
                return Optional.ofNullable(clazz.cast(this.maximum()));
            }
            case "Minimum": {
                return Optional.ofNullable(clazz.cast(this.minimum()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Maximum", MAXIMUM_FIELD);
        map.put("Minimum", MINIMUM_FIELD);
        map.put("Unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataStorage, T> g) {
        return obj -> g.apply((DataStorage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maximum;
        private Integer minimum;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(DataStorage model) {
            this.maximum(model.maximum);
            this.minimum(model.minimum);
            this.unit(model.unit);
        }

        public final Integer getMaximum() {
            return this.maximum;
        }

        public final void setMaximum(Integer maximum) {
            this.maximum = maximum;
        }

        @Override
        public final Builder maximum(Integer maximum) {
            this.maximum = maximum;
            return this;
        }

        public final Integer getMinimum() {
            return this.minimum;
        }

        public final void setMinimum(Integer minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(Integer minimum) {
            this.minimum = minimum;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(DataStorageUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public DataStorage build() {
            return new DataStorage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataStorage> {
        public Builder maximum(Integer var1);

        public Builder minimum(Integer var1);

        public Builder unit(String var1);

        public Builder unit(DataStorageUnit var1);
    }
}

