/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticache.model.DescribeServerlessCacheSnapshotsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeServerlessCacheSnapshotsResponse;
import software.amazon.awssdk.services.elasticache.model.ServerlessCacheSnapshot;

public class DescribeServerlessCacheSnapshotsIterable
implements SdkIterable<DescribeServerlessCacheSnapshotsResponse> {
    private final ElastiCacheClient client;
    private final DescribeServerlessCacheSnapshotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeServerlessCacheSnapshotsIterable(ElastiCacheClient client, DescribeServerlessCacheSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeServerlessCacheSnapshotsResponseFetcher();
    }

    public Iterator<DescribeServerlessCacheSnapshotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServerlessCacheSnapshot> serverlessCacheSnapshots() {
        Function<DescribeServerlessCacheSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.serverlessCacheSnapshots() != null) {
                return response.serverlessCacheSnapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeServerlessCacheSnapshotsResponseFetcher
    implements SyncPageFetcher<DescribeServerlessCacheSnapshotsResponse> {
        private DescribeServerlessCacheSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServerlessCacheSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeServerlessCacheSnapshotsResponse nextPage(DescribeServerlessCacheSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeServerlessCacheSnapshotsIterable.this.client.describeServerlessCacheSnapshots(DescribeServerlessCacheSnapshotsIterable.this.firstRequest);
            }
            return DescribeServerlessCacheSnapshotsIterable.this.client.describeServerlessCacheSnapshots((DescribeServerlessCacheSnapshotsRequest)((Object)DescribeServerlessCacheSnapshotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

