/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroup;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse;

public class DescribeCacheSecurityGroupsPublisher
implements SdkPublisher<DescribeCacheSecurityGroupsResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeCacheSecurityGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCacheSecurityGroupsPublisher(ElastiCacheAsyncClient client, DescribeCacheSecurityGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCacheSecurityGroupsPublisher(ElastiCacheAsyncClient client, DescribeCacheSecurityGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCacheSecurityGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCacheSecurityGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CacheSecurityGroup> cacheSecurityGroups() {
        Function<DescribeCacheSecurityGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheSecurityGroups() != null) {
                return response.cacheSecurityGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCacheSecurityGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCacheSecurityGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeCacheSecurityGroupsResponse> {
        private DescribeCacheSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheSecurityGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeCacheSecurityGroupsResponse> nextPage(DescribeCacheSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheSecurityGroupsPublisher.this.client.describeCacheSecurityGroups(DescribeCacheSecurityGroupsPublisher.this.firstRequest);
            }
            return DescribeCacheSecurityGroupsPublisher.this.client.describeCacheSecurityGroups((DescribeCacheSecurityGroupsRequest)((Object)DescribeCacheSecurityGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

