/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.elasticache.model.Snapshot;

public class DescribeSnapshotsPublisher
implements SdkPublisher<DescribeSnapshotsResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeSnapshotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSnapshotsPublisher(ElastiCacheAsyncClient client, DescribeSnapshotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSnapshotsPublisher(ElastiCacheAsyncClient client, DescribeSnapshotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSnapshotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSnapshotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Snapshot> snapshots() {
        Function<DescribeSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshots() != null) {
                return response.snapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSnapshotsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeSnapshotsPublisher resume(DescribeSnapshotsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeSnapshotsPublisher(this.client, (DescribeSnapshotsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeSnapshotsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeSnapshotsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeSnapshotsResponseFetcher
    implements AsyncPageFetcher<DescribeSnapshotsResponse> {
        private DescribeSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeSnapshotsResponse> nextPage(DescribeSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSnapshotsPublisher.this.client.describeSnapshots(DescribeSnapshotsPublisher.this.firstRequest);
            }
            return DescribeSnapshotsPublisher.this.client.describeSnapshots((DescribeSnapshotsRequest)((Object)DescribeSnapshotsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

