/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevokeCacheSecurityGroupIngressRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, RevokeCacheSecurityGroupIngressRequest> {
    private static final SdkField<String> CACHE_SECURITY_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheSecurityGroupName").getter(RevokeCacheSecurityGroupIngressRequest.getter(RevokeCacheSecurityGroupIngressRequest::cacheSecurityGroupName)).setter(RevokeCacheSecurityGroupIngressRequest.setter(Builder::cacheSecurityGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupName").build()}).build();
    private static final SdkField<String> EC2_SECURITY_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EC2SecurityGroupName").getter(RevokeCacheSecurityGroupIngressRequest.getter(RevokeCacheSecurityGroupIngressRequest::ec2SecurityGroupName)).setter(RevokeCacheSecurityGroupIngressRequest.setter(Builder::ec2SecurityGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroupName").build()}).build();
    private static final SdkField<String> EC2_SECURITY_GROUP_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EC2SecurityGroupOwnerId").getter(RevokeCacheSecurityGroupIngressRequest.getter(RevokeCacheSecurityGroupIngressRequest::ec2SecurityGroupOwnerId)).setter(RevokeCacheSecurityGroupIngressRequest.setter(Builder::ec2SecurityGroupOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroupOwnerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_SECURITY_GROUP_NAME_FIELD, EC2_SECURITY_GROUP_NAME_FIELD, EC2_SECURITY_GROUP_OWNER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RevokeCacheSecurityGroupIngressRequest.memberNameToFieldInitializer();
    private final String cacheSecurityGroupName;
    private final String ec2SecurityGroupName;
    private final String ec2SecurityGroupOwnerId;

    private RevokeCacheSecurityGroupIngressRequest(BuilderImpl builder) {
        super(builder);
        this.cacheSecurityGroupName = builder.cacheSecurityGroupName;
        this.ec2SecurityGroupName = builder.ec2SecurityGroupName;
        this.ec2SecurityGroupOwnerId = builder.ec2SecurityGroupOwnerId;
    }

    public final String cacheSecurityGroupName() {
        return this.cacheSecurityGroupName;
    }

    public final String ec2SecurityGroupName() {
        return this.ec2SecurityGroupName;
    }

    public final String ec2SecurityGroupOwnerId() {
        return this.ec2SecurityGroupOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroupOwnerId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeCacheSecurityGroupIngressRequest)) {
            return false;
        }
        RevokeCacheSecurityGroupIngressRequest other = (RevokeCacheSecurityGroupIngressRequest)((Object)obj);
        return Objects.equals(this.cacheSecurityGroupName(), other.cacheSecurityGroupName()) && Objects.equals(this.ec2SecurityGroupName(), other.ec2SecurityGroupName()) && Objects.equals(this.ec2SecurityGroupOwnerId(), other.ec2SecurityGroupOwnerId());
    }

    public final String toString() {
        return ToString.builder((String)"RevokeCacheSecurityGroupIngressRequest").add("CacheSecurityGroupName", (Object)this.cacheSecurityGroupName()).add("EC2SecurityGroupName", (Object)this.ec2SecurityGroupName()).add("EC2SecurityGroupOwnerId", (Object)this.ec2SecurityGroupOwnerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheSecurityGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheSecurityGroupName()));
            }
            case "EC2SecurityGroupName": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroupName()));
            }
            case "EC2SecurityGroupOwnerId": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroupOwnerId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CacheSecurityGroupName", CACHE_SECURITY_GROUP_NAME_FIELD);
        map.put("EC2SecurityGroupName", EC2_SECURITY_GROUP_NAME_FIELD);
        map.put("EC2SecurityGroupOwnerId", EC2_SECURITY_GROUP_OWNER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokeCacheSecurityGroupIngressRequest, T> g) {
        return obj -> g.apply((RevokeCacheSecurityGroupIngressRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String cacheSecurityGroupName;
        private String ec2SecurityGroupName;
        private String ec2SecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeCacheSecurityGroupIngressRequest model) {
            super(model);
            this.cacheSecurityGroupName(model.cacheSecurityGroupName);
            this.ec2SecurityGroupName(model.ec2SecurityGroupName);
            this.ec2SecurityGroupOwnerId(model.ec2SecurityGroupOwnerId);
        }

        public final String getCacheSecurityGroupName() {
            return this.cacheSecurityGroupName;
        }

        public final void setCacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
        }

        @Override
        public final Builder cacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
            return this;
        }

        public final String getEc2SecurityGroupName() {
            return this.ec2SecurityGroupName;
        }

        public final void setEc2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
        }

        @Override
        public final Builder ec2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
            return this;
        }

        public final String getEc2SecurityGroupOwnerId() {
            return this.ec2SecurityGroupOwnerId;
        }

        public final void setEc2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
        }

        @Override
        public final Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeCacheSecurityGroupIngressRequest build() {
            return new RevokeCacheSecurityGroupIngressRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RevokeCacheSecurityGroupIngressRequest> {
        public Builder cacheSecurityGroupName(String var1);

        public Builder ec2SecurityGroupName(String var1);

        public Builder ec2SecurityGroupOwnerId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

