/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticache.model.DescribeServerlessCachesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeServerlessCachesResponse;
import software.amazon.awssdk.services.elasticache.model.ServerlessCache;

public class DescribeServerlessCachesPublisher
implements SdkPublisher<DescribeServerlessCachesResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeServerlessCachesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeServerlessCachesPublisher(ElastiCacheAsyncClient client, DescribeServerlessCachesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeServerlessCachesPublisher(ElastiCacheAsyncClient client, DescribeServerlessCachesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeServerlessCachesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeServerlessCachesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServerlessCache> serverlessCaches() {
        Function<DescribeServerlessCachesResponse, Iterator> getIterator = response -> {
            if (response != null && response.serverlessCaches() != null) {
                return response.serverlessCaches().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeServerlessCachesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeServerlessCachesResponseFetcher
    implements AsyncPageFetcher<DescribeServerlessCachesResponse> {
        private DescribeServerlessCachesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServerlessCachesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeServerlessCachesResponse> nextPage(DescribeServerlessCachesResponse previousPage) {
            if (previousPage == null) {
                return DescribeServerlessCachesPublisher.this.client.describeServerlessCaches(DescribeServerlessCachesPublisher.this.firstRequest);
            }
            return DescribeServerlessCachesPublisher.this.client.describeServerlessCaches((DescribeServerlessCachesRequest)((Object)DescribeServerlessCachesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

