/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.Tag;
import software.amazon.awssdk.services.elasticache.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseReservedCacheNodesOfferingRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, PurchaseReservedCacheNodesOfferingRequest> {
    private static final SdkField<String> RESERVED_CACHE_NODES_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedCacheNodesOfferingId").getter(PurchaseReservedCacheNodesOfferingRequest.getter(PurchaseReservedCacheNodesOfferingRequest::reservedCacheNodesOfferingId)).setter(PurchaseReservedCacheNodesOfferingRequest.setter(Builder::reservedCacheNodesOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCacheNodesOfferingId").build()}).build();
    private static final SdkField<String> RESERVED_CACHE_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedCacheNodeId").getter(PurchaseReservedCacheNodesOfferingRequest.getter(PurchaseReservedCacheNodesOfferingRequest::reservedCacheNodeId)).setter(PurchaseReservedCacheNodesOfferingRequest.setter(Builder::reservedCacheNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCacheNodeId").build()}).build();
    private static final SdkField<Integer> CACHE_NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CacheNodeCount").getter(PurchaseReservedCacheNodesOfferingRequest.getter(PurchaseReservedCacheNodesOfferingRequest::cacheNodeCount)).setter(PurchaseReservedCacheNodesOfferingRequest.setter(Builder::cacheNodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeCount").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(PurchaseReservedCacheNodesOfferingRequest.getter(PurchaseReservedCacheNodesOfferingRequest::tags)).setter(PurchaseReservedCacheNodesOfferingRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_CACHE_NODES_OFFERING_ID_FIELD, RESERVED_CACHE_NODE_ID_FIELD, CACHE_NODE_COUNT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ReservedCacheNodesOfferingId", RESERVED_CACHE_NODES_OFFERING_ID_FIELD);
            this.put("ReservedCacheNodeId", RESERVED_CACHE_NODE_ID_FIELD);
            this.put("CacheNodeCount", CACHE_NODE_COUNT_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String reservedCacheNodesOfferingId;
    private final String reservedCacheNodeId;
    private final Integer cacheNodeCount;
    private final List<Tag> tags;

    private PurchaseReservedCacheNodesOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedCacheNodesOfferingId = builder.reservedCacheNodesOfferingId;
        this.reservedCacheNodeId = builder.reservedCacheNodeId;
        this.cacheNodeCount = builder.cacheNodeCount;
        this.tags = builder.tags;
    }

    public final String reservedCacheNodesOfferingId() {
        return this.reservedCacheNodesOfferingId;
    }

    public final String reservedCacheNodeId() {
        return this.reservedCacheNodeId;
    }

    public final Integer cacheNodeCount() {
        return this.cacheNodeCount;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedCacheNodesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedCacheNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedCacheNodesOfferingRequest)) {
            return false;
        }
        PurchaseReservedCacheNodesOfferingRequest other = (PurchaseReservedCacheNodesOfferingRequest)((Object)obj);
        return Objects.equals(this.reservedCacheNodesOfferingId(), other.reservedCacheNodesOfferingId()) && Objects.equals(this.reservedCacheNodeId(), other.reservedCacheNodeId()) && Objects.equals(this.cacheNodeCount(), other.cacheNodeCount()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"PurchaseReservedCacheNodesOfferingRequest").add("ReservedCacheNodesOfferingId", (Object)this.reservedCacheNodesOfferingId()).add("ReservedCacheNodeId", (Object)this.reservedCacheNodeId()).add("CacheNodeCount", (Object)this.cacheNodeCount()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedCacheNodesOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedCacheNodesOfferingId()));
            }
            case "ReservedCacheNodeId": {
                return Optional.ofNullable(clazz.cast(this.reservedCacheNodeId()));
            }
            case "CacheNodeCount": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeCount()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedCacheNodesOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseReservedCacheNodesOfferingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String reservedCacheNodesOfferingId;
        private String reservedCacheNodeId;
        private Integer cacheNodeCount;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedCacheNodesOfferingRequest model) {
            super(model);
            this.reservedCacheNodesOfferingId(model.reservedCacheNodesOfferingId);
            this.reservedCacheNodeId(model.reservedCacheNodeId);
            this.cacheNodeCount(model.cacheNodeCount);
            this.tags(model.tags);
        }

        public final String getReservedCacheNodesOfferingId() {
            return this.reservedCacheNodesOfferingId;
        }

        public final void setReservedCacheNodesOfferingId(String reservedCacheNodesOfferingId) {
            this.reservedCacheNodesOfferingId = reservedCacheNodesOfferingId;
        }

        @Override
        public final Builder reservedCacheNodesOfferingId(String reservedCacheNodesOfferingId) {
            this.reservedCacheNodesOfferingId = reservedCacheNodesOfferingId;
            return this;
        }

        public final String getReservedCacheNodeId() {
            return this.reservedCacheNodeId;
        }

        public final void setReservedCacheNodeId(String reservedCacheNodeId) {
            this.reservedCacheNodeId = reservedCacheNodeId;
        }

        @Override
        public final Builder reservedCacheNodeId(String reservedCacheNodeId) {
            this.reservedCacheNodeId = reservedCacheNodeId;
            return this;
        }

        public final Integer getCacheNodeCount() {
            return this.cacheNodeCount;
        }

        public final void setCacheNodeCount(Integer cacheNodeCount) {
            this.cacheNodeCount = cacheNodeCount;
        }

        @Override
        public final Builder cacheNodeCount(Integer cacheNodeCount) {
            this.cacheNodeCount = cacheNodeCount;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedCacheNodesOfferingRequest build() {
            return new PurchaseReservedCacheNodesOfferingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseReservedCacheNodesOfferingRequest> {
        public Builder reservedCacheNodesOfferingId(String var1);

        public Builder reservedCacheNodeId(String var1);

        public Builder cacheNodeCount(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

