/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCacheEngineVersionsRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, DescribeCacheEngineVersionsRequest> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(DescribeCacheEngineVersionsRequest.getter(DescribeCacheEngineVersionsRequest::engine)).setter(DescribeCacheEngineVersionsRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(DescribeCacheEngineVersionsRequest.getter(DescribeCacheEngineVersionsRequest::engineVersion)).setter(DescribeCacheEngineVersionsRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> CACHE_PARAMETER_GROUP_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheParameterGroupFamily").getter(DescribeCacheEngineVersionsRequest.getter(DescribeCacheEngineVersionsRequest::cacheParameterGroupFamily)).setter(DescribeCacheEngineVersionsRequest.setter(Builder::cacheParameterGroupFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupFamily").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeCacheEngineVersionsRequest.getter(DescribeCacheEngineVersionsRequest::maxRecords)).setter(DescribeCacheEngineVersionsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeCacheEngineVersionsRequest.getter(DescribeCacheEngineVersionsRequest::marker)).setter(DescribeCacheEngineVersionsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Boolean> DEFAULT_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DefaultOnly").getter(DescribeCacheEngineVersionsRequest.getter(DescribeCacheEngineVersionsRequest::defaultOnly)).setter(DescribeCacheEngineVersionsRequest.setter(Builder::defaultOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOnly").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD, ENGINE_VERSION_FIELD, CACHE_PARAMETER_GROUP_FAMILY_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD, DEFAULT_ONLY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Engine", ENGINE_FIELD);
            this.put("EngineVersion", ENGINE_VERSION_FIELD);
            this.put("CacheParameterGroupFamily", CACHE_PARAMETER_GROUP_FAMILY_FIELD);
            this.put("MaxRecords", MAX_RECORDS_FIELD);
            this.put("Marker", MARKER_FIELD);
            this.put("DefaultOnly", DEFAULT_ONLY_FIELD);
        }
    });
    private final String engine;
    private final String engineVersion;
    private final String cacheParameterGroupFamily;
    private final Integer maxRecords;
    private final String marker;
    private final Boolean defaultOnly;

    private DescribeCacheEngineVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheParameterGroupFamily = builder.cacheParameterGroupFamily;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.defaultOnly = builder.defaultOnly;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String cacheParameterGroupFamily() {
        return this.cacheParameterGroupFamily;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    public final String marker() {
        return this.marker;
    }

    public final Boolean defaultOnly() {
        return this.defaultOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultOnly());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheEngineVersionsRequest)) {
            return false;
        }
        DescribeCacheEngineVersionsRequest other = (DescribeCacheEngineVersionsRequest)((Object)obj);
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.cacheParameterGroupFamily(), other.cacheParameterGroupFamily()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.defaultOnly(), other.defaultOnly());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCacheEngineVersionsRequest").add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("CacheParameterGroupFamily", (Object)this.cacheParameterGroupFamily()).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).add("DefaultOnly", (Object)this.defaultOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "CacheParameterGroupFamily": {
                return Optional.ofNullable(clazz.cast(this.cacheParameterGroupFamily()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DefaultOnly": {
                return Optional.ofNullable(clazz.cast(this.defaultOnly()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCacheEngineVersionsRequest, T> g) {
        return obj -> g.apply((DescribeCacheEngineVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String cacheParameterGroupFamily;
        private Integer maxRecords;
        private String marker;
        private Boolean defaultOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheEngineVersionsRequest model) {
            super(model);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.cacheParameterGroupFamily(model.cacheParameterGroupFamily);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
            this.defaultOnly(model.defaultOnly);
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getCacheParameterGroupFamily() {
            return this.cacheParameterGroupFamily;
        }

        public final void setCacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
        }

        @Override
        public final Builder cacheParameterGroupFamily(String cacheParameterGroupFamily) {
            this.cacheParameterGroupFamily = cacheParameterGroupFamily;
            return this;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Boolean getDefaultOnly() {
            return this.defaultOnly;
        }

        public final void setDefaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
        }

        @Override
        public final Builder defaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCacheEngineVersionsRequest build() {
            return new DescribeCacheEngineVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCacheEngineVersionsRequest> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder cacheParameterGroupFamily(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder defaultOnly(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

