/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.DestinationDetails;
import software.amazon.awssdk.services.elasticache.model.DestinationType;
import software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationStatus;
import software.amazon.awssdk.services.elasticache.model.LogFormat;
import software.amazon.awssdk.services.elasticache.model.LogType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogDeliveryConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogDeliveryConfiguration> {
    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogType").getter(LogDeliveryConfiguration.getter(LogDeliveryConfiguration::logTypeAsString)).setter(LogDeliveryConfiguration.setter(Builder::logType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogType").build()}).build();
    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationType").getter(LogDeliveryConfiguration.getter(LogDeliveryConfiguration::destinationTypeAsString)).setter(LogDeliveryConfiguration.setter(Builder::destinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationType").build()}).build();
    private static final SdkField<DestinationDetails> DESTINATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationDetails").getter(LogDeliveryConfiguration.getter(LogDeliveryConfiguration::destinationDetails)).setter(LogDeliveryConfiguration.setter(Builder::destinationDetails)).constructor(DestinationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDetails").build()}).build();
    private static final SdkField<String> LOG_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogFormat").getter(LogDeliveryConfiguration.getter(LogDeliveryConfiguration::logFormatAsString)).setter(LogDeliveryConfiguration.setter(Builder::logFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFormat").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(LogDeliveryConfiguration.getter(LogDeliveryConfiguration::statusAsString)).setter(LogDeliveryConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(LogDeliveryConfiguration.getter(LogDeliveryConfiguration::message)).setter(LogDeliveryConfiguration.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TYPE_FIELD, DESTINATION_TYPE_FIELD, DESTINATION_DETAILS_FIELD, LOG_FORMAT_FIELD, STATUS_FIELD, MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logType;
    private final String destinationType;
    private final DestinationDetails destinationDetails;
    private final String logFormat;
    private final String status;
    private final String message;

    private LogDeliveryConfiguration(BuilderImpl builder) {
        this.logType = builder.logType;
        this.destinationType = builder.destinationType;
        this.destinationDetails = builder.destinationDetails;
        this.logFormat = builder.logFormat;
        this.status = builder.status;
        this.message = builder.message;
    }

    public final LogType logType() {
        return LogType.fromValue(this.logType);
    }

    public final String logTypeAsString() {
        return this.logType;
    }

    public final DestinationType destinationType() {
        return DestinationType.fromValue(this.destinationType);
    }

    public final String destinationTypeAsString() {
        return this.destinationType;
    }

    public final DestinationDetails destinationDetails() {
        return this.destinationDetails;
    }

    public final LogFormat logFormat() {
        return LogFormat.fromValue(this.logFormat);
    }

    public final String logFormatAsString() {
        return this.logFormat;
    }

    public final LogDeliveryConfigurationStatus status() {
        return LogDeliveryConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogDeliveryConfiguration)) {
            return false;
        }
        LogDeliveryConfiguration other = (LogDeliveryConfiguration)obj;
        return Objects.equals(this.logTypeAsString(), other.logTypeAsString()) && Objects.equals(this.destinationTypeAsString(), other.destinationTypeAsString()) && Objects.equals(this.destinationDetails(), other.destinationDetails()) && Objects.equals(this.logFormatAsString(), other.logFormatAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"LogDeliveryConfiguration").add("LogType", (Object)this.logTypeAsString()).add("DestinationType", (Object)this.destinationTypeAsString()).add("DestinationDetails", (Object)this.destinationDetails()).add("LogFormat", (Object)this.logFormatAsString()).add("Status", (Object)this.statusAsString()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogType": {
                return Optional.ofNullable(clazz.cast(this.logTypeAsString()));
            }
            case "DestinationType": {
                return Optional.ofNullable(clazz.cast(this.destinationTypeAsString()));
            }
            case "DestinationDetails": {
                return Optional.ofNullable(clazz.cast(this.destinationDetails()));
            }
            case "LogFormat": {
                return Optional.ofNullable(clazz.cast(this.logFormatAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogDeliveryConfiguration, T> g) {
        return obj -> g.apply((LogDeliveryConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logType;
        private String destinationType;
        private DestinationDetails destinationDetails;
        private String logFormat;
        private String status;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(LogDeliveryConfiguration model) {
            this.logType(model.logType);
            this.destinationType(model.destinationType);
            this.destinationDetails(model.destinationDetails);
            this.logFormat(model.logFormat);
            this.status(model.status);
            this.message(model.message);
        }

        public final String getLogType() {
            return this.logType;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public final String getDestinationType() {
            return this.destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(DestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final DestinationDetails.Builder getDestinationDetails() {
            return this.destinationDetails != null ? this.destinationDetails.toBuilder() : null;
        }

        public final void setDestinationDetails(DestinationDetails.BuilderImpl destinationDetails) {
            this.destinationDetails = destinationDetails != null ? destinationDetails.build() : null;
        }

        @Override
        public final Builder destinationDetails(DestinationDetails destinationDetails) {
            this.destinationDetails = destinationDetails;
            return this;
        }

        public final String getLogFormat() {
            return this.logFormat;
        }

        public final void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }

        @Override
        public final Builder logFormat(String logFormat) {
            this.logFormat = logFormat;
            return this;
        }

        @Override
        public final Builder logFormat(LogFormat logFormat) {
            this.logFormat(logFormat == null ? null : logFormat.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LogDeliveryConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public LogDeliveryConfiguration build() {
            return new LogDeliveryConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogDeliveryConfiguration> {
        public Builder logType(String var1);

        public Builder logType(LogType var1);

        public Builder destinationType(String var1);

        public Builder destinationType(DestinationType var1);

        public Builder destinationDetails(DestinationDetails var1);

        default public Builder destinationDetails(Consumer<DestinationDetails.Builder> destinationDetails) {
            return this.destinationDetails((DestinationDetails)((DestinationDetails.Builder)DestinationDetails.builder().applyMutation(destinationDetails)).build());
        }

        public Builder logFormat(String var1);

        public Builder logFormat(LogFormat var1);

        public Builder status(String var1);

        public Builder status(LogDeliveryConfigurationStatus var1);

        public Builder message(String var1);
    }
}

