/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UpdateActionStatus {
    NOT_APPLIED("not-applied"),
    WAITING_TO_START("waiting-to-start"),
    IN_PROGRESS("in-progress"),
    STOPPING("stopping"),
    STOPPED("stopped"),
    COMPLETE("complete"),
    SCHEDULING("scheduling"),
    SCHEDULED("scheduled"),
    NOT_APPLICABLE("not-applicable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UpdateActionStatus> VALUE_MAP;
    private final String value;

    private UpdateActionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UpdateActionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UpdateActionStatus> knownValues() {
        EnumSet<UpdateActionStatus> knownValues = EnumSet.allOf(UpdateActionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UpdateActionStatus.class, UpdateActionStatus::toString);
    }
}

