/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CacheUsageLimits;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupIdsListCopier;
import software.amazon.awssdk.services.elasticache.model.SnapshotArnsListCopier;
import software.amazon.awssdk.services.elasticache.model.SubnetIdsListCopier;
import software.amazon.awssdk.services.elasticache.model.Tag;
import software.amazon.awssdk.services.elasticache.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServerlessCacheRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, CreateServerlessCacheRequest> {
    private static final SdkField<String> SERVERLESS_CACHE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerlessCacheName").getter(CreateServerlessCacheRequest.getter(CreateServerlessCacheRequest::serverlessCacheName)).setter(CreateServerlessCacheRequest.setter(Builder::serverlessCacheName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateServerlessCacheRequest.getter(CreateServerlessCacheRequest::description)).setter(CreateServerlessCacheRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(CreateServerlessCacheRequest.getter(CreateServerlessCacheRequest::engine)).setter(CreateServerlessCacheRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MajorEngineVersion").getter(CreateServerlessCacheRequest.getter(CreateServerlessCacheRequest::majorEngineVersion)).setter(CreateServerlessCacheRequest.setter(Builder::majorEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build()}).build();
    private static final SdkField<CacheUsageLimits> CACHE_USAGE_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CacheUsageLimits").getter(CreateServerlessCacheRequest.getter(CreateServerlessCacheRequest::cacheUsageLimits)).setter(CreateServerlessCacheRequest.setter(Builder::cacheUsageLimits)).constructor(CacheUsageLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheUsageLimits").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateServerlessCacheRequest.getter(CreateServerlessCacheRequest::kmsKeyId)).setter(CreateServerlessCacheRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(CreateServerlessCacheRequest.getter(CreateServerlessCacheRequest::securityGroupIds)).setter(CreateServerlessCacheRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SNAPSHOT_ARNS_TO_RESTORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnapshotArnsToRestore").getter(CreateServerlessCacheRequest.getter(CreateServerlessCacheRequest::snapshotArnsToRestore)).setter(CreateServerlessCacheRequest.setter(Builder::snapshotArnsToRestore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArnsToRestore").build(), ListTrait.builder().memberLocationName("SnapshotArn").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArn").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateServerlessCacheRequest.getter(CreateServerlessCacheRequest::tags)).setter(CreateServerlessCacheRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<String> USER_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserGroupId").getter(CreateServerlessCacheRequest.getter(CreateServerlessCacheRequest::userGroupId)).setter(CreateServerlessCacheRequest.setter(Builder::userGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(CreateServerlessCacheRequest.getter(CreateServerlessCacheRequest::subnetIds)).setter(CreateServerlessCacheRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName("SubnetId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build()).build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SnapshotRetentionLimit").getter(CreateServerlessCacheRequest.getter(CreateServerlessCacheRequest::snapshotRetentionLimit)).setter(CreateServerlessCacheRequest.setter(Builder::snapshotRetentionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build()}).build();
    private static final SdkField<String> DAILY_SNAPSHOT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DailySnapshotTime").getter(CreateServerlessCacheRequest.getter(CreateServerlessCacheRequest::dailySnapshotTime)).setter(CreateServerlessCacheRequest.setter(Builder::dailySnapshotTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailySnapshotTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERLESS_CACHE_NAME_FIELD, DESCRIPTION_FIELD, ENGINE_FIELD, MAJOR_ENGINE_VERSION_FIELD, CACHE_USAGE_LIMITS_FIELD, KMS_KEY_ID_FIELD, SECURITY_GROUP_IDS_FIELD, SNAPSHOT_ARNS_TO_RESTORE_FIELD, TAGS_FIELD, USER_GROUP_ID_FIELD, SUBNET_IDS_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, DAILY_SNAPSHOT_TIME_FIELD));
    private final String serverlessCacheName;
    private final String description;
    private final String engine;
    private final String majorEngineVersion;
    private final CacheUsageLimits cacheUsageLimits;
    private final String kmsKeyId;
    private final List<String> securityGroupIds;
    private final List<String> snapshotArnsToRestore;
    private final List<Tag> tags;
    private final String userGroupId;
    private final List<String> subnetIds;
    private final Integer snapshotRetentionLimit;
    private final String dailySnapshotTime;

    private CreateServerlessCacheRequest(BuilderImpl builder) {
        super(builder);
        this.serverlessCacheName = builder.serverlessCacheName;
        this.description = builder.description;
        this.engine = builder.engine;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.cacheUsageLimits = builder.cacheUsageLimits;
        this.kmsKeyId = builder.kmsKeyId;
        this.securityGroupIds = builder.securityGroupIds;
        this.snapshotArnsToRestore = builder.snapshotArnsToRestore;
        this.tags = builder.tags;
        this.userGroupId = builder.userGroupId;
        this.subnetIds = builder.subnetIds;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.dailySnapshotTime = builder.dailySnapshotTime;
    }

    public final String serverlessCacheName() {
        return this.serverlessCacheName;
    }

    public final String description() {
        return this.description;
    }

    public final String engine() {
        return this.engine;
    }

    public final String majorEngineVersion() {
        return this.majorEngineVersion;
    }

    public final CacheUsageLimits cacheUsageLimits() {
        return this.cacheUsageLimits;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasSnapshotArnsToRestore() {
        return this.snapshotArnsToRestore != null && !(this.snapshotArnsToRestore instanceof SdkAutoConstructList);
    }

    public final List<String> snapshotArnsToRestore() {
        return this.snapshotArnsToRestore;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String userGroupId() {
        return this.userGroupId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public final String dailySnapshotTime() {
        return this.dailySnapshotTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessCacheName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheUsageLimits());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshotArnsToRestore() ? this.snapshotArnsToRestore() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailySnapshotTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServerlessCacheRequest)) {
            return false;
        }
        CreateServerlessCacheRequest other = (CreateServerlessCacheRequest)((Object)obj);
        return Objects.equals(this.serverlessCacheName(), other.serverlessCacheName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.majorEngineVersion(), other.majorEngineVersion()) && Objects.equals(this.cacheUsageLimits(), other.cacheUsageLimits()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasSnapshotArnsToRestore() == other.hasSnapshotArnsToRestore() && Objects.equals(this.snapshotArnsToRestore(), other.snapshotArnsToRestore()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.userGroupId(), other.userGroupId()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.dailySnapshotTime(), other.dailySnapshotTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServerlessCacheRequest").add("ServerlessCacheName", (Object)this.serverlessCacheName()).add("Description", (Object)this.description()).add("Engine", (Object)this.engine()).add("MajorEngineVersion", (Object)this.majorEngineVersion()).add("CacheUsageLimits", (Object)this.cacheUsageLimits()).add("KmsKeyId", (Object)this.kmsKeyId()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SnapshotArnsToRestore", this.hasSnapshotArnsToRestore() ? this.snapshotArnsToRestore() : null).add("Tags", this.hasTags() ? this.tags() : null).add("UserGroupId", (Object)this.userGroupId()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("DailySnapshotTime", (Object)this.dailySnapshotTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerlessCacheName": {
                return Optional.ofNullable(clazz.cast(this.serverlessCacheName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "MajorEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.majorEngineVersion()));
            }
            case "CacheUsageLimits": {
                return Optional.ofNullable(clazz.cast(this.cacheUsageLimits()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SnapshotArnsToRestore": {
                return Optional.ofNullable(clazz.cast(this.snapshotArnsToRestore()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UserGroupId": {
                return Optional.ofNullable(clazz.cast(this.userGroupId()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "DailySnapshotTime": {
                return Optional.ofNullable(clazz.cast(this.dailySnapshotTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServerlessCacheRequest, T> g) {
        return obj -> g.apply((CreateServerlessCacheRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String serverlessCacheName;
        private String description;
        private String engine;
        private String majorEngineVersion;
        private CacheUsageLimits cacheUsageLimits;
        private String kmsKeyId;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> snapshotArnsToRestore = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String userGroupId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private Integer snapshotRetentionLimit;
        private String dailySnapshotTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServerlessCacheRequest model) {
            super(model);
            this.serverlessCacheName(model.serverlessCacheName);
            this.description(model.description);
            this.engine(model.engine);
            this.majorEngineVersion(model.majorEngineVersion);
            this.cacheUsageLimits(model.cacheUsageLimits);
            this.kmsKeyId(model.kmsKeyId);
            this.securityGroupIds(model.securityGroupIds);
            this.snapshotArnsToRestore(model.snapshotArnsToRestore);
            this.tags(model.tags);
            this.userGroupId(model.userGroupId);
            this.subnetIds(model.subnetIds);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.dailySnapshotTime(model.dailySnapshotTime);
        }

        public final String getServerlessCacheName() {
            return this.serverlessCacheName;
        }

        public final void setServerlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
        }

        @Override
        public final Builder serverlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final CacheUsageLimits.Builder getCacheUsageLimits() {
            return this.cacheUsageLimits != null ? this.cacheUsageLimits.toBuilder() : null;
        }

        public final void setCacheUsageLimits(CacheUsageLimits.BuilderImpl cacheUsageLimits) {
            this.cacheUsageLimits = cacheUsageLimits != null ? cacheUsageLimits.build() : null;
        }

        @Override
        public final Builder cacheUsageLimits(CacheUsageLimits cacheUsageLimits) {
            this.cacheUsageLimits = cacheUsageLimits;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSnapshotArnsToRestore() {
            if (this.snapshotArnsToRestore instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snapshotArnsToRestore;
        }

        public final void setSnapshotArnsToRestore(Collection<String> snapshotArnsToRestore) {
            this.snapshotArnsToRestore = SnapshotArnsListCopier.copy(snapshotArnsToRestore);
        }

        @Override
        public final Builder snapshotArnsToRestore(Collection<String> snapshotArnsToRestore) {
            this.snapshotArnsToRestore = SnapshotArnsListCopier.copy(snapshotArnsToRestore);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotArnsToRestore(String ... snapshotArnsToRestore) {
            this.snapshotArnsToRestore(Arrays.asList(snapshotArnsToRestore));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserGroupId() {
            return this.userGroupId;
        }

        public final void setUserGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
        }

        @Override
        public final Builder userGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getDailySnapshotTime() {
            return this.dailySnapshotTime;
        }

        public final void setDailySnapshotTime(String dailySnapshotTime) {
            this.dailySnapshotTime = dailySnapshotTime;
        }

        @Override
        public final Builder dailySnapshotTime(String dailySnapshotTime) {
            this.dailySnapshotTime = dailySnapshotTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServerlessCacheRequest build() {
            return new CreateServerlessCacheRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServerlessCacheRequest> {
        public Builder serverlessCacheName(String var1);

        public Builder description(String var1);

        public Builder engine(String var1);

        public Builder majorEngineVersion(String var1);

        public Builder cacheUsageLimits(CacheUsageLimits var1);

        default public Builder cacheUsageLimits(Consumer<CacheUsageLimits.Builder> cacheUsageLimits) {
            return this.cacheUsageLimits((CacheUsageLimits)((CacheUsageLimits.Builder)CacheUsageLimits.builder().applyMutation(cacheUsageLimits)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder snapshotArnsToRestore(Collection<String> var1);

        public Builder snapshotArnsToRestore(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder userGroupId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder dailySnapshotTime(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

