/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroup;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse;

public class DescribeCacheSubnetGroupsPublisher
implements SdkPublisher<DescribeCacheSubnetGroupsResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeCacheSubnetGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCacheSubnetGroupsPublisher(ElastiCacheAsyncClient client, DescribeCacheSubnetGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCacheSubnetGroupsPublisher(ElastiCacheAsyncClient client, DescribeCacheSubnetGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCacheSubnetGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCacheSubnetGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CacheSubnetGroup> cacheSubnetGroups() {
        Function<DescribeCacheSubnetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheSubnetGroups() != null) {
                return response.cacheSubnetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCacheSubnetGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCacheSubnetGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeCacheSubnetGroupsResponse> {
        private DescribeCacheSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheSubnetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeCacheSubnetGroupsResponse> nextPage(DescribeCacheSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheSubnetGroupsPublisher.this.client.describeCacheSubnetGroups(DescribeCacheSubnetGroupsPublisher.this.firstRequest);
            }
            return DescribeCacheSubnetGroupsPublisher.this.client.describeCacheSubnetGroups((DescribeCacheSubnetGroupsRequest)((Object)DescribeCacheSubnetGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

