/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse;
import software.amazon.awssdk.services.elasticache.model.UpdateAction;

public class DescribeUpdateActionsPublisher
implements SdkPublisher<DescribeUpdateActionsResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeUpdateActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeUpdateActionsPublisher(ElastiCacheAsyncClient client, DescribeUpdateActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeUpdateActionsPublisher(ElastiCacheAsyncClient client, DescribeUpdateActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeUpdateActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeUpdateActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UpdateAction> updateActions() {
        Function<DescribeUpdateActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.updateActions() != null) {
                return response.updateActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeUpdateActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeUpdateActionsResponseFetcher
    implements AsyncPageFetcher<DescribeUpdateActionsResponse> {
        private DescribeUpdateActionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeUpdateActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeUpdateActionsResponse> nextPage(DescribeUpdateActionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeUpdateActionsPublisher.this.client.describeUpdateActions(DescribeUpdateActionsPublisher.this.firstRequest);
            }
            return DescribeUpdateActionsPublisher.this.client.describeUpdateActions((DescribeUpdateActionsRequest)((Object)DescribeUpdateActionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

