/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elasticache.DefaultElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.DefaultElastiCacheBaseClientBuilder;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClientBuilder;
import software.amazon.awssdk.services.elasticache.ElastiCacheServiceClientConfiguration;
import software.amazon.awssdk.services.elasticache.endpoints.ElastiCacheEndpointProvider;

@SdkInternalApi
final class DefaultElastiCacheAsyncClientBuilder
extends DefaultElastiCacheBaseClientBuilder<ElastiCacheAsyncClientBuilder, ElastiCacheAsyncClient>
implements ElastiCacheAsyncClientBuilder {
    DefaultElastiCacheAsyncClientBuilder() {
    }

    @Override
    public DefaultElastiCacheAsyncClientBuilder endpointProvider(ElastiCacheEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ElastiCacheAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultElastiCacheAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        ElastiCacheServiceClientConfiguration serviceClientConfiguration = ElastiCacheServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultElastiCacheAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

