/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeUpdateStatus {
    NOT_APPLIED("not-applied"),
    WAITING_TO_START("waiting-to-start"),
    IN_PROGRESS("in-progress"),
    STOPPING("stopping"),
    STOPPED("stopped"),
    COMPLETE("complete"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeUpdateStatus> VALUE_MAP;
    private final String value;

    private NodeUpdateStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeUpdateStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeUpdateStatus> knownValues() {
        EnumSet<NodeUpdateStatus> knownValues = EnumSet.allOf(NodeUpdateStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeUpdateStatus.class, NodeUpdateStatus::toString);
    }
}

