/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration;
import software.amazon.awssdk.services.elasticache.model.ReshardingConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegionalConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegionalConfiguration> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationGroupId").getter(RegionalConfiguration.getter(RegionalConfiguration::replicationGroupId)).setter(RegionalConfiguration.setter(Builder::replicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build()}).build();
    private static final SdkField<String> REPLICATION_GROUP_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationGroupRegion").getter(RegionalConfiguration.getter(RegionalConfiguration::replicationGroupRegion)).setter(RegionalConfiguration.setter(Builder::replicationGroupRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupRegion").build()}).build();
    private static final SdkField<List<ReshardingConfiguration>> RESHARDING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReshardingConfiguration").getter(RegionalConfiguration.getter(RegionalConfiguration::reshardingConfiguration)).setter(RegionalConfiguration.setter(Builder::reshardingConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReshardingConfiguration").build(), ListTrait.builder().memberLocationName("ReshardingConfiguration").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReshardingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReshardingConfiguration").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD, REPLICATION_GROUP_REGION_FIELD, RESHARDING_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String replicationGroupId;
    private final String replicationGroupRegion;
    private final List<ReshardingConfiguration> reshardingConfiguration;

    private RegionalConfiguration(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupRegion = builder.replicationGroupRegion;
        this.reshardingConfiguration = builder.reshardingConfiguration;
    }

    public final String replicationGroupId() {
        return this.replicationGroupId;
    }

    public final String replicationGroupRegion() {
        return this.replicationGroupRegion;
    }

    public final boolean hasReshardingConfiguration() {
        return this.reshardingConfiguration != null && !(this.reshardingConfiguration instanceof SdkAutoConstructList);
    }

    public final List<ReshardingConfiguration> reshardingConfiguration() {
        return this.reshardingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReshardingConfiguration() ? this.reshardingConfiguration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionalConfiguration)) {
            return false;
        }
        RegionalConfiguration other = (RegionalConfiguration)obj;
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.replicationGroupRegion(), other.replicationGroupRegion()) && this.hasReshardingConfiguration() == other.hasReshardingConfiguration() && Objects.equals(this.reshardingConfiguration(), other.reshardingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"RegionalConfiguration").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("ReplicationGroupRegion", (Object)this.replicationGroupRegion()).add("ReshardingConfiguration", this.hasReshardingConfiguration() ? this.reshardingConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "ReplicationGroupRegion": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupRegion()));
            }
            case "ReshardingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.reshardingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegionalConfiguration, T> g) {
        return obj -> g.apply((RegionalConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String replicationGroupRegion;
        private List<ReshardingConfiguration> reshardingConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegionalConfiguration model) {
            this.replicationGroupId(model.replicationGroupId);
            this.replicationGroupRegion(model.replicationGroupRegion);
            this.reshardingConfiguration(model.reshardingConfiguration);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        @Transient
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final String getReplicationGroupRegion() {
            return this.replicationGroupRegion;
        }

        public final void setReplicationGroupRegion(String replicationGroupRegion) {
            this.replicationGroupRegion = replicationGroupRegion;
        }

        @Override
        @Transient
        public final Builder replicationGroupRegion(String replicationGroupRegion) {
            this.replicationGroupRegion = replicationGroupRegion;
            return this;
        }

        public final List<ReshardingConfiguration.Builder> getReshardingConfiguration() {
            List<ReshardingConfiguration.Builder> result = ReshardingConfigurationListCopier.copyToBuilder(this.reshardingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReshardingConfiguration(Collection<ReshardingConfiguration.BuilderImpl> reshardingConfiguration) {
            this.reshardingConfiguration = ReshardingConfigurationListCopier.copyFromBuilder(reshardingConfiguration);
        }

        @Override
        @Transient
        public final Builder reshardingConfiguration(Collection<ReshardingConfiguration> reshardingConfiguration) {
            this.reshardingConfiguration = ReshardingConfigurationListCopier.copy(reshardingConfiguration);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reshardingConfiguration(ReshardingConfiguration ... reshardingConfiguration) {
            this.reshardingConfiguration(Arrays.asList(reshardingConfiguration));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reshardingConfiguration(Consumer<ReshardingConfiguration.Builder> ... reshardingConfiguration) {
            this.reshardingConfiguration(Stream.of(reshardingConfiguration).map(c -> (ReshardingConfiguration)((ReshardingConfiguration.Builder)ReshardingConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RegionalConfiguration build() {
            return new RegionalConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegionalConfiguration> {
        public Builder replicationGroupId(String var1);

        public Builder replicationGroupRegion(String var1);

        public Builder reshardingConfiguration(Collection<ReshardingConfiguration> var1);

        public Builder reshardingConfiguration(ReshardingConfiguration ... var1);

        public Builder reshardingConfiguration(Consumer<ReshardingConfiguration.Builder> ... var1);
    }
}

