/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOffering;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOfferingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedCacheNodesOfferingsResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeReservedCacheNodesOfferingsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeReservedCacheNodesOfferingsResponse.getter(DescribeReservedCacheNodesOfferingsResponse::marker)).setter(DescribeReservedCacheNodesOfferingsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ReservedCacheNodesOffering>> RESERVED_CACHE_NODES_OFFERINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedCacheNodesOfferings").getter(DescribeReservedCacheNodesOfferingsResponse.getter(DescribeReservedCacheNodesOfferingsResponse::reservedCacheNodesOfferings)).setter(DescribeReservedCacheNodesOfferingsResponse.setter(Builder::reservedCacheNodesOfferings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCacheNodesOfferings").build(), ListTrait.builder().memberLocationName("ReservedCacheNodesOffering").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedCacheNodesOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCacheNodesOffering").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, RESERVED_CACHE_NODES_OFFERINGS_FIELD));
    private final String marker;
    private final List<ReservedCacheNodesOffering> reservedCacheNodesOfferings;

    private DescribeReservedCacheNodesOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedCacheNodesOfferings = builder.reservedCacheNodesOfferings;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasReservedCacheNodesOfferings() {
        return this.reservedCacheNodesOfferings != null && !(this.reservedCacheNodesOfferings instanceof SdkAutoConstructList);
    }

    public final List<ReservedCacheNodesOffering> reservedCacheNodesOfferings() {
        return this.reservedCacheNodesOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedCacheNodesOfferings() ? this.reservedCacheNodesOfferings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedCacheNodesOfferingsResponse)) {
            return false;
        }
        DescribeReservedCacheNodesOfferingsResponse other = (DescribeReservedCacheNodesOfferingsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasReservedCacheNodesOfferings() == other.hasReservedCacheNodesOfferings() && Objects.equals(this.reservedCacheNodesOfferings(), other.reservedCacheNodesOfferings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReservedCacheNodesOfferingsResponse").add("Marker", (Object)this.marker()).add("ReservedCacheNodesOfferings", this.hasReservedCacheNodesOfferings() ? this.reservedCacheNodesOfferings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReservedCacheNodesOfferings": {
                return Optional.ofNullable(clazz.cast(this.reservedCacheNodesOfferings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedCacheNodesOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeReservedCacheNodesOfferingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedCacheNodesOffering> reservedCacheNodesOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedCacheNodesOfferingsResponse model) {
            super(model);
            this.marker(model.marker);
            this.reservedCacheNodesOfferings(model.reservedCacheNodesOfferings);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ReservedCacheNodesOffering.Builder> getReservedCacheNodesOfferings() {
            List<ReservedCacheNodesOffering.Builder> result = ReservedCacheNodesOfferingListCopier.copyToBuilder(this.reservedCacheNodesOfferings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedCacheNodesOfferings(Collection<ReservedCacheNodesOffering.BuilderImpl> reservedCacheNodesOfferings) {
            this.reservedCacheNodesOfferings = ReservedCacheNodesOfferingListCopier.copyFromBuilder(reservedCacheNodesOfferings);
        }

        @Override
        @Transient
        public final Builder reservedCacheNodesOfferings(Collection<ReservedCacheNodesOffering> reservedCacheNodesOfferings) {
            this.reservedCacheNodesOfferings = ReservedCacheNodesOfferingListCopier.copy(reservedCacheNodesOfferings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reservedCacheNodesOfferings(ReservedCacheNodesOffering ... reservedCacheNodesOfferings) {
            this.reservedCacheNodesOfferings(Arrays.asList(reservedCacheNodesOfferings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reservedCacheNodesOfferings(Consumer<ReservedCacheNodesOffering.Builder> ... reservedCacheNodesOfferings) {
            this.reservedCacheNodesOfferings(Stream.of(reservedCacheNodesOfferings).map(c -> (ReservedCacheNodesOffering)((ReservedCacheNodesOffering.Builder)ReservedCacheNodesOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedCacheNodesOfferingsResponse build() {
            return new DescribeReservedCacheNodesOfferingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedCacheNodesOfferingsResponse> {
        public Builder marker(String var1);

        public Builder reservedCacheNodesOfferings(Collection<ReservedCacheNodesOffering> var1);

        public Builder reservedCacheNodesOfferings(ReservedCacheNodesOffering ... var1);

        public Builder reservedCacheNodesOfferings(Consumer<ReservedCacheNodesOffering.Builder> ... var1);
    }
}

