/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdateSeverity;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceUpdate> {
    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUpdateName").getter(ServiceUpdate.getter(ServiceUpdate::serviceUpdateName)).setter(ServiceUpdate.setter(Builder::serviceUpdateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()}).build();
    private static final SdkField<Instant> SERVICE_UPDATE_RELEASE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ServiceUpdateReleaseDate").getter(ServiceUpdate.getter(ServiceUpdate::serviceUpdateReleaseDate)).setter(ServiceUpdate.setter(Builder::serviceUpdateReleaseDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateReleaseDate").build()}).build();
    private static final SdkField<Instant> SERVICE_UPDATE_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ServiceUpdateEndDate").getter(ServiceUpdate.getter(ServiceUpdate::serviceUpdateEndDate)).setter(ServiceUpdate.setter(Builder::serviceUpdateEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateEndDate").build()}).build();
    private static final SdkField<String> SERVICE_UPDATE_SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUpdateSeverity").getter(ServiceUpdate.getter(ServiceUpdate::serviceUpdateSeverityAsString)).setter(ServiceUpdate.setter(Builder::serviceUpdateSeverity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateSeverity").build()}).build();
    private static final SdkField<Instant> SERVICE_UPDATE_RECOMMENDED_APPLY_BY_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ServiceUpdateRecommendedApplyByDate").getter(ServiceUpdate.getter(ServiceUpdate::serviceUpdateRecommendedApplyByDate)).setter(ServiceUpdate.setter(Builder::serviceUpdateRecommendedApplyByDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateRecommendedApplyByDate").build()}).build();
    private static final SdkField<String> SERVICE_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUpdateStatus").getter(ServiceUpdate.getter(ServiceUpdate::serviceUpdateStatusAsString)).setter(ServiceUpdate.setter(Builder::serviceUpdateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateStatus").build()}).build();
    private static final SdkField<String> SERVICE_UPDATE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUpdateDescription").getter(ServiceUpdate.getter(ServiceUpdate::serviceUpdateDescription)).setter(ServiceUpdate.setter(Builder::serviceUpdateDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateDescription").build()}).build();
    private static final SdkField<String> SERVICE_UPDATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUpdateType").getter(ServiceUpdate.getter(ServiceUpdate::serviceUpdateTypeAsString)).setter(ServiceUpdate.setter(Builder::serviceUpdateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateType").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(ServiceUpdate.getter(ServiceUpdate::engine)).setter(ServiceUpdate.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(ServiceUpdate.getter(ServiceUpdate::engineVersion)).setter(ServiceUpdate.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Boolean> AUTO_UPDATE_AFTER_RECOMMENDED_APPLY_BY_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoUpdateAfterRecommendedApplyByDate").getter(ServiceUpdate.getter(ServiceUpdate::autoUpdateAfterRecommendedApplyByDate)).setter(ServiceUpdate.setter(Builder::autoUpdateAfterRecommendedApplyByDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpdateAfterRecommendedApplyByDate").build()}).build();
    private static final SdkField<String> ESTIMATED_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedUpdateTime").getter(ServiceUpdate.getter(ServiceUpdate::estimatedUpdateTime)).setter(ServiceUpdate.setter(Builder::estimatedUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_UPDATE_NAME_FIELD, SERVICE_UPDATE_RELEASE_DATE_FIELD, SERVICE_UPDATE_END_DATE_FIELD, SERVICE_UPDATE_SEVERITY_FIELD, SERVICE_UPDATE_RECOMMENDED_APPLY_BY_DATE_FIELD, SERVICE_UPDATE_STATUS_FIELD, SERVICE_UPDATE_DESCRIPTION_FIELD, SERVICE_UPDATE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, AUTO_UPDATE_AFTER_RECOMMENDED_APPLY_BY_DATE_FIELD, ESTIMATED_UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceUpdateName;
    private final Instant serviceUpdateReleaseDate;
    private final Instant serviceUpdateEndDate;
    private final String serviceUpdateSeverity;
    private final Instant serviceUpdateRecommendedApplyByDate;
    private final String serviceUpdateStatus;
    private final String serviceUpdateDescription;
    private final String serviceUpdateType;
    private final String engine;
    private final String engineVersion;
    private final Boolean autoUpdateAfterRecommendedApplyByDate;
    private final String estimatedUpdateTime;

    private ServiceUpdate(BuilderImpl builder) {
        this.serviceUpdateName = builder.serviceUpdateName;
        this.serviceUpdateReleaseDate = builder.serviceUpdateReleaseDate;
        this.serviceUpdateEndDate = builder.serviceUpdateEndDate;
        this.serviceUpdateSeverity = builder.serviceUpdateSeverity;
        this.serviceUpdateRecommendedApplyByDate = builder.serviceUpdateRecommendedApplyByDate;
        this.serviceUpdateStatus = builder.serviceUpdateStatus;
        this.serviceUpdateDescription = builder.serviceUpdateDescription;
        this.serviceUpdateType = builder.serviceUpdateType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.autoUpdateAfterRecommendedApplyByDate = builder.autoUpdateAfterRecommendedApplyByDate;
        this.estimatedUpdateTime = builder.estimatedUpdateTime;
    }

    public final String serviceUpdateName() {
        return this.serviceUpdateName;
    }

    public final Instant serviceUpdateReleaseDate() {
        return this.serviceUpdateReleaseDate;
    }

    public final Instant serviceUpdateEndDate() {
        return this.serviceUpdateEndDate;
    }

    public final ServiceUpdateSeverity serviceUpdateSeverity() {
        return ServiceUpdateSeverity.fromValue(this.serviceUpdateSeverity);
    }

    public final String serviceUpdateSeverityAsString() {
        return this.serviceUpdateSeverity;
    }

    public final Instant serviceUpdateRecommendedApplyByDate() {
        return this.serviceUpdateRecommendedApplyByDate;
    }

    public final ServiceUpdateStatus serviceUpdateStatus() {
        return ServiceUpdateStatus.fromValue(this.serviceUpdateStatus);
    }

    public final String serviceUpdateStatusAsString() {
        return this.serviceUpdateStatus;
    }

    public final String serviceUpdateDescription() {
        return this.serviceUpdateDescription;
    }

    public final ServiceUpdateType serviceUpdateType() {
        return ServiceUpdateType.fromValue(this.serviceUpdateType);
    }

    public final String serviceUpdateTypeAsString() {
        return this.serviceUpdateType;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Boolean autoUpdateAfterRecommendedApplyByDate() {
        return this.autoUpdateAfterRecommendedApplyByDate;
    }

    public final String estimatedUpdateTime() {
        return this.estimatedUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateReleaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateSeverityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateRecommendedApplyByDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpdateAfterRecommendedApplyByDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedUpdateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceUpdate)) {
            return false;
        }
        ServiceUpdate other = (ServiceUpdate)obj;
        return Objects.equals(this.serviceUpdateName(), other.serviceUpdateName()) && Objects.equals(this.serviceUpdateReleaseDate(), other.serviceUpdateReleaseDate()) && Objects.equals(this.serviceUpdateEndDate(), other.serviceUpdateEndDate()) && Objects.equals(this.serviceUpdateSeverityAsString(), other.serviceUpdateSeverityAsString()) && Objects.equals(this.serviceUpdateRecommendedApplyByDate(), other.serviceUpdateRecommendedApplyByDate()) && Objects.equals(this.serviceUpdateStatusAsString(), other.serviceUpdateStatusAsString()) && Objects.equals(this.serviceUpdateDescription(), other.serviceUpdateDescription()) && Objects.equals(this.serviceUpdateTypeAsString(), other.serviceUpdateTypeAsString()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.autoUpdateAfterRecommendedApplyByDate(), other.autoUpdateAfterRecommendedApplyByDate()) && Objects.equals(this.estimatedUpdateTime(), other.estimatedUpdateTime());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceUpdate").add("ServiceUpdateName", (Object)this.serviceUpdateName()).add("ServiceUpdateReleaseDate", (Object)this.serviceUpdateReleaseDate()).add("ServiceUpdateEndDate", (Object)this.serviceUpdateEndDate()).add("ServiceUpdateSeverity", (Object)this.serviceUpdateSeverityAsString()).add("ServiceUpdateRecommendedApplyByDate", (Object)this.serviceUpdateRecommendedApplyByDate()).add("ServiceUpdateStatus", (Object)this.serviceUpdateStatusAsString()).add("ServiceUpdateDescription", (Object)this.serviceUpdateDescription()).add("ServiceUpdateType", (Object)this.serviceUpdateTypeAsString()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("AutoUpdateAfterRecommendedApplyByDate", (Object)this.autoUpdateAfterRecommendedApplyByDate()).add("EstimatedUpdateTime", (Object)this.estimatedUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceUpdateName": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateName()));
            }
            case "ServiceUpdateReleaseDate": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateReleaseDate()));
            }
            case "ServiceUpdateEndDate": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateEndDate()));
            }
            case "ServiceUpdateSeverity": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateSeverityAsString()));
            }
            case "ServiceUpdateRecommendedApplyByDate": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateRecommendedApplyByDate()));
            }
            case "ServiceUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateStatusAsString()));
            }
            case "ServiceUpdateDescription": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateDescription()));
            }
            case "ServiceUpdateType": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateTypeAsString()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "AutoUpdateAfterRecommendedApplyByDate": {
                return Optional.ofNullable(clazz.cast(this.autoUpdateAfterRecommendedApplyByDate()));
            }
            case "EstimatedUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.estimatedUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceUpdate, T> g) {
        return obj -> g.apply((ServiceUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceUpdateName;
        private Instant serviceUpdateReleaseDate;
        private Instant serviceUpdateEndDate;
        private String serviceUpdateSeverity;
        private Instant serviceUpdateRecommendedApplyByDate;
        private String serviceUpdateStatus;
        private String serviceUpdateDescription;
        private String serviceUpdateType;
        private String engine;
        private String engineVersion;
        private Boolean autoUpdateAfterRecommendedApplyByDate;
        private String estimatedUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceUpdate model) {
            this.serviceUpdateName(model.serviceUpdateName);
            this.serviceUpdateReleaseDate(model.serviceUpdateReleaseDate);
            this.serviceUpdateEndDate(model.serviceUpdateEndDate);
            this.serviceUpdateSeverity(model.serviceUpdateSeverity);
            this.serviceUpdateRecommendedApplyByDate(model.serviceUpdateRecommendedApplyByDate);
            this.serviceUpdateStatus(model.serviceUpdateStatus);
            this.serviceUpdateDescription(model.serviceUpdateDescription);
            this.serviceUpdateType(model.serviceUpdateType);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.autoUpdateAfterRecommendedApplyByDate(model.autoUpdateAfterRecommendedApplyByDate);
            this.estimatedUpdateTime(model.estimatedUpdateTime);
        }

        public final String getServiceUpdateName() {
            return this.serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        public final Instant getServiceUpdateReleaseDate() {
            return this.serviceUpdateReleaseDate;
        }

        @Override
        public final Builder serviceUpdateReleaseDate(Instant serviceUpdateReleaseDate) {
            this.serviceUpdateReleaseDate = serviceUpdateReleaseDate;
            return this;
        }

        public final void setServiceUpdateReleaseDate(Instant serviceUpdateReleaseDate) {
            this.serviceUpdateReleaseDate = serviceUpdateReleaseDate;
        }

        public final Instant getServiceUpdateEndDate() {
            return this.serviceUpdateEndDate;
        }

        @Override
        public final Builder serviceUpdateEndDate(Instant serviceUpdateEndDate) {
            this.serviceUpdateEndDate = serviceUpdateEndDate;
            return this;
        }

        public final void setServiceUpdateEndDate(Instant serviceUpdateEndDate) {
            this.serviceUpdateEndDate = serviceUpdateEndDate;
        }

        public final String getServiceUpdateSeverity() {
            return this.serviceUpdateSeverity;
        }

        @Override
        public final Builder serviceUpdateSeverity(String serviceUpdateSeverity) {
            this.serviceUpdateSeverity = serviceUpdateSeverity;
            return this;
        }

        @Override
        public final Builder serviceUpdateSeverity(ServiceUpdateSeverity serviceUpdateSeverity) {
            this.serviceUpdateSeverity(serviceUpdateSeverity == null ? null : serviceUpdateSeverity.toString());
            return this;
        }

        public final void setServiceUpdateSeverity(String serviceUpdateSeverity) {
            this.serviceUpdateSeverity = serviceUpdateSeverity;
        }

        public final Instant getServiceUpdateRecommendedApplyByDate() {
            return this.serviceUpdateRecommendedApplyByDate;
        }

        @Override
        public final Builder serviceUpdateRecommendedApplyByDate(Instant serviceUpdateRecommendedApplyByDate) {
            this.serviceUpdateRecommendedApplyByDate = serviceUpdateRecommendedApplyByDate;
            return this;
        }

        public final void setServiceUpdateRecommendedApplyByDate(Instant serviceUpdateRecommendedApplyByDate) {
            this.serviceUpdateRecommendedApplyByDate = serviceUpdateRecommendedApplyByDate;
        }

        public final String getServiceUpdateStatus() {
            return this.serviceUpdateStatus;
        }

        @Override
        public final Builder serviceUpdateStatus(String serviceUpdateStatus) {
            this.serviceUpdateStatus = serviceUpdateStatus;
            return this;
        }

        @Override
        public final Builder serviceUpdateStatus(ServiceUpdateStatus serviceUpdateStatus) {
            this.serviceUpdateStatus(serviceUpdateStatus == null ? null : serviceUpdateStatus.toString());
            return this;
        }

        public final void setServiceUpdateStatus(String serviceUpdateStatus) {
            this.serviceUpdateStatus = serviceUpdateStatus;
        }

        public final String getServiceUpdateDescription() {
            return this.serviceUpdateDescription;
        }

        @Override
        public final Builder serviceUpdateDescription(String serviceUpdateDescription) {
            this.serviceUpdateDescription = serviceUpdateDescription;
            return this;
        }

        public final void setServiceUpdateDescription(String serviceUpdateDescription) {
            this.serviceUpdateDescription = serviceUpdateDescription;
        }

        public final String getServiceUpdateType() {
            return this.serviceUpdateType;
        }

        @Override
        public final Builder serviceUpdateType(String serviceUpdateType) {
            this.serviceUpdateType = serviceUpdateType;
            return this;
        }

        @Override
        public final Builder serviceUpdateType(ServiceUpdateType serviceUpdateType) {
            this.serviceUpdateType(serviceUpdateType == null ? null : serviceUpdateType.toString());
            return this;
        }

        public final void setServiceUpdateType(String serviceUpdateType) {
            this.serviceUpdateType = serviceUpdateType;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAutoUpdateAfterRecommendedApplyByDate() {
            return this.autoUpdateAfterRecommendedApplyByDate;
        }

        @Override
        public final Builder autoUpdateAfterRecommendedApplyByDate(Boolean autoUpdateAfterRecommendedApplyByDate) {
            this.autoUpdateAfterRecommendedApplyByDate = autoUpdateAfterRecommendedApplyByDate;
            return this;
        }

        public final void setAutoUpdateAfterRecommendedApplyByDate(Boolean autoUpdateAfterRecommendedApplyByDate) {
            this.autoUpdateAfterRecommendedApplyByDate = autoUpdateAfterRecommendedApplyByDate;
        }

        public final String getEstimatedUpdateTime() {
            return this.estimatedUpdateTime;
        }

        @Override
        public final Builder estimatedUpdateTime(String estimatedUpdateTime) {
            this.estimatedUpdateTime = estimatedUpdateTime;
            return this;
        }

        public final void setEstimatedUpdateTime(String estimatedUpdateTime) {
            this.estimatedUpdateTime = estimatedUpdateTime;
        }

        public ServiceUpdate build() {
            return new ServiceUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceUpdate> {
        public Builder serviceUpdateName(String var1);

        public Builder serviceUpdateReleaseDate(Instant var1);

        public Builder serviceUpdateEndDate(Instant var1);

        public Builder serviceUpdateSeverity(String var1);

        public Builder serviceUpdateSeverity(ServiceUpdateSeverity var1);

        public Builder serviceUpdateRecommendedApplyByDate(Instant var1);

        public Builder serviceUpdateStatus(String var1);

        public Builder serviceUpdateStatus(ServiceUpdateStatus var1);

        public Builder serviceUpdateDescription(String var1);

        public Builder serviceUpdateType(String var1);

        public Builder serviceUpdateType(ServiceUpdateType var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder autoUpdateAfterRecommendedApplyByDate(Boolean var1);

        public Builder estimatedUpdateTime(String var1);
    }
}

