/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.UGReplicationGroupIdListCopier;
import software.amazon.awssdk.services.elasticache.model.UserGroupPendingChanges;
import software.amazon.awssdk.services.elasticache.model.UserIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteUserGroupResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DeleteUserGroupResponse> {
    private static final SdkField<String> USER_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserGroupId").getter(DeleteUserGroupResponse.getter(DeleteUserGroupResponse::userGroupId)).setter(DeleteUserGroupResponse.setter(Builder::userGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DeleteUserGroupResponse.getter(DeleteUserGroupResponse::status)).setter(DeleteUserGroupResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(DeleteUserGroupResponse.getter(DeleteUserGroupResponse::engine)).setter(DeleteUserGroupResponse.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserIds").getter(DeleteUserGroupResponse.getter(DeleteUserGroupResponse::userIds)).setter(DeleteUserGroupResponse.setter(Builder::userIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<UserGroupPendingChanges> PENDING_CHANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PendingChanges").getter(DeleteUserGroupResponse.getter(DeleteUserGroupResponse::pendingChanges)).setter(DeleteUserGroupResponse.setter(Builder::pendingChanges)).constructor(UserGroupPendingChanges::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingChanges").build()}).build();
    private static final SdkField<List<String>> REPLICATION_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationGroups").getter(DeleteUserGroupResponse.getter(DeleteUserGroupResponse::replicationGroups)).setter(DeleteUserGroupResponse.setter(Builder::replicationGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(DeleteUserGroupResponse.getter(DeleteUserGroupResponse::arn)).setter(DeleteUserGroupResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_GROUP_ID_FIELD, STATUS_FIELD, ENGINE_FIELD, USER_IDS_FIELD, PENDING_CHANGES_FIELD, REPLICATION_GROUPS_FIELD, ARN_FIELD));
    private final String userGroupId;
    private final String status;
    private final String engine;
    private final List<String> userIds;
    private final UserGroupPendingChanges pendingChanges;
    private final List<String> replicationGroups;
    private final String arn;

    private DeleteUserGroupResponse(BuilderImpl builder) {
        super(builder);
        this.userGroupId = builder.userGroupId;
        this.status = builder.status;
        this.engine = builder.engine;
        this.userIds = builder.userIds;
        this.pendingChanges = builder.pendingChanges;
        this.replicationGroups = builder.replicationGroups;
        this.arn = builder.arn;
    }

    public final String userGroupId() {
        return this.userGroupId;
    }

    public final String status() {
        return this.status;
    }

    public final String engine() {
        return this.engine;
    }

    public final boolean hasUserIds() {
        return this.userIds != null && !(this.userIds instanceof SdkAutoConstructList);
    }

    public final List<String> userIds() {
        return this.userIds;
    }

    public final UserGroupPendingChanges pendingChanges() {
        return this.pendingChanges;
    }

    public final boolean hasReplicationGroups() {
        return this.replicationGroups != null && !(this.replicationGroups instanceof SdkAutoConstructList);
    }

    public final List<String> replicationGroups() {
        return this.replicationGroups;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIds() ? this.userIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingChanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationGroups() ? this.replicationGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteUserGroupResponse)) {
            return false;
        }
        DeleteUserGroupResponse other = (DeleteUserGroupResponse)((Object)obj);
        return Objects.equals(this.userGroupId(), other.userGroupId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.engine(), other.engine()) && this.hasUserIds() == other.hasUserIds() && Objects.equals(this.userIds(), other.userIds()) && Objects.equals(this.pendingChanges(), other.pendingChanges()) && this.hasReplicationGroups() == other.hasReplicationGroups() && Objects.equals(this.replicationGroups(), other.replicationGroups()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteUserGroupResponse").add("UserGroupId", (Object)this.userGroupId()).add("Status", (Object)this.status()).add("Engine", (Object)this.engine()).add("UserIds", this.hasUserIds() ? this.userIds() : null).add("PendingChanges", (Object)this.pendingChanges()).add("ReplicationGroups", this.hasReplicationGroups() ? this.replicationGroups() : null).add("ARN", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserGroupId": {
                return Optional.ofNullable(clazz.cast(this.userGroupId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "UserIds": {
                return Optional.ofNullable(clazz.cast(this.userIds()));
            }
            case "PendingChanges": {
                return Optional.ofNullable(clazz.cast(this.pendingChanges()));
            }
            case "ReplicationGroups": {
                return Optional.ofNullable(clazz.cast(this.replicationGroups()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteUserGroupResponse, T> g) {
        return obj -> g.apply((DeleteUserGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String userGroupId;
        private String status;
        private String engine;
        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();
        private UserGroupPendingChanges pendingChanges;
        private List<String> replicationGroups = DefaultSdkAutoConstructList.getInstance();
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteUserGroupResponse model) {
            super(model);
            this.userGroupId(model.userGroupId);
            this.status(model.status);
            this.engine(model.engine);
            this.userIds(model.userIds);
            this.pendingChanges(model.pendingChanges);
            this.replicationGroups(model.replicationGroups);
            this.arn(model.arn);
        }

        public final String getUserGroupId() {
            return this.userGroupId;
        }

        public final void setUserGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
        }

        @Override
        @Transient
        public final Builder userGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        @Transient
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final Collection<String> getUserIds() {
            if (this.userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userIds;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdListCopier.copy(userIds);
        }

        @Override
        @Transient
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdListCopier.copy(userIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userIds(String ... userIds) {
            this.userIds(Arrays.asList(userIds));
            return this;
        }

        public final UserGroupPendingChanges.Builder getPendingChanges() {
            return this.pendingChanges != null ? this.pendingChanges.toBuilder() : null;
        }

        public final void setPendingChanges(UserGroupPendingChanges.BuilderImpl pendingChanges) {
            this.pendingChanges = pendingChanges != null ? pendingChanges.build() : null;
        }

        @Override
        @Transient
        public final Builder pendingChanges(UserGroupPendingChanges pendingChanges) {
            this.pendingChanges = pendingChanges;
            return this;
        }

        public final Collection<String> getReplicationGroups() {
            if (this.replicationGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationGroups;
        }

        public final void setReplicationGroups(Collection<String> replicationGroups) {
            this.replicationGroups = UGReplicationGroupIdListCopier.copy(replicationGroups);
        }

        @Override
        @Transient
        public final Builder replicationGroups(Collection<String> replicationGroups) {
            this.replicationGroups = UGReplicationGroupIdListCopier.copy(replicationGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicationGroups(String ... replicationGroups) {
            this.replicationGroups(Arrays.asList(replicationGroups));
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public DeleteUserGroupResponse build() {
            return new DeleteUserGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteUserGroupResponse> {
        public Builder userGroupId(String var1);

        public Builder status(String var1);

        public Builder engine(String var1);

        public Builder userIds(Collection<String> var1);

        public Builder userIds(String ... var1);

        public Builder pendingChanges(UserGroupPendingChanges var1);

        default public Builder pendingChanges(Consumer<UserGroupPendingChanges.Builder> pendingChanges) {
            return this.pendingChanges((UserGroupPendingChanges)((UserGroupPendingChanges.Builder)UserGroupPendingChanges.builder().applyMutation(pendingChanges)).build());
        }

        public Builder replicationGroups(Collection<String> var1);

        public Builder replicationGroups(String ... var1);

        public Builder arn(String var1);
    }
}

