/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CacheClusterIdListCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupIdListCopier;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatusListCopier;
import software.amazon.awssdk.services.elasticache.model.TimeRangeFilter;
import software.amazon.awssdk.services.elasticache.model.UpdateActionStatus;
import software.amazon.awssdk.services.elasticache.model.UpdateActionStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUpdateActionsRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, DescribeUpdateActionsRequest> {
    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUpdateName").getter(DescribeUpdateActionsRequest.getter(DescribeUpdateActionsRequest::serviceUpdateName)).setter(DescribeUpdateActionsRequest.setter(Builder::serviceUpdateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()}).build();
    private static final SdkField<List<String>> REPLICATION_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationGroupIds").getter(DescribeUpdateActionsRequest.getter(DescribeUpdateActionsRequest::replicationGroupIds)).setter(DescribeUpdateActionsRequest.setter(Builder::replicationGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CACHE_CLUSTER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheClusterIds").getter(DescribeUpdateActionsRequest.getter(DescribeUpdateActionsRequest::cacheClusterIds)).setter(DescribeUpdateActionsRequest.setter(Builder::cacheClusterIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(DescribeUpdateActionsRequest.getter(DescribeUpdateActionsRequest::engine)).setter(DescribeUpdateActionsRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<List<String>> SERVICE_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceUpdateStatus").getter(DescribeUpdateActionsRequest.getter(DescribeUpdateActionsRequest::serviceUpdateStatusAsStrings)).setter(DescribeUpdateActionsRequest.setter(Builder::serviceUpdateStatusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TimeRangeFilter> SERVICE_UPDATE_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceUpdateTimeRange").getter(DescribeUpdateActionsRequest.getter(DescribeUpdateActionsRequest::serviceUpdateTimeRange)).setter(DescribeUpdateActionsRequest.setter(Builder::serviceUpdateTimeRange)).constructor(TimeRangeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateTimeRange").build()}).build();
    private static final SdkField<List<String>> UPDATE_ACTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UpdateActionStatus").getter(DescribeUpdateActionsRequest.getter(DescribeUpdateActionsRequest::updateActionStatusAsStrings)).setter(DescribeUpdateActionsRequest.setter(Builder::updateActionStatusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateActionStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SHOW_NODE_LEVEL_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ShowNodeLevelUpdateStatus").getter(DescribeUpdateActionsRequest.getter(DescribeUpdateActionsRequest::showNodeLevelUpdateStatus)).setter(DescribeUpdateActionsRequest.setter(Builder::showNodeLevelUpdateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowNodeLevelUpdateStatus").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeUpdateActionsRequest.getter(DescribeUpdateActionsRequest::maxRecords)).setter(DescribeUpdateActionsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeUpdateActionsRequest.getter(DescribeUpdateActionsRequest::marker)).setter(DescribeUpdateActionsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_UPDATE_NAME_FIELD, REPLICATION_GROUP_IDS_FIELD, CACHE_CLUSTER_IDS_FIELD, ENGINE_FIELD, SERVICE_UPDATE_STATUS_FIELD, SERVICE_UPDATE_TIME_RANGE_FIELD, UPDATE_ACTION_STATUS_FIELD, SHOW_NODE_LEVEL_UPDATE_STATUS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));
    private final String serviceUpdateName;
    private final List<String> replicationGroupIds;
    private final List<String> cacheClusterIds;
    private final String engine;
    private final List<String> serviceUpdateStatus;
    private final TimeRangeFilter serviceUpdateTimeRange;
    private final List<String> updateActionStatus;
    private final Boolean showNodeLevelUpdateStatus;
    private final Integer maxRecords;
    private final String marker;

    private DescribeUpdateActionsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceUpdateName = builder.serviceUpdateName;
        this.replicationGroupIds = builder.replicationGroupIds;
        this.cacheClusterIds = builder.cacheClusterIds;
        this.engine = builder.engine;
        this.serviceUpdateStatus = builder.serviceUpdateStatus;
        this.serviceUpdateTimeRange = builder.serviceUpdateTimeRange;
        this.updateActionStatus = builder.updateActionStatus;
        this.showNodeLevelUpdateStatus = builder.showNodeLevelUpdateStatus;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public final String serviceUpdateName() {
        return this.serviceUpdateName;
    }

    public final boolean hasReplicationGroupIds() {
        return this.replicationGroupIds != null && !(this.replicationGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> replicationGroupIds() {
        return this.replicationGroupIds;
    }

    public final boolean hasCacheClusterIds() {
        return this.cacheClusterIds != null && !(this.cacheClusterIds instanceof SdkAutoConstructList);
    }

    public final List<String> cacheClusterIds() {
        return this.cacheClusterIds;
    }

    public final String engine() {
        return this.engine;
    }

    public final List<ServiceUpdateStatus> serviceUpdateStatus() {
        return ServiceUpdateStatusListCopier.copyStringToEnum(this.serviceUpdateStatus);
    }

    public final boolean hasServiceUpdateStatus() {
        return this.serviceUpdateStatus != null && !(this.serviceUpdateStatus instanceof SdkAutoConstructList);
    }

    public final List<String> serviceUpdateStatusAsStrings() {
        return this.serviceUpdateStatus;
    }

    public final TimeRangeFilter serviceUpdateTimeRange() {
        return this.serviceUpdateTimeRange;
    }

    public final List<UpdateActionStatus> updateActionStatus() {
        return UpdateActionStatusListCopier.copyStringToEnum(this.updateActionStatus);
    }

    public final boolean hasUpdateActionStatus() {
        return this.updateActionStatus != null && !(this.updateActionStatus instanceof SdkAutoConstructList);
    }

    public final List<String> updateActionStatusAsStrings() {
        return this.updateActionStatus;
    }

    public final Boolean showNodeLevelUpdateStatus() {
        return this.showNodeLevelUpdateStatus;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    public final String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationGroupIds() ? this.replicationGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheClusterIds() ? this.cacheClusterIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceUpdateStatus() ? this.serviceUpdateStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdateActionStatus() ? this.updateActionStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.showNodeLevelUpdateStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUpdateActionsRequest)) {
            return false;
        }
        DescribeUpdateActionsRequest other = (DescribeUpdateActionsRequest)((Object)obj);
        return Objects.equals(this.serviceUpdateName(), other.serviceUpdateName()) && this.hasReplicationGroupIds() == other.hasReplicationGroupIds() && Objects.equals(this.replicationGroupIds(), other.replicationGroupIds()) && this.hasCacheClusterIds() == other.hasCacheClusterIds() && Objects.equals(this.cacheClusterIds(), other.cacheClusterIds()) && Objects.equals(this.engine(), other.engine()) && this.hasServiceUpdateStatus() == other.hasServiceUpdateStatus() && Objects.equals(this.serviceUpdateStatusAsStrings(), other.serviceUpdateStatusAsStrings()) && Objects.equals(this.serviceUpdateTimeRange(), other.serviceUpdateTimeRange()) && this.hasUpdateActionStatus() == other.hasUpdateActionStatus() && Objects.equals(this.updateActionStatusAsStrings(), other.updateActionStatusAsStrings()) && Objects.equals(this.showNodeLevelUpdateStatus(), other.showNodeLevelUpdateStatus()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeUpdateActionsRequest").add("ServiceUpdateName", (Object)this.serviceUpdateName()).add("ReplicationGroupIds", this.hasReplicationGroupIds() ? this.replicationGroupIds() : null).add("CacheClusterIds", this.hasCacheClusterIds() ? this.cacheClusterIds() : null).add("Engine", (Object)this.engine()).add("ServiceUpdateStatus", this.hasServiceUpdateStatus() ? this.serviceUpdateStatusAsStrings() : null).add("ServiceUpdateTimeRange", (Object)this.serviceUpdateTimeRange()).add("UpdateActionStatus", this.hasUpdateActionStatus() ? this.updateActionStatusAsStrings() : null).add("ShowNodeLevelUpdateStatus", (Object)this.showNodeLevelUpdateStatus()).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceUpdateName": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateName()));
            }
            case "ReplicationGroupIds": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupIds()));
            }
            case "CacheClusterIds": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterIds()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "ServiceUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateStatusAsStrings()));
            }
            case "ServiceUpdateTimeRange": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateTimeRange()));
            }
            case "UpdateActionStatus": {
                return Optional.ofNullable(clazz.cast(this.updateActionStatusAsStrings()));
            }
            case "ShowNodeLevelUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.showNodeLevelUpdateStatus()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUpdateActionsRequest, T> g) {
        return obj -> g.apply((DescribeUpdateActionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String serviceUpdateName;
        private List<String> replicationGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> cacheClusterIds = DefaultSdkAutoConstructList.getInstance();
        private String engine;
        private List<String> serviceUpdateStatus = DefaultSdkAutoConstructList.getInstance();
        private TimeRangeFilter serviceUpdateTimeRange;
        private List<String> updateActionStatus = DefaultSdkAutoConstructList.getInstance();
        private Boolean showNodeLevelUpdateStatus;
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUpdateActionsRequest model) {
            super(model);
            this.serviceUpdateName(model.serviceUpdateName);
            this.replicationGroupIds(model.replicationGroupIds);
            this.cacheClusterIds(model.cacheClusterIds);
            this.engine(model.engine);
            this.serviceUpdateStatusWithStrings(model.serviceUpdateStatus);
            this.serviceUpdateTimeRange(model.serviceUpdateTimeRange);
            this.updateActionStatusWithStrings(model.updateActionStatus);
            this.showNodeLevelUpdateStatus(model.showNodeLevelUpdateStatus);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
        }

        public final String getServiceUpdateName() {
            return this.serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        public final Collection<String> getReplicationGroupIds() {
            if (this.replicationGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationGroupIds;
        }

        @Override
        public final Builder replicationGroupIds(Collection<String> replicationGroupIds) {
            this.replicationGroupIds = ReplicationGroupIdListCopier.copy(replicationGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroupIds(String ... replicationGroupIds) {
            this.replicationGroupIds(Arrays.asList(replicationGroupIds));
            return this;
        }

        public final void setReplicationGroupIds(Collection<String> replicationGroupIds) {
            this.replicationGroupIds = ReplicationGroupIdListCopier.copy(replicationGroupIds);
        }

        public final Collection<String> getCacheClusterIds() {
            if (this.cacheClusterIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cacheClusterIds;
        }

        @Override
        public final Builder cacheClusterIds(Collection<String> cacheClusterIds) {
            this.cacheClusterIds = CacheClusterIdListCopier.copy(cacheClusterIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheClusterIds(String ... cacheClusterIds) {
            this.cacheClusterIds(Arrays.asList(cacheClusterIds));
            return this;
        }

        public final void setCacheClusterIds(Collection<String> cacheClusterIds) {
            this.cacheClusterIds = CacheClusterIdListCopier.copy(cacheClusterIds);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final Collection<String> getServiceUpdateStatus() {
            if (this.serviceUpdateStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceUpdateStatus;
        }

        @Override
        public final Builder serviceUpdateStatusWithStrings(Collection<String> serviceUpdateStatus) {
            this.serviceUpdateStatus = ServiceUpdateStatusListCopier.copy(serviceUpdateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdateStatusWithStrings(String ... serviceUpdateStatus) {
            this.serviceUpdateStatusWithStrings(Arrays.asList(serviceUpdateStatus));
            return this;
        }

        @Override
        public final Builder serviceUpdateStatus(Collection<ServiceUpdateStatus> serviceUpdateStatus) {
            this.serviceUpdateStatus = ServiceUpdateStatusListCopier.copyEnumToString(serviceUpdateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdateStatus(ServiceUpdateStatus ... serviceUpdateStatus) {
            this.serviceUpdateStatus(Arrays.asList(serviceUpdateStatus));
            return this;
        }

        public final void setServiceUpdateStatus(Collection<String> serviceUpdateStatus) {
            this.serviceUpdateStatus = ServiceUpdateStatusListCopier.copy(serviceUpdateStatus);
        }

        public final TimeRangeFilter.Builder getServiceUpdateTimeRange() {
            return this.serviceUpdateTimeRange != null ? this.serviceUpdateTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder serviceUpdateTimeRange(TimeRangeFilter serviceUpdateTimeRange) {
            this.serviceUpdateTimeRange = serviceUpdateTimeRange;
            return this;
        }

        public final void setServiceUpdateTimeRange(TimeRangeFilter.BuilderImpl serviceUpdateTimeRange) {
            this.serviceUpdateTimeRange = serviceUpdateTimeRange != null ? serviceUpdateTimeRange.build() : null;
        }

        public final Collection<String> getUpdateActionStatus() {
            if (this.updateActionStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return this.updateActionStatus;
        }

        @Override
        public final Builder updateActionStatusWithStrings(Collection<String> updateActionStatus) {
            this.updateActionStatus = UpdateActionStatusListCopier.copy(updateActionStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateActionStatusWithStrings(String ... updateActionStatus) {
            this.updateActionStatusWithStrings(Arrays.asList(updateActionStatus));
            return this;
        }

        @Override
        public final Builder updateActionStatus(Collection<UpdateActionStatus> updateActionStatus) {
            this.updateActionStatus = UpdateActionStatusListCopier.copyEnumToString(updateActionStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateActionStatus(UpdateActionStatus ... updateActionStatus) {
            this.updateActionStatus(Arrays.asList(updateActionStatus));
            return this;
        }

        public final void setUpdateActionStatus(Collection<String> updateActionStatus) {
            this.updateActionStatus = UpdateActionStatusListCopier.copy(updateActionStatus);
        }

        public final Boolean getShowNodeLevelUpdateStatus() {
            return this.showNodeLevelUpdateStatus;
        }

        @Override
        public final Builder showNodeLevelUpdateStatus(Boolean showNodeLevelUpdateStatus) {
            this.showNodeLevelUpdateStatus = showNodeLevelUpdateStatus;
            return this;
        }

        public final void setShowNodeLevelUpdateStatus(Boolean showNodeLevelUpdateStatus) {
            this.showNodeLevelUpdateStatus = showNodeLevelUpdateStatus;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeUpdateActionsRequest build() {
            return new DescribeUpdateActionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUpdateActionsRequest> {
        public Builder serviceUpdateName(String var1);

        public Builder replicationGroupIds(Collection<String> var1);

        public Builder replicationGroupIds(String ... var1);

        public Builder cacheClusterIds(Collection<String> var1);

        public Builder cacheClusterIds(String ... var1);

        public Builder engine(String var1);

        public Builder serviceUpdateStatusWithStrings(Collection<String> var1);

        public Builder serviceUpdateStatusWithStrings(String ... var1);

        public Builder serviceUpdateStatus(Collection<ServiceUpdateStatus> var1);

        public Builder serviceUpdateStatus(ServiceUpdateStatus ... var1);

        public Builder serviceUpdateTimeRange(TimeRangeFilter var1);

        default public Builder serviceUpdateTimeRange(Consumer<TimeRangeFilter.Builder> serviceUpdateTimeRange) {
            return this.serviceUpdateTimeRange((TimeRangeFilter)((TimeRangeFilter.Builder)TimeRangeFilter.builder().applyMutation(serviceUpdateTimeRange)).build());
        }

        public Builder updateActionStatusWithStrings(Collection<String> var1);

        public Builder updateActionStatusWithStrings(String ... var1);

        public Builder updateActionStatus(Collection<UpdateActionStatus> var1);

        public Builder updateActionStatus(UpdateActionStatus ... var1);

        public Builder showNodeLevelUpdateStatus(Boolean var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

