/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserGroup implements SdkPojo, Serializable, ToCopyableBuilder<UserGroup.Builder, UserGroup> {
    private static final SdkField<String> USER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserGroupId").getter(getter(UserGroup::userGroupId)).setter(setter(Builder::userGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UserGroup::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(UserGroup::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserIds")
            .getter(getter(UserGroup::userIds))
            .setter(setter(Builder::userIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<UserGroupPendingChanges> PENDING_CHANGES_FIELD = SdkField
            .<UserGroupPendingChanges> builder(MarshallingType.SDK_POJO).memberName("PendingChanges")
            .getter(getter(UserGroup::pendingChanges)).setter(setter(Builder::pendingChanges))
            .constructor(UserGroupPendingChanges::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingChanges").build()).build();

    private static final SdkField<List<String>> REPLICATION_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReplicationGroups")
            .getter(getter(UserGroup::replicationGroups))
            .setter(setter(Builder::replicationGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(UserGroup::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_GROUP_ID_FIELD,
            STATUS_FIELD, ENGINE_FIELD, USER_IDS_FIELD, PENDING_CHANGES_FIELD, REPLICATION_GROUPS_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userGroupId;

    private final String status;

    private final String engine;

    private final List<String> userIds;

    private final UserGroupPendingChanges pendingChanges;

    private final List<String> replicationGroups;

    private final String arn;

    private UserGroup(BuilderImpl builder) {
        this.userGroupId = builder.userGroupId;
        this.status = builder.status;
        this.engine = builder.engine;
        this.userIds = builder.userIds;
        this.pendingChanges = builder.pendingChanges;
        this.replicationGroups = builder.replicationGroups;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The ID of the user group.
     * </p>
     * 
     * @return The ID of the user group.
     */
    public final String userGroupId() {
        return userGroupId;
    }

    /**
     * <p>
     * Indicates user group status. Can be "creating", "active", "modifying", "deleting".
     * </p>
     * 
     * @return Indicates user group status. Can be "creating", "active", "modifying", "deleting".
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The current supported value is Redis.
     * </p>
     * 
     * @return The current supported value is Redis.
     */
    public final String engine() {
        return engine;
    }

    /**
     * Returns true if the UserIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasUserIds() {
        return userIds != null && !(userIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of user IDs that belong to the user group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of user IDs that belong to the user group.
     */
    public final List<String> userIds() {
        return userIds;
    }

    /**
     * <p>
     * A list of updates being applied to the user groups.
     * </p>
     * 
     * @return A list of updates being applied to the user groups.
     */
    public final UserGroupPendingChanges pendingChanges() {
        return pendingChanges;
    }

    /**
     * Returns true if the ReplicationGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasReplicationGroups() {
        return replicationGroups != null && !(replicationGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of replication groups that the user group can access.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicationGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of replication groups that the user group can access.
     */
    public final List<String> replicationGroups() {
        return replicationGroups;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user group.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserIds() ? userIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pendingChanges());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationGroups() ? replicationGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserGroup)) {
            return false;
        }
        UserGroup other = (UserGroup) obj;
        return Objects.equals(userGroupId(), other.userGroupId()) && Objects.equals(status(), other.status())
                && Objects.equals(engine(), other.engine()) && hasUserIds() == other.hasUserIds()
                && Objects.equals(userIds(), other.userIds()) && Objects.equals(pendingChanges(), other.pendingChanges())
                && hasReplicationGroups() == other.hasReplicationGroups()
                && Objects.equals(replicationGroups(), other.replicationGroups()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserGroup").add("UserGroupId", userGroupId()).add("Status", status()).add("Engine", engine())
                .add("UserIds", hasUserIds() ? userIds() : null).add("PendingChanges", pendingChanges())
                .add("ReplicationGroups", hasReplicationGroups() ? replicationGroups() : null).add("ARN", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserGroupId":
            return Optional.ofNullable(clazz.cast(userGroupId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "UserIds":
            return Optional.ofNullable(clazz.cast(userIds()));
        case "PendingChanges":
            return Optional.ofNullable(clazz.cast(pendingChanges()));
        case "ReplicationGroups":
            return Optional.ofNullable(clazz.cast(replicationGroups()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserGroup, T> g) {
        return obj -> g.apply((UserGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserGroup> {
        /**
         * <p>
         * The ID of the user group.
         * </p>
         * 
         * @param userGroupId
         *        The ID of the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupId(String userGroupId);

        /**
         * <p>
         * Indicates user group status. Can be "creating", "active", "modifying", "deleting".
         * </p>
         * 
         * @param status
         *        Indicates user group status. Can be "creating", "active", "modifying", "deleting".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The current supported value is Redis.
         * </p>
         * 
         * @param engine
         *        The current supported value is Redis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The list of user IDs that belong to the user group.
         * </p>
         * 
         * @param userIds
         *        The list of user IDs that belong to the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(Collection<String> userIds);

        /**
         * <p>
         * The list of user IDs that belong to the user group.
         * </p>
         * 
         * @param userIds
         *        The list of user IDs that belong to the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(String... userIds);

        /**
         * <p>
         * A list of updates being applied to the user groups.
         * </p>
         * 
         * @param pendingChanges
         *        A list of updates being applied to the user groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingChanges(UserGroupPendingChanges pendingChanges);

        /**
         * <p>
         * A list of updates being applied to the user groups.
         * </p>
         * This is a convenience that creates an instance of the {@link UserGroupPendingChanges.Builder} avoiding the
         * need to create one manually via {@link UserGroupPendingChanges#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserGroupPendingChanges.Builder#build()} is called immediately
         * and its result is passed to {@link #pendingChanges(UserGroupPendingChanges)}.
         * 
         * @param pendingChanges
         *        a consumer that will call methods on {@link UserGroupPendingChanges.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingChanges(UserGroupPendingChanges)
         */
        default Builder pendingChanges(Consumer<UserGroupPendingChanges.Builder> pendingChanges) {
            return pendingChanges(UserGroupPendingChanges.builder().applyMutation(pendingChanges).build());
        }

        /**
         * <p>
         * A list of replication groups that the user group can access.
         * </p>
         * 
         * @param replicationGroups
         *        A list of replication groups that the user group can access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroups(Collection<String> replicationGroups);

        /**
         * <p>
         * A list of replication groups that the user group can access.
         * </p>
         * 
         * @param replicationGroups
         *        A list of replication groups that the user group can access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroups(String... replicationGroups);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String userGroupId;

        private String status;

        private String engine;

        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();

        private UserGroupPendingChanges pendingChanges;

        private List<String> replicationGroups = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(UserGroup model) {
            userGroupId(model.userGroupId);
            status(model.status);
            engine(model.engine);
            userIds(model.userIds);
            pendingChanges(model.pendingChanges);
            replicationGroups(model.replicationGroups);
            arn(model.arn);
        }

        public final String getUserGroupId() {
            return userGroupId;
        }

        @Override
        public final Builder userGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
            return this;
        }

        public final void setUserGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final Collection<String> getUserIds() {
            if (userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return userIds;
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String... userIds) {
            userIds(Arrays.asList(userIds));
            return this;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdListCopier.copy(userIds);
        }

        public final UserGroupPendingChanges.Builder getPendingChanges() {
            return pendingChanges != null ? pendingChanges.toBuilder() : null;
        }

        @Override
        public final Builder pendingChanges(UserGroupPendingChanges pendingChanges) {
            this.pendingChanges = pendingChanges;
            return this;
        }

        public final void setPendingChanges(UserGroupPendingChanges.BuilderImpl pendingChanges) {
            this.pendingChanges = pendingChanges != null ? pendingChanges.build() : null;
        }

        public final Collection<String> getReplicationGroups() {
            if (replicationGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationGroups;
        }

        @Override
        public final Builder replicationGroups(Collection<String> replicationGroups) {
            this.replicationGroups = UGReplicationGroupIdListCopier.copy(replicationGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroups(String... replicationGroups) {
            replicationGroups(Arrays.asList(replicationGroups));
            return this;
        }

        public final void setReplicationGroups(Collection<String> replicationGroups) {
            this.replicationGroups = UGReplicationGroupIdListCopier.copy(replicationGroups);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public UserGroup build() {
            return new UserGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
