/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>PurchaseReservedCacheNodesOffering</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseReservedCacheNodesOfferingRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<PurchaseReservedCacheNodesOfferingRequest.Builder, PurchaseReservedCacheNodesOfferingRequest> {
    private static final SdkField<String> RESERVED_CACHE_NODES_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedCacheNodesOfferingId")
            .getter(getter(PurchaseReservedCacheNodesOfferingRequest::reservedCacheNodesOfferingId))
            .setter(setter(Builder::reservedCacheNodesOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCacheNodesOfferingId")
                    .build()).build();

    private static final SdkField<String> RESERVED_CACHE_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedCacheNodeId").getter(getter(PurchaseReservedCacheNodesOfferingRequest::reservedCacheNodeId))
            .setter(setter(Builder::reservedCacheNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCacheNodeId").build())
            .build();

    private static final SdkField<Integer> CACHE_NODE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CacheNodeCount").getter(getter(PurchaseReservedCacheNodesOfferingRequest::cacheNodeCount))
            .setter(setter(Builder::cacheNodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_CACHE_NODES_OFFERING_ID_FIELD, RESERVED_CACHE_NODE_ID_FIELD, CACHE_NODE_COUNT_FIELD));

    private final String reservedCacheNodesOfferingId;

    private final String reservedCacheNodeId;

    private final Integer cacheNodeCount;

    private PurchaseReservedCacheNodesOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedCacheNodesOfferingId = builder.reservedCacheNodesOfferingId;
        this.reservedCacheNodeId = builder.reservedCacheNodeId;
        this.cacheNodeCount = builder.cacheNodeCount;
    }

    /**
     * <p>
     * The ID of the reserved cache node offering to purchase.
     * </p>
     * <p>
     * Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code>
     * </p>
     * 
     * @return The ID of the reserved cache node offering to purchase.</p>
     *         <p>
     *         Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code>
     */
    public final String reservedCacheNodesOfferingId() {
        return reservedCacheNodesOfferingId;
    }

    /**
     * <p>
     * A customer-specified identifier to track this reservation.
     * </p>
     * <note>
     * <p>
     * The Reserved Cache Node ID is an unique customer-specified identifier to track this reservation. If this
     * parameter is not specified, ElastiCache automatically generates an identifier for the reservation.
     * </p>
     * </note>
     * <p>
     * Example: myreservationID
     * </p>
     * 
     * @return A customer-specified identifier to track this reservation.</p> <note>
     *         <p>
     *         The Reserved Cache Node ID is an unique customer-specified identifier to track this reservation. If this
     *         parameter is not specified, ElastiCache automatically generates an identifier for the reservation.
     *         </p>
     *         </note>
     *         <p>
     *         Example: myreservationID
     */
    public final String reservedCacheNodeId() {
        return reservedCacheNodeId;
    }

    /**
     * <p>
     * The number of cache node instances to reserve.
     * </p>
     * <p>
     * Default: <code>1</code>
     * </p>
     * 
     * @return The number of cache node instances to reserve.</p>
     *         <p>
     *         Default: <code>1</code>
     */
    public final Integer cacheNodeCount() {
        return cacheNodeCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedCacheNodesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(reservedCacheNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedCacheNodesOfferingRequest)) {
            return false;
        }
        PurchaseReservedCacheNodesOfferingRequest other = (PurchaseReservedCacheNodesOfferingRequest) obj;
        return Objects.equals(reservedCacheNodesOfferingId(), other.reservedCacheNodesOfferingId())
                && Objects.equals(reservedCacheNodeId(), other.reservedCacheNodeId())
                && Objects.equals(cacheNodeCount(), other.cacheNodeCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PurchaseReservedCacheNodesOfferingRequest")
                .add("ReservedCacheNodesOfferingId", reservedCacheNodesOfferingId())
                .add("ReservedCacheNodeId", reservedCacheNodeId()).add("CacheNodeCount", cacheNodeCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedCacheNodesOfferingId":
            return Optional.ofNullable(clazz.cast(reservedCacheNodesOfferingId()));
        case "ReservedCacheNodeId":
            return Optional.ofNullable(clazz.cast(reservedCacheNodeId()));
        case "CacheNodeCount":
            return Optional.ofNullable(clazz.cast(cacheNodeCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedCacheNodesOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseReservedCacheNodesOfferingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PurchaseReservedCacheNodesOfferingRequest> {
        /**
         * <p>
         * The ID of the reserved cache node offering to purchase.
         * </p>
         * <p>
         * Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code>
         * </p>
         * 
         * @param reservedCacheNodesOfferingId
         *        The ID of the reserved cache node offering to purchase.</p>
         *        <p>
         *        Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCacheNodesOfferingId(String reservedCacheNodesOfferingId);

        /**
         * <p>
         * A customer-specified identifier to track this reservation.
         * </p>
         * <note>
         * <p>
         * The Reserved Cache Node ID is an unique customer-specified identifier to track this reservation. If this
         * parameter is not specified, ElastiCache automatically generates an identifier for the reservation.
         * </p>
         * </note>
         * <p>
         * Example: myreservationID
         * </p>
         * 
         * @param reservedCacheNodeId
         *        A customer-specified identifier to track this reservation.</p> <note>
         *        <p>
         *        The Reserved Cache Node ID is an unique customer-specified identifier to track this reservation. If
         *        this parameter is not specified, ElastiCache automatically generates an identifier for the
         *        reservation.
         *        </p>
         *        </note>
         *        <p>
         *        Example: myreservationID
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCacheNodeId(String reservedCacheNodeId);

        /**
         * <p>
         * The number of cache node instances to reserve.
         * </p>
         * <p>
         * Default: <code>1</code>
         * </p>
         * 
         * @param cacheNodeCount
         *        The number of cache node instances to reserve.</p>
         *        <p>
         *        Default: <code>1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeCount(Integer cacheNodeCount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String reservedCacheNodesOfferingId;

        private String reservedCacheNodeId;

        private Integer cacheNodeCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedCacheNodesOfferingRequest model) {
            super(model);
            reservedCacheNodesOfferingId(model.reservedCacheNodesOfferingId);
            reservedCacheNodeId(model.reservedCacheNodeId);
            cacheNodeCount(model.cacheNodeCount);
        }

        public final String getReservedCacheNodesOfferingId() {
            return reservedCacheNodesOfferingId;
        }

        @Override
        public final Builder reservedCacheNodesOfferingId(String reservedCacheNodesOfferingId) {
            this.reservedCacheNodesOfferingId = reservedCacheNodesOfferingId;
            return this;
        }

        public final void setReservedCacheNodesOfferingId(String reservedCacheNodesOfferingId) {
            this.reservedCacheNodesOfferingId = reservedCacheNodesOfferingId;
        }

        public final String getReservedCacheNodeId() {
            return reservedCacheNodeId;
        }

        @Override
        public final Builder reservedCacheNodeId(String reservedCacheNodeId) {
            this.reservedCacheNodeId = reservedCacheNodeId;
            return this;
        }

        public final void setReservedCacheNodeId(String reservedCacheNodeId) {
            this.reservedCacheNodeId = reservedCacheNodeId;
        }

        public final Integer getCacheNodeCount() {
            return cacheNodeCount;
        }

        @Override
        public final Builder cacheNodeCount(Integer cacheNodeCount) {
            this.cacheNodeCount = cacheNodeCount;
            return this;
        }

        public final void setCacheNodeCount(Integer cacheNodeCount) {
            this.cacheNodeCount = cacheNodeCount;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedCacheNodesOfferingRequest build() {
            return new PurchaseReservedCacheNodesOfferingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
