/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the service update on the node group
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeGroupUpdateStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeGroupUpdateStatus.Builder, NodeGroupUpdateStatus> {
    private static final SdkField<String> NODE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeGroupId").getter(getter(NodeGroupUpdateStatus::nodeGroupId)).setter(setter(Builder::nodeGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupId").build()).build();

    private static final SdkField<List<NodeGroupMemberUpdateStatus>> NODE_GROUP_MEMBER_UPDATE_STATUS_FIELD = SdkField
            .<List<NodeGroupMemberUpdateStatus>> builder(MarshallingType.LIST)
            .memberName("NodeGroupMemberUpdateStatus")
            .getter(getter(NodeGroupUpdateStatus::nodeGroupMemberUpdateStatus))
            .setter(setter(Builder::nodeGroupMemberUpdateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupMemberUpdateStatus")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("NodeGroupMemberUpdateStatus")
                            .memberFieldInfo(
                                    SdkField.<NodeGroupMemberUpdateStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeGroupMemberUpdateStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("NodeGroupMemberUpdateStatus").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_GROUP_ID_FIELD,
            NODE_GROUP_MEMBER_UPDATE_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String nodeGroupId;

    private final List<NodeGroupMemberUpdateStatus> nodeGroupMemberUpdateStatus;

    private NodeGroupUpdateStatus(BuilderImpl builder) {
        this.nodeGroupId = builder.nodeGroupId;
        this.nodeGroupMemberUpdateStatus = builder.nodeGroupMemberUpdateStatus;
    }

    /**
     * <p>
     * The ID of the node group
     * </p>
     * 
     * @return The ID of the node group
     */
    public final String nodeGroupId() {
        return nodeGroupId;
    }

    /**
     * Returns true if the NodeGroupMemberUpdateStatus property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasNodeGroupMemberUpdateStatus() {
        return nodeGroupMemberUpdateStatus != null && !(nodeGroupMemberUpdateStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of the service update on the node group member
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNodeGroupMemberUpdateStatus()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The status of the service update on the node group member
     */
    public final List<NodeGroupMemberUpdateStatus> nodeGroupMemberUpdateStatus() {
        return nodeGroupMemberUpdateStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeGroupMemberUpdateStatus() ? nodeGroupMemberUpdateStatus() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroupUpdateStatus)) {
            return false;
        }
        NodeGroupUpdateStatus other = (NodeGroupUpdateStatus) obj;
        return Objects.equals(nodeGroupId(), other.nodeGroupId())
                && hasNodeGroupMemberUpdateStatus() == other.hasNodeGroupMemberUpdateStatus()
                && Objects.equals(nodeGroupMemberUpdateStatus(), other.nodeGroupMemberUpdateStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeGroupUpdateStatus").add("NodeGroupId", nodeGroupId())
                .add("NodeGroupMemberUpdateStatus", hasNodeGroupMemberUpdateStatus() ? nodeGroupMemberUpdateStatus() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NodeGroupId":
            return Optional.ofNullable(clazz.cast(nodeGroupId()));
        case "NodeGroupMemberUpdateStatus":
            return Optional.ofNullable(clazz.cast(nodeGroupMemberUpdateStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeGroupUpdateStatus, T> g) {
        return obj -> g.apply((NodeGroupUpdateStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeGroupUpdateStatus> {
        /**
         * <p>
         * The ID of the node group
         * </p>
         * 
         * @param nodeGroupId
         *        The ID of the node group
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupId(String nodeGroupId);

        /**
         * <p>
         * The status of the service update on the node group member
         * </p>
         * 
         * @param nodeGroupMemberUpdateStatus
         *        The status of the service update on the node group member
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupMemberUpdateStatus(Collection<NodeGroupMemberUpdateStatus> nodeGroupMemberUpdateStatus);

        /**
         * <p>
         * The status of the service update on the node group member
         * </p>
         * 
         * @param nodeGroupMemberUpdateStatus
         *        The status of the service update on the node group member
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupMemberUpdateStatus(NodeGroupMemberUpdateStatus... nodeGroupMemberUpdateStatus);

        /**
         * <p>
         * The status of the service update on the node group member
         * </p>
         * This is a convenience that creates an instance of the {@link List<NodeGroupMemberUpdateStatus>.Builder}
         * avoiding the need to create one manually via {@link List<NodeGroupMemberUpdateStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NodeGroupMemberUpdateStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #nodeGroupMemberUpdateStatus(List<NodeGroupMemberUpdateStatus>)}.
         * 
         * @param nodeGroupMemberUpdateStatus
         *        a consumer that will call methods on {@link List<NodeGroupMemberUpdateStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeGroupMemberUpdateStatus(List<NodeGroupMemberUpdateStatus>)
         */
        Builder nodeGroupMemberUpdateStatus(Consumer<NodeGroupMemberUpdateStatus.Builder>... nodeGroupMemberUpdateStatus);
    }

    static final class BuilderImpl implements Builder {
        private String nodeGroupId;

        private List<NodeGroupMemberUpdateStatus> nodeGroupMemberUpdateStatus = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeGroupUpdateStatus model) {
            nodeGroupId(model.nodeGroupId);
            nodeGroupMemberUpdateStatus(model.nodeGroupMemberUpdateStatus);
        }

        public final String getNodeGroupId() {
            return nodeGroupId;
        }

        @Override
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        public final Collection<NodeGroupMemberUpdateStatus.Builder> getNodeGroupMemberUpdateStatus() {
            if (nodeGroupMemberUpdateStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return nodeGroupMemberUpdateStatus != null ? nodeGroupMemberUpdateStatus.stream()
                    .map(NodeGroupMemberUpdateStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeGroupMemberUpdateStatus(Collection<NodeGroupMemberUpdateStatus> nodeGroupMemberUpdateStatus) {
            this.nodeGroupMemberUpdateStatus = NodeGroupMemberUpdateStatusListCopier.copy(nodeGroupMemberUpdateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupMemberUpdateStatus(NodeGroupMemberUpdateStatus... nodeGroupMemberUpdateStatus) {
            nodeGroupMemberUpdateStatus(Arrays.asList(nodeGroupMemberUpdateStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupMemberUpdateStatus(
                Consumer<NodeGroupMemberUpdateStatus.Builder>... nodeGroupMemberUpdateStatus) {
            nodeGroupMemberUpdateStatus(Stream.of(nodeGroupMemberUpdateStatus)
                    .map(c -> NodeGroupMemberUpdateStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNodeGroupMemberUpdateStatus(
                Collection<NodeGroupMemberUpdateStatus.BuilderImpl> nodeGroupMemberUpdateStatus) {
            this.nodeGroupMemberUpdateStatus = NodeGroupMemberUpdateStatusListCopier.copyFromBuilder(nodeGroupMemberUpdateStatus);
        }

        @Override
        public NodeGroupUpdateStatus build() {
            return new NodeGroupUpdateStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
