/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>DescribeCacheSubnetGroups</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCacheSubnetGroupsRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<DescribeCacheSubnetGroupsRequest.Builder, DescribeCacheSubnetGroupsRequest> {
    private static final SdkField<String> CACHE_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheSubnetGroupName").getter(getter(DescribeCacheSubnetGroupsRequest::cacheSubnetGroupName))
            .setter(setter(Builder::cacheSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroupName").build())
            .build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeCacheSubnetGroupsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeCacheSubnetGroupsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_SUBNET_GROUP_NAME_FIELD,
            MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String cacheSubnetGroupName;

    private final Integer maxRecords;

    private final String marker;

    private DescribeCacheSubnetGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The name of the cache subnet group to return details for.
     * </p>
     * 
     * @return The name of the cache subnet group to return details for.
     */
    public final String cacheSubnetGroupName() {
        return cacheSubnetGroupName;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified
     * <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be
     * retrieved.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * <p>
     * Constraints: minimum 20; maximum 100.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be
     *         retrieved.</p>
     *         <p>
     *         Default: 100
     *         </p>
     *         <p>
     *         Constraints: minimum 20; maximum 100.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation.
     * If this parameter is specified, the response includes only records beyond the marker, up to the value specified
     * by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional marker returned from a prior request. Use this marker for pagination of results from this
     *         operation. If this parameter is specified, the response includes only records beyond the marker, up to
     *         the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheSubnetGroupsRequest)) {
            return false;
        }
        DescribeCacheSubnetGroupsRequest other = (DescribeCacheSubnetGroupsRequest) obj;
        return Objects.equals(cacheSubnetGroupName(), other.cacheSubnetGroupName())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCacheSubnetGroupsRequest").add("CacheSubnetGroupName", cacheSubnetGroupName())
                .add("MaxRecords", maxRecords()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheSubnetGroupName":
            return Optional.ofNullable(clazz.cast(cacheSubnetGroupName()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCacheSubnetGroupsRequest, T> g) {
        return obj -> g.apply((DescribeCacheSubnetGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCacheSubnetGroupsRequest> {
        /**
         * <p>
         * The name of the cache subnet group to return details for.
         * </p>
         * 
         * @param cacheSubnetGroupName
         *        The name of the cache subnet group to return details for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSubnetGroupName(String cacheSubnetGroupName);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified
         * <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be
         * retrieved.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * <p>
         * Constraints: minimum 20; maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can
         *        be retrieved.</p>
         *        <p>
         *        Default: 100
         *        </p>
         *        <p>
         *        Constraints: minimum 20; maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional marker returned from a prior request. Use this marker for pagination of results from this
         * operation. If this parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional marker returned from a prior request. Use this marker for pagination of results from this
         *        operation. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String cacheSubnetGroupName;

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheSubnetGroupsRequest model) {
            super(model);
            cacheSubnetGroupName(model.cacheSubnetGroupName);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getCacheSubnetGroupName() {
            return cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCacheSubnetGroupsRequest build() {
            return new DescribeCacheSubnetGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
