/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeCacheParameterGroups</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCacheParameterGroupsResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<DescribeCacheParameterGroupsResponse.Builder, DescribeCacheParameterGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeCacheParameterGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<CacheParameterGroup>> CACHE_PARAMETER_GROUPS_FIELD = SdkField
            .<List<CacheParameterGroup>> builder(MarshallingType.LIST)
            .memberName("CacheParameterGroups")
            .getter(getter(DescribeCacheParameterGroupsResponse::cacheParameterGroups))
            .setter(setter(Builder::cacheParameterGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheParameterGroup")
                            .memberFieldInfo(
                                    SdkField.<CacheParameterGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(CacheParameterGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheParameterGroup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            CACHE_PARAMETER_GROUPS_FIELD));

    private final String marker;

    private final List<CacheParameterGroup> cacheParameterGroups;

    private DescribeCacheParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.cacheParameterGroups = builder.cacheParameterGroups;
    }

    /**
     * <p>
     * Provides an identifier to allow retrieval of paginated results.
     * </p>
     * 
     * @return Provides an identifier to allow retrieval of paginated results.
     */
    public final String marker() {
        return marker;
    }

    /**
     * Returns true if the CacheParameterGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCacheParameterGroups() {
        return cacheParameterGroups != null && !(cacheParameterGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cache parameter groups. Each element in the list contains detailed information about one cache
     * parameter group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCacheParameterGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of cache parameter groups. Each element in the list contains detailed information about one cache
     *         parameter group.
     */
    public final List<CacheParameterGroup> cacheParameterGroups() {
        return cacheParameterGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheParameterGroups() ? cacheParameterGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheParameterGroupsResponse)) {
            return false;
        }
        DescribeCacheParameterGroupsResponse other = (DescribeCacheParameterGroupsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasCacheParameterGroups() == other.hasCacheParameterGroups()
                && Objects.equals(cacheParameterGroups(), other.cacheParameterGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCacheParameterGroupsResponse").add("Marker", marker())
                .add("CacheParameterGroups", hasCacheParameterGroups() ? cacheParameterGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "CacheParameterGroups":
            return Optional.ofNullable(clazz.cast(cacheParameterGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCacheParameterGroupsResponse, T> g) {
        return obj -> g.apply((DescribeCacheParameterGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCacheParameterGroupsResponse> {
        /**
         * <p>
         * Provides an identifier to allow retrieval of paginated results.
         * </p>
         * 
         * @param marker
         *        Provides an identifier to allow retrieval of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of cache parameter groups. Each element in the list contains detailed information about one cache
         * parameter group.
         * </p>
         * 
         * @param cacheParameterGroups
         *        A list of cache parameter groups. Each element in the list contains detailed information about one
         *        cache parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroups(Collection<CacheParameterGroup> cacheParameterGroups);

        /**
         * <p>
         * A list of cache parameter groups. Each element in the list contains detailed information about one cache
         * parameter group.
         * </p>
         * 
         * @param cacheParameterGroups
         *        A list of cache parameter groups. Each element in the list contains detailed information about one
         *        cache parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroups(CacheParameterGroup... cacheParameterGroups);

        /**
         * <p>
         * A list of cache parameter groups. Each element in the list contains detailed information about one cache
         * parameter group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CacheParameterGroup>.Builder} avoiding the
         * need to create one manually via {@link List<CacheParameterGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CacheParameterGroup>.Builder#build()} is called immediately
         * and its result is passed to {@link #cacheParameterGroups(List<CacheParameterGroup>)}.
         * 
         * @param cacheParameterGroups
         *        a consumer that will call methods on {@link List<CacheParameterGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheParameterGroups(List<CacheParameterGroup>)
         */
        Builder cacheParameterGroups(Consumer<CacheParameterGroup.Builder>... cacheParameterGroups);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private String marker;

        private List<CacheParameterGroup> cacheParameterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheParameterGroupsResponse model) {
            super(model);
            marker(model.marker);
            cacheParameterGroups(model.cacheParameterGroups);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<CacheParameterGroup.Builder> getCacheParameterGroups() {
            if (cacheParameterGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return cacheParameterGroups != null ? cacheParameterGroups.stream().map(CacheParameterGroup::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cacheParameterGroups(Collection<CacheParameterGroup> cacheParameterGroups) {
            this.cacheParameterGroups = CacheParameterGroupListCopier.copy(cacheParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheParameterGroups(CacheParameterGroup... cacheParameterGroups) {
            cacheParameterGroups(Arrays.asList(cacheParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheParameterGroups(Consumer<CacheParameterGroup.Builder>... cacheParameterGroups) {
            cacheParameterGroups(Stream.of(cacheParameterGroups).map(c -> CacheParameterGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCacheParameterGroups(Collection<CacheParameterGroup.BuilderImpl> cacheParameterGroups) {
            this.cacheParameterGroups = CacheParameterGroupListCopier.copyFromBuilder(cacheParameterGroups);
        }

        @Override
        public DescribeCacheParameterGroupsResponse build() {
            return new DescribeCacheParameterGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
