/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCacheSecurityGroupResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<CreateCacheSecurityGroupResponse.Builder, CreateCacheSecurityGroupResponse> {
    private static final SdkField<CacheSecurityGroup> CACHE_SECURITY_GROUP_FIELD = SdkField
            .<CacheSecurityGroup> builder(MarshallingType.SDK_POJO).memberName("CacheSecurityGroup")
            .getter(getter(CreateCacheSecurityGroupResponse::cacheSecurityGroup)).setter(setter(Builder::cacheSecurityGroup))
            .constructor(CacheSecurityGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_SECURITY_GROUP_FIELD));

    private final CacheSecurityGroup cacheSecurityGroup;

    private CreateCacheSecurityGroupResponse(BuilderImpl builder) {
        super(builder);
        this.cacheSecurityGroup = builder.cacheSecurityGroup;
    }

    /**
     * Returns the value of the CacheSecurityGroup property for this object.
     * 
     * @return The value of the CacheSecurityGroup property for this object.
     */
    public final CacheSecurityGroup cacheSecurityGroup() {
        return cacheSecurityGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheSecurityGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCacheSecurityGroupResponse)) {
            return false;
        }
        CreateCacheSecurityGroupResponse other = (CreateCacheSecurityGroupResponse) obj;
        return Objects.equals(cacheSecurityGroup(), other.cacheSecurityGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCacheSecurityGroupResponse").add("CacheSecurityGroup", cacheSecurityGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheSecurityGroup":
            return Optional.ofNullable(clazz.cast(cacheSecurityGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCacheSecurityGroupResponse, T> g) {
        return obj -> g.apply((CreateCacheSecurityGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCacheSecurityGroupResponse> {
        /**
         * Sets the value of the CacheSecurityGroup property for this object.
         *
         * @param cacheSecurityGroup
         *        The new value for the CacheSecurityGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroup(CacheSecurityGroup cacheSecurityGroup);

        /**
         * Sets the value of the CacheSecurityGroup property for this object.
         *
         * This is a convenience that creates an instance of the {@link CacheSecurityGroup.Builder} avoiding the need to
         * create one manually via {@link CacheSecurityGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link CacheSecurityGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheSecurityGroup(CacheSecurityGroup)}.
         * 
         * @param cacheSecurityGroup
         *        a consumer that will call methods on {@link CacheSecurityGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheSecurityGroup(CacheSecurityGroup)
         */
        default Builder cacheSecurityGroup(Consumer<CacheSecurityGroup.Builder> cacheSecurityGroup) {
            return cacheSecurityGroup(CacheSecurityGroup.builder().applyMutation(cacheSecurityGroup).build());
        }
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private CacheSecurityGroup cacheSecurityGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCacheSecurityGroupResponse model) {
            super(model);
            cacheSecurityGroup(model.cacheSecurityGroup);
        }

        public final CacheSecurityGroup.Builder getCacheSecurityGroup() {
            return cacheSecurityGroup != null ? cacheSecurityGroup.toBuilder() : null;
        }

        @Override
        public final Builder cacheSecurityGroup(CacheSecurityGroup cacheSecurityGroup) {
            this.cacheSecurityGroup = cacheSecurityGroup;
            return this;
        }

        public final void setCacheSecurityGroup(CacheSecurityGroup.BuilderImpl cacheSecurityGroup) {
            this.cacheSecurityGroup = cacheSecurityGroup != null ? cacheSecurityGroup.build() : null;
        }

        @Override
        public CreateCacheSecurityGroupResponse build() {
            return new CreateCacheSecurityGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
