/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchApplyUpdateActionResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<BatchApplyUpdateActionResponse.Builder, BatchApplyUpdateActionResponse> {
    private static final SdkField<List<ProcessedUpdateAction>> PROCESSED_UPDATE_ACTIONS_FIELD = SdkField
            .<List<ProcessedUpdateAction>> builder(MarshallingType.LIST)
            .memberName("ProcessedUpdateActions")
            .getter(getter(BatchApplyUpdateActionResponse::processedUpdateActions))
            .setter(setter(Builder::processedUpdateActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedUpdateActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ProcessedUpdateAction")
                            .memberFieldInfo(
                                    SdkField.<ProcessedUpdateAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProcessedUpdateAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ProcessedUpdateAction").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedUpdateAction>> UNPROCESSED_UPDATE_ACTIONS_FIELD = SdkField
            .<List<UnprocessedUpdateAction>> builder(MarshallingType.LIST)
            .memberName("UnprocessedUpdateActions")
            .getter(getter(BatchApplyUpdateActionResponse::unprocessedUpdateActions))
            .setter(setter(Builder::unprocessedUpdateActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedUpdateActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("UnprocessedUpdateAction")
                            .memberFieldInfo(
                                    SdkField.<UnprocessedUpdateAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedUpdateAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("UnprocessedUpdateAction").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROCESSED_UPDATE_ACTIONS_FIELD, UNPROCESSED_UPDATE_ACTIONS_FIELD));

    private final List<ProcessedUpdateAction> processedUpdateActions;

    private final List<UnprocessedUpdateAction> unprocessedUpdateActions;

    private BatchApplyUpdateActionResponse(BuilderImpl builder) {
        super(builder);
        this.processedUpdateActions = builder.processedUpdateActions;
        this.unprocessedUpdateActions = builder.unprocessedUpdateActions;
    }

    /**
     * Returns true if the ProcessedUpdateActions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasProcessedUpdateActions() {
        return processedUpdateActions != null && !(processedUpdateActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Update actions that have been processed successfully
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcessedUpdateActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Update actions that have been processed successfully
     */
    public final List<ProcessedUpdateAction> processedUpdateActions() {
        return processedUpdateActions;
    }

    /**
     * Returns true if the UnprocessedUpdateActions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUnprocessedUpdateActions() {
        return unprocessedUpdateActions != null && !(unprocessedUpdateActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Update actions that haven't been processed successfully
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedUpdateActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Update actions that haven't been processed successfully
     */
    public final List<UnprocessedUpdateAction> unprocessedUpdateActions() {
        return unprocessedUpdateActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessedUpdateActions() ? processedUpdateActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedUpdateActions() ? unprocessedUpdateActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchApplyUpdateActionResponse)) {
            return false;
        }
        BatchApplyUpdateActionResponse other = (BatchApplyUpdateActionResponse) obj;
        return hasProcessedUpdateActions() == other.hasProcessedUpdateActions()
                && Objects.equals(processedUpdateActions(), other.processedUpdateActions())
                && hasUnprocessedUpdateActions() == other.hasUnprocessedUpdateActions()
                && Objects.equals(unprocessedUpdateActions(), other.unprocessedUpdateActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchApplyUpdateActionResponse")
                .add("ProcessedUpdateActions", hasProcessedUpdateActions() ? processedUpdateActions() : null)
                .add("UnprocessedUpdateActions", hasUnprocessedUpdateActions() ? unprocessedUpdateActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcessedUpdateActions":
            return Optional.ofNullable(clazz.cast(processedUpdateActions()));
        case "UnprocessedUpdateActions":
            return Optional.ofNullable(clazz.cast(unprocessedUpdateActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchApplyUpdateActionResponse, T> g) {
        return obj -> g.apply((BatchApplyUpdateActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchApplyUpdateActionResponse> {
        /**
         * <p>
         * Update actions that have been processed successfully
         * </p>
         * 
         * @param processedUpdateActions
         *        Update actions that have been processed successfully
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedUpdateActions(Collection<ProcessedUpdateAction> processedUpdateActions);

        /**
         * <p>
         * Update actions that have been processed successfully
         * </p>
         * 
         * @param processedUpdateActions
         *        Update actions that have been processed successfully
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedUpdateActions(ProcessedUpdateAction... processedUpdateActions);

        /**
         * <p>
         * Update actions that have been processed successfully
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProcessedUpdateAction>.Builder} avoiding
         * the need to create one manually via {@link List<ProcessedUpdateAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProcessedUpdateAction>.Builder#build()} is called
         * immediately and its result is passed to {@link #processedUpdateActions(List<ProcessedUpdateAction>)}.
         * 
         * @param processedUpdateActions
         *        a consumer that will call methods on {@link List<ProcessedUpdateAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processedUpdateActions(List<ProcessedUpdateAction>)
         */
        Builder processedUpdateActions(Consumer<ProcessedUpdateAction.Builder>... processedUpdateActions);

        /**
         * <p>
         * Update actions that haven't been processed successfully
         * </p>
         * 
         * @param unprocessedUpdateActions
         *        Update actions that haven't been processed successfully
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedUpdateActions(Collection<UnprocessedUpdateAction> unprocessedUpdateActions);

        /**
         * <p>
         * Update actions that haven't been processed successfully
         * </p>
         * 
         * @param unprocessedUpdateActions
         *        Update actions that haven't been processed successfully
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedUpdateActions(UnprocessedUpdateAction... unprocessedUpdateActions);

        /**
         * <p>
         * Update actions that haven't been processed successfully
         * </p>
         * This is a convenience that creates an instance of the {@link List<UnprocessedUpdateAction>.Builder} avoiding
         * the need to create one manually via {@link List<UnprocessedUpdateAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnprocessedUpdateAction>.Builder#build()} is called
         * immediately and its result is passed to {@link #unprocessedUpdateActions(List<UnprocessedUpdateAction>)}.
         * 
         * @param unprocessedUpdateActions
         *        a consumer that will call methods on {@link List<UnprocessedUpdateAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedUpdateActions(List<UnprocessedUpdateAction>)
         */
        Builder unprocessedUpdateActions(Consumer<UnprocessedUpdateAction.Builder>... unprocessedUpdateActions);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private List<ProcessedUpdateAction> processedUpdateActions = DefaultSdkAutoConstructList.getInstance();

        private List<UnprocessedUpdateAction> unprocessedUpdateActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchApplyUpdateActionResponse model) {
            super(model);
            processedUpdateActions(model.processedUpdateActions);
            unprocessedUpdateActions(model.unprocessedUpdateActions);
        }

        public final Collection<ProcessedUpdateAction.Builder> getProcessedUpdateActions() {
            if (processedUpdateActions instanceof SdkAutoConstructList) {
                return null;
            }
            return processedUpdateActions != null ? processedUpdateActions.stream().map(ProcessedUpdateAction::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processedUpdateActions(Collection<ProcessedUpdateAction> processedUpdateActions) {
            this.processedUpdateActions = ProcessedUpdateActionListCopier.copy(processedUpdateActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedUpdateActions(ProcessedUpdateAction... processedUpdateActions) {
            processedUpdateActions(Arrays.asList(processedUpdateActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedUpdateActions(Consumer<ProcessedUpdateAction.Builder>... processedUpdateActions) {
            processedUpdateActions(Stream.of(processedUpdateActions)
                    .map(c -> ProcessedUpdateAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProcessedUpdateActions(Collection<ProcessedUpdateAction.BuilderImpl> processedUpdateActions) {
            this.processedUpdateActions = ProcessedUpdateActionListCopier.copyFromBuilder(processedUpdateActions);
        }

        public final Collection<UnprocessedUpdateAction.Builder> getUnprocessedUpdateActions() {
            if (unprocessedUpdateActions instanceof SdkAutoConstructList) {
                return null;
            }
            return unprocessedUpdateActions != null ? unprocessedUpdateActions.stream().map(UnprocessedUpdateAction::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedUpdateActions(Collection<UnprocessedUpdateAction> unprocessedUpdateActions) {
            this.unprocessedUpdateActions = UnprocessedUpdateActionListCopier.copy(unprocessedUpdateActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedUpdateActions(UnprocessedUpdateAction... unprocessedUpdateActions) {
            unprocessedUpdateActions(Arrays.asList(unprocessedUpdateActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedUpdateActions(Consumer<UnprocessedUpdateAction.Builder>... unprocessedUpdateActions) {
            unprocessedUpdateActions(Stream.of(unprocessedUpdateActions)
                    .map(c -> UnprocessedUpdateAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedUpdateActions(Collection<UnprocessedUpdateAction.BuilderImpl> unprocessedUpdateActions) {
            this.unprocessedUpdateActions = UnprocessedUpdateActionListCopier.copyFromBuilder(unprocessedUpdateActions);
        }

        @Override
        public BatchApplyUpdateActionResponse build() {
            return new BatchApplyUpdateActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
