/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus;
import software.amazon.awssdk.services.elasticache.model.ClusterIdListCopier;
import software.amazon.awssdk.services.elasticache.model.Endpoint;
import software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupInfo;
import software.amazon.awssdk.services.elasticache.model.MultiAZStatus;
import software.amazon.awssdk.services.elasticache.model.NodeGroup;
import software.amazon.awssdk.services.elasticache.model.NodeGroupListCopier;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupPendingModifiedValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationGroup> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationGroupId").getter(ReplicationGroup.getter(ReplicationGroup::replicationGroupId)).setter(ReplicationGroup.setter(Builder::replicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ReplicationGroup.getter(ReplicationGroup::description)).setter(ReplicationGroup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<GlobalReplicationGroupInfo> GLOBAL_REPLICATION_GROUP_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GlobalReplicationGroupInfo").getter(ReplicationGroup.getter(ReplicationGroup::globalReplicationGroupInfo)).setter(ReplicationGroup.setter(Builder::globalReplicationGroupInfo)).constructor(GlobalReplicationGroupInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupInfo").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ReplicationGroup.getter(ReplicationGroup::status)).setter(ReplicationGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<ReplicationGroupPendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PendingModifiedValues").getter(ReplicationGroup.getter(ReplicationGroup::pendingModifiedValues)).setter(ReplicationGroup.setter(Builder::pendingModifiedValues)).constructor(ReplicationGroupPendingModifiedValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build()}).build();
    private static final SdkField<List<String>> MEMBER_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MemberClusters").getter(ReplicationGroup.getter(ReplicationGroup::memberClusters)).setter(ReplicationGroup.setter(Builder::memberClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberClusters").build(), ListTrait.builder().memberLocationName("ClusterId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build()).build()}).build();
    private static final SdkField<List<NodeGroup>> NODE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeGroups").getter(ReplicationGroup.getter(ReplicationGroup::nodeGroups)).setter(ReplicationGroup.setter(Builder::nodeGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroups").build(), ListTrait.builder().memberLocationName("NodeGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroup").build()}).build()).build()}).build();
    private static final SdkField<String> SNAPSHOTTING_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshottingClusterId").getter(ReplicationGroup.getter(ReplicationGroup::snapshottingClusterId)).setter(ReplicationGroup.setter(Builder::snapshottingClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshottingClusterId").build()}).build();
    private static final SdkField<String> AUTOMATIC_FAILOVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomaticFailover").getter(ReplicationGroup.getter(ReplicationGroup::automaticFailoverAsString)).setter(ReplicationGroup.setter(Builder::automaticFailover)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailover").build()}).build();
    private static final SdkField<String> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiAZ").getter(ReplicationGroup.getter(ReplicationGroup::multiAZAsString)).setter(ReplicationGroup.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<Endpoint> CONFIGURATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfigurationEndpoint").getter(ReplicationGroup.getter(ReplicationGroup::configurationEndpoint)).setter(ReplicationGroup.setter(Builder::configurationEndpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationEndpoint").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SnapshotRetentionLimit").getter(ReplicationGroup.getter(ReplicationGroup::snapshotRetentionLimit)).setter(ReplicationGroup.setter(Builder::snapshotRetentionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build()}).build();
    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotWindow").getter(ReplicationGroup.getter(ReplicationGroup::snapshotWindow)).setter(ReplicationGroup.setter(Builder::snapshotWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()}).build();
    private static final SdkField<Boolean> CLUSTER_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ClusterEnabled").getter(ReplicationGroup.getter(ReplicationGroup::clusterEnabled)).setter(ReplicationGroup.setter(Builder::clusterEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEnabled").build()}).build();
    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheNodeType").getter(ReplicationGroup.getter(ReplicationGroup::cacheNodeType)).setter(ReplicationGroup.setter(Builder::cacheNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()}).build();
    private static final SdkField<Boolean> AUTH_TOKEN_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AuthTokenEnabled").getter(ReplicationGroup.getter(ReplicationGroup::authTokenEnabled)).setter(ReplicationGroup.setter(Builder::authTokenEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenEnabled").build()}).build();
    private static final SdkField<Instant> AUTH_TOKEN_LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AuthTokenLastModifiedDate").getter(ReplicationGroup.getter(ReplicationGroup::authTokenLastModifiedDate)).setter(ReplicationGroup.setter(Builder::authTokenLastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenLastModifiedDate").build()}).build();
    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TransitEncryptionEnabled").getter(ReplicationGroup.getter(ReplicationGroup::transitEncryptionEnabled)).setter(ReplicationGroup.setter(Builder::transitEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build()}).build();
    private static final SdkField<Boolean> AT_REST_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AtRestEncryptionEnabled").getter(ReplicationGroup.getter(ReplicationGroup::atRestEncryptionEnabled)).setter(ReplicationGroup.setter(Builder::atRestEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtRestEncryptionEnabled").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(ReplicationGroup.getter(ReplicationGroup::kmsKeyId)).setter(ReplicationGroup.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(ReplicationGroup.getter(ReplicationGroup::arn)).setter(ReplicationGroup.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD, DESCRIPTION_FIELD, GLOBAL_REPLICATION_GROUP_INFO_FIELD, STATUS_FIELD, PENDING_MODIFIED_VALUES_FIELD, MEMBER_CLUSTERS_FIELD, NODE_GROUPS_FIELD, SNAPSHOTTING_CLUSTER_ID_FIELD, AUTOMATIC_FAILOVER_FIELD, MULTI_AZ_FIELD, CONFIGURATION_ENDPOINT_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, SNAPSHOT_WINDOW_FIELD, CLUSTER_ENABLED_FIELD, CACHE_NODE_TYPE_FIELD, AUTH_TOKEN_ENABLED_FIELD, AUTH_TOKEN_LAST_MODIFIED_DATE_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD, AT_REST_ENCRYPTION_ENABLED_FIELD, KMS_KEY_ID_FIELD, ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String replicationGroupId;
    private final String description;
    private final GlobalReplicationGroupInfo globalReplicationGroupInfo;
    private final String status;
    private final ReplicationGroupPendingModifiedValues pendingModifiedValues;
    private final List<String> memberClusters;
    private final List<NodeGroup> nodeGroups;
    private final String snapshottingClusterId;
    private final String automaticFailover;
    private final String multiAZ;
    private final Endpoint configurationEndpoint;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final Boolean clusterEnabled;
    private final String cacheNodeType;
    private final Boolean authTokenEnabled;
    private final Instant authTokenLastModifiedDate;
    private final Boolean transitEncryptionEnabled;
    private final Boolean atRestEncryptionEnabled;
    private final String kmsKeyId;
    private final String arn;

    private ReplicationGroup(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.description = builder.description;
        this.globalReplicationGroupInfo = builder.globalReplicationGroupInfo;
        this.status = builder.status;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.memberClusters = builder.memberClusters;
        this.nodeGroups = builder.nodeGroups;
        this.snapshottingClusterId = builder.snapshottingClusterId;
        this.automaticFailover = builder.automaticFailover;
        this.multiAZ = builder.multiAZ;
        this.configurationEndpoint = builder.configurationEndpoint;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.clusterEnabled = builder.clusterEnabled;
        this.cacheNodeType = builder.cacheNodeType;
        this.authTokenEnabled = builder.authTokenEnabled;
        this.authTokenLastModifiedDate = builder.authTokenLastModifiedDate;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
        this.kmsKeyId = builder.kmsKeyId;
        this.arn = builder.arn;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String description() {
        return this.description;
    }

    public GlobalReplicationGroupInfo globalReplicationGroupInfo() {
        return this.globalReplicationGroupInfo;
    }

    public String status() {
        return this.status;
    }

    public ReplicationGroupPendingModifiedValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public boolean hasMemberClusters() {
        return this.memberClusters != null && !(this.memberClusters instanceof SdkAutoConstructList);
    }

    public List<String> memberClusters() {
        return this.memberClusters;
    }

    public boolean hasNodeGroups() {
        return this.nodeGroups != null && !(this.nodeGroups instanceof SdkAutoConstructList);
    }

    public List<NodeGroup> nodeGroups() {
        return this.nodeGroups;
    }

    public String snapshottingClusterId() {
        return this.snapshottingClusterId;
    }

    public AutomaticFailoverStatus automaticFailover() {
        return AutomaticFailoverStatus.fromValue(this.automaticFailover);
    }

    public String automaticFailoverAsString() {
        return this.automaticFailover;
    }

    public MultiAZStatus multiAZ() {
        return MultiAZStatus.fromValue(this.multiAZ);
    }

    public String multiAZAsString() {
        return this.multiAZ;
    }

    public Endpoint configurationEndpoint() {
        return this.configurationEndpoint;
    }

    public Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public String snapshotWindow() {
        return this.snapshotWindow;
    }

    public Boolean clusterEnabled() {
        return this.clusterEnabled;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public Boolean authTokenEnabled() {
        return this.authTokenEnabled;
    }

    public Instant authTokenLastModifiedDate() {
        return this.authTokenLastModifiedDate;
    }

    public Boolean transitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    public Boolean atRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalReplicationGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberClusters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshottingClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticFailoverAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTokenEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTokenLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.atRestEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroup)) {
            return false;
        }
        ReplicationGroup other = (ReplicationGroup)obj;
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.globalReplicationGroupInfo(), other.globalReplicationGroupInfo()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.pendingModifiedValues(), other.pendingModifiedValues()) && Objects.equals(this.memberClusters(), other.memberClusters()) && Objects.equals(this.nodeGroups(), other.nodeGroups()) && Objects.equals(this.snapshottingClusterId(), other.snapshottingClusterId()) && Objects.equals(this.automaticFailoverAsString(), other.automaticFailoverAsString()) && Objects.equals(this.multiAZAsString(), other.multiAZAsString()) && Objects.equals(this.configurationEndpoint(), other.configurationEndpoint()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.clusterEnabled(), other.clusterEnabled()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.authTokenEnabled(), other.authTokenEnabled()) && Objects.equals(this.authTokenLastModifiedDate(), other.authTokenLastModifiedDate()) && Objects.equals(this.transitEncryptionEnabled(), other.transitEncryptionEnabled()) && Objects.equals(this.atRestEncryptionEnabled(), other.atRestEncryptionEnabled()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.arn(), other.arn());
    }

    public String toString() {
        return ToString.builder((String)"ReplicationGroup").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("Description", (Object)this.description()).add("GlobalReplicationGroupInfo", (Object)this.globalReplicationGroupInfo()).add("Status", (Object)this.status()).add("PendingModifiedValues", (Object)this.pendingModifiedValues()).add("MemberClusters", this.memberClusters()).add("NodeGroups", this.nodeGroups()).add("SnapshottingClusterId", (Object)this.snapshottingClusterId()).add("AutomaticFailover", (Object)this.automaticFailoverAsString()).add("MultiAZ", (Object)this.multiAZAsString()).add("ConfigurationEndpoint", (Object)this.configurationEndpoint()).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("SnapshotWindow", (Object)this.snapshotWindow()).add("ClusterEnabled", (Object)this.clusterEnabled()).add("CacheNodeType", (Object)this.cacheNodeType()).add("AuthTokenEnabled", (Object)this.authTokenEnabled()).add("AuthTokenLastModifiedDate", (Object)this.authTokenLastModifiedDate()).add("TransitEncryptionEnabled", (Object)this.transitEncryptionEnabled()).add("AtRestEncryptionEnabled", (Object)this.atRestEncryptionEnabled()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ARN", (Object)this.arn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "GlobalReplicationGroupInfo": {
                return Optional.ofNullable(clazz.cast(this.globalReplicationGroupInfo()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "PendingModifiedValues": {
                return Optional.ofNullable(clazz.cast(this.pendingModifiedValues()));
            }
            case "MemberClusters": {
                return Optional.ofNullable(clazz.cast(this.memberClusters()));
            }
            case "NodeGroups": {
                return Optional.ofNullable(clazz.cast(this.nodeGroups()));
            }
            case "SnapshottingClusterId": {
                return Optional.ofNullable(clazz.cast(this.snapshottingClusterId()));
            }
            case "AutomaticFailover": {
                return Optional.ofNullable(clazz.cast(this.automaticFailoverAsString()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZAsString()));
            }
            case "ConfigurationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.configurationEndpoint()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "SnapshotWindow": {
                return Optional.ofNullable(clazz.cast(this.snapshotWindow()));
            }
            case "ClusterEnabled": {
                return Optional.ofNullable(clazz.cast(this.clusterEnabled()));
            }
            case "CacheNodeType": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeType()));
            }
            case "AuthTokenEnabled": {
                return Optional.ofNullable(clazz.cast(this.authTokenEnabled()));
            }
            case "AuthTokenLastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.authTokenLastModifiedDate()));
            }
            case "TransitEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.transitEncryptionEnabled()));
            }
            case "AtRestEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.atRestEncryptionEnabled()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationGroup, T> g) {
        return obj -> g.apply((ReplicationGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String description;
        private GlobalReplicationGroupInfo globalReplicationGroupInfo;
        private String status;
        private ReplicationGroupPendingModifiedValues pendingModifiedValues;
        private List<String> memberClusters = DefaultSdkAutoConstructList.getInstance();
        private List<NodeGroup> nodeGroups = DefaultSdkAutoConstructList.getInstance();
        private String snapshottingClusterId;
        private String automaticFailover;
        private String multiAZ;
        private Endpoint configurationEndpoint;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private Boolean clusterEnabled;
        private String cacheNodeType;
        private Boolean authTokenEnabled;
        private Instant authTokenLastModifiedDate;
        private Boolean transitEncryptionEnabled;
        private Boolean atRestEncryptionEnabled;
        private String kmsKeyId;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationGroup model) {
            this.replicationGroupId(model.replicationGroupId);
            this.description(model.description);
            this.globalReplicationGroupInfo(model.globalReplicationGroupInfo);
            this.status(model.status);
            this.pendingModifiedValues(model.pendingModifiedValues);
            this.memberClusters(model.memberClusters);
            this.nodeGroups(model.nodeGroups);
            this.snapshottingClusterId(model.snapshottingClusterId);
            this.automaticFailover(model.automaticFailover);
            this.multiAZ(model.multiAZ);
            this.configurationEndpoint(model.configurationEndpoint);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.snapshotWindow(model.snapshotWindow);
            this.clusterEnabled(model.clusterEnabled);
            this.cacheNodeType(model.cacheNodeType);
            this.authTokenEnabled(model.authTokenEnabled);
            this.authTokenLastModifiedDate(model.authTokenLastModifiedDate);
            this.transitEncryptionEnabled(model.transitEncryptionEnabled);
            this.atRestEncryptionEnabled(model.atRestEncryptionEnabled);
            this.kmsKeyId(model.kmsKeyId);
            this.arn(model.arn);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final GlobalReplicationGroupInfo.Builder getGlobalReplicationGroupInfo() {
            return this.globalReplicationGroupInfo != null ? this.globalReplicationGroupInfo.toBuilder() : null;
        }

        @Override
        public final Builder globalReplicationGroupInfo(GlobalReplicationGroupInfo globalReplicationGroupInfo) {
            this.globalReplicationGroupInfo = globalReplicationGroupInfo;
            return this;
        }

        public final void setGlobalReplicationGroupInfo(GlobalReplicationGroupInfo.BuilderImpl globalReplicationGroupInfo) {
            this.globalReplicationGroupInfo = globalReplicationGroupInfo != null ? globalReplicationGroupInfo.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final ReplicationGroupPendingModifiedValues.Builder getPendingModifiedValues() {
            return this.pendingModifiedValues != null ? this.pendingModifiedValues.toBuilder() : null;
        }

        @Override
        public final Builder pendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final void setPendingModifiedValues(ReplicationGroupPendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        public final Collection<String> getMemberClusters() {
            return this.memberClusters;
        }

        @Override
        public final Builder memberClusters(Collection<String> memberClusters) {
            this.memberClusters = ClusterIdListCopier.copy(memberClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberClusters(String ... memberClusters) {
            this.memberClusters(Arrays.asList(memberClusters));
            return this;
        }

        public final void setMemberClusters(Collection<String> memberClusters) {
            this.memberClusters = ClusterIdListCopier.copy(memberClusters);
        }

        public final Collection<NodeGroup.Builder> getNodeGroups() {
            return this.nodeGroups != null ? (Collection)this.nodeGroups.stream().map(NodeGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeGroups(Collection<NodeGroup> nodeGroups) {
            this.nodeGroups = NodeGroupListCopier.copy(nodeGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroups(NodeGroup ... nodeGroups) {
            this.nodeGroups(Arrays.asList(nodeGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroups(Consumer<NodeGroup.Builder> ... nodeGroups) {
            this.nodeGroups(Stream.of(nodeGroups).map(c -> (NodeGroup)((NodeGroup.Builder)NodeGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNodeGroups(Collection<NodeGroup.BuilderImpl> nodeGroups) {
            this.nodeGroups = NodeGroupListCopier.copyFromBuilder(nodeGroups);
        }

        public final String getSnapshottingClusterId() {
            return this.snapshottingClusterId;
        }

        @Override
        public final Builder snapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
            return this;
        }

        public final void setSnapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
        }

        public final String getAutomaticFailover() {
            return this.automaticFailover;
        }

        @Override
        public final Builder automaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
            return this;
        }

        @Override
        public final Builder automaticFailover(AutomaticFailoverStatus automaticFailover) {
            this.automaticFailover(automaticFailover == null ? null : automaticFailover.toString());
            return this;
        }

        public final void setAutomaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
        }

        public final String getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(String multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        @Override
        public final Builder multiAZ(MultiAZStatus multiAZ) {
            this.multiAZ(multiAZ == null ? null : multiAZ.toString());
            return this;
        }

        public final void setMultiAZ(String multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final Endpoint.Builder getConfigurationEndpoint() {
            return this.configurationEndpoint != null ? this.configurationEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder configurationEndpoint(Endpoint configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint;
            return this;
        }

        public final void setConfigurationEndpoint(Endpoint.BuilderImpl configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint != null ? configurationEndpoint.build() : null;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public final Boolean getClusterEnabled() {
            return this.clusterEnabled;
        }

        @Override
        public final Builder clusterEnabled(Boolean clusterEnabled) {
            this.clusterEnabled = clusterEnabled;
            return this;
        }

        public final void setClusterEnabled(Boolean clusterEnabled) {
            this.clusterEnabled = clusterEnabled;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final Boolean getAuthTokenEnabled() {
            return this.authTokenEnabled;
        }

        @Override
        public final Builder authTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
            return this;
        }

        public final void setAuthTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
        }

        public final Instant getAuthTokenLastModifiedDate() {
            return this.authTokenLastModifiedDate;
        }

        @Override
        public final Builder authTokenLastModifiedDate(Instant authTokenLastModifiedDate) {
            this.authTokenLastModifiedDate = authTokenLastModifiedDate;
            return this;
        }

        public final void setAuthTokenLastModifiedDate(Instant authTokenLastModifiedDate) {
            this.authTokenLastModifiedDate = authTokenLastModifiedDate;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return this.transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return this.atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public ReplicationGroup build() {
            return new ReplicationGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationGroup> {
        public Builder replicationGroupId(String var1);

        public Builder description(String var1);

        public Builder globalReplicationGroupInfo(GlobalReplicationGroupInfo var1);

        default public Builder globalReplicationGroupInfo(Consumer<GlobalReplicationGroupInfo.Builder> globalReplicationGroupInfo) {
            return this.globalReplicationGroupInfo((GlobalReplicationGroupInfo)((GlobalReplicationGroupInfo.Builder)GlobalReplicationGroupInfo.builder().applyMutation(globalReplicationGroupInfo)).build());
        }

        public Builder status(String var1);

        public Builder pendingModifiedValues(ReplicationGroupPendingModifiedValues var1);

        default public Builder pendingModifiedValues(Consumer<ReplicationGroupPendingModifiedValues.Builder> pendingModifiedValues) {
            return this.pendingModifiedValues((ReplicationGroupPendingModifiedValues)((ReplicationGroupPendingModifiedValues.Builder)ReplicationGroupPendingModifiedValues.builder().applyMutation(pendingModifiedValues)).build());
        }

        public Builder memberClusters(Collection<String> var1);

        public Builder memberClusters(String ... var1);

        public Builder nodeGroups(Collection<NodeGroup> var1);

        public Builder nodeGroups(NodeGroup ... var1);

        public Builder nodeGroups(Consumer<NodeGroup.Builder> ... var1);

        public Builder snapshottingClusterId(String var1);

        public Builder automaticFailover(String var1);

        public Builder automaticFailover(AutomaticFailoverStatus var1);

        public Builder multiAZ(String var1);

        public Builder multiAZ(MultiAZStatus var1);

        public Builder configurationEndpoint(Endpoint var1);

        default public Builder configurationEndpoint(Consumer<Endpoint.Builder> configurationEndpoint) {
            return this.configurationEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(configurationEndpoint)).build());
        }

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder clusterEnabled(Boolean var1);

        public Builder cacheNodeType(String var1);

        public Builder authTokenEnabled(Boolean var1);

        public Builder authTokenLastModifiedDate(Instant var1);

        public Builder transitEncryptionEnabled(Boolean var1);

        public Builder atRestEncryptionEnabled(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder arn(String var1);
    }
}

