/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCacheClustersRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, DescribeCacheClustersRequest> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheClusterId").getter(DescribeCacheClustersRequest.getter(DescribeCacheClustersRequest::cacheClusterId)).setter(DescribeCacheClustersRequest.setter(Builder::cacheClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeCacheClustersRequest.getter(DescribeCacheClustersRequest::maxRecords)).setter(DescribeCacheClustersRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeCacheClustersRequest.getter(DescribeCacheClustersRequest::marker)).setter(DescribeCacheClustersRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Boolean> SHOW_CACHE_NODE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ShowCacheNodeInfo").getter(DescribeCacheClustersRequest.getter(DescribeCacheClustersRequest::showCacheNodeInfo)).setter(DescribeCacheClustersRequest.setter(Builder::showCacheNodeInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowCacheNodeInfo").build()}).build();
    private static final SdkField<Boolean> SHOW_CACHE_CLUSTERS_NOT_IN_REPLICATION_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ShowCacheClustersNotInReplicationGroups").getter(DescribeCacheClustersRequest.getter(DescribeCacheClustersRequest::showCacheClustersNotInReplicationGroups)).setter(DescribeCacheClustersRequest.setter(Builder::showCacheClustersNotInReplicationGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowCacheClustersNotInReplicationGroups").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD, SHOW_CACHE_NODE_INFO_FIELD, SHOW_CACHE_CLUSTERS_NOT_IN_REPLICATION_GROUPS_FIELD));
    private final String cacheClusterId;
    private final Integer maxRecords;
    private final String marker;
    private final Boolean showCacheNodeInfo;
    private final Boolean showCacheClustersNotInReplicationGroups;

    private DescribeCacheClustersRequest(BuilderImpl builder) {
        super(builder);
        this.cacheClusterId = builder.cacheClusterId;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.showCacheNodeInfo = builder.showCacheNodeInfo;
        this.showCacheClustersNotInReplicationGroups = builder.showCacheClustersNotInReplicationGroups;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean showCacheNodeInfo() {
        return this.showCacheNodeInfo;
    }

    public Boolean showCacheClustersNotInReplicationGroups() {
        return this.showCacheClustersNotInReplicationGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.showCacheNodeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.showCacheClustersNotInReplicationGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheClustersRequest)) {
            return false;
        }
        DescribeCacheClustersRequest other = (DescribeCacheClustersRequest)((Object)obj);
        return Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.showCacheNodeInfo(), other.showCacheNodeInfo()) && Objects.equals(this.showCacheClustersNotInReplicationGroups(), other.showCacheClustersNotInReplicationGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCacheClustersRequest").add("CacheClusterId", (Object)this.cacheClusterId()).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).add("ShowCacheNodeInfo", (Object)this.showCacheNodeInfo()).add("ShowCacheClustersNotInReplicationGroups", (Object)this.showCacheClustersNotInReplicationGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheClusterId": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterId()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ShowCacheNodeInfo": {
                return Optional.ofNullable(clazz.cast(this.showCacheNodeInfo()));
            }
            case "ShowCacheClustersNotInReplicationGroups": {
                return Optional.ofNullable(clazz.cast(this.showCacheClustersNotInReplicationGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCacheClustersRequest, T> g) {
        return obj -> g.apply((DescribeCacheClustersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private Integer maxRecords;
        private String marker;
        private Boolean showCacheNodeInfo;
        private Boolean showCacheClustersNotInReplicationGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheClustersRequest model) {
            super(model);
            this.cacheClusterId(model.cacheClusterId);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
            this.showCacheNodeInfo(model.showCacheNodeInfo);
            this.showCacheClustersNotInReplicationGroups(model.showCacheClustersNotInReplicationGroups);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getShowCacheNodeInfo() {
            return this.showCacheNodeInfo;
        }

        @Override
        public final Builder showCacheNodeInfo(Boolean showCacheNodeInfo) {
            this.showCacheNodeInfo = showCacheNodeInfo;
            return this;
        }

        public final void setShowCacheNodeInfo(Boolean showCacheNodeInfo) {
            this.showCacheNodeInfo = showCacheNodeInfo;
        }

        public final Boolean getShowCacheClustersNotInReplicationGroups() {
            return this.showCacheClustersNotInReplicationGroups;
        }

        @Override
        public final Builder showCacheClustersNotInReplicationGroups(Boolean showCacheClustersNotInReplicationGroups) {
            this.showCacheClustersNotInReplicationGroups = showCacheClustersNotInReplicationGroups;
            return this;
        }

        public final void setShowCacheClustersNotInReplicationGroups(Boolean showCacheClustersNotInReplicationGroups) {
            this.showCacheClustersNotInReplicationGroups = showCacheClustersNotInReplicationGroups;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCacheClustersRequest build() {
            return new DescribeCacheClustersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCacheClustersRequest> {
        public Builder cacheClusterId(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder showCacheNodeInfo(Boolean var1);

        public Builder showCacheClustersNotInReplicationGroups(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

