/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CustomerNodeEndpoint;
import software.amazon.awssdk.services.elasticache.model.CustomerNodeEndpointListCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMigrationRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, StartMigrationRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartMigrationRequest.getter(StartMigrationRequest::replicationGroupId)).setter(StartMigrationRequest.setter(Builder::replicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build()}).build();
    private static final SdkField<List<CustomerNodeEndpoint>> CUSTOMER_NODE_ENDPOINT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StartMigrationRequest.getter(StartMigrationRequest::customerNodeEndpointList)).setter(StartMigrationRequest.setter(Builder::customerNodeEndpointList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerNodeEndpointList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomerNodeEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD, CUSTOMER_NODE_ENDPOINT_LIST_FIELD));
    private final String replicationGroupId;
    private final List<CustomerNodeEndpoint> customerNodeEndpointList;

    private StartMigrationRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.customerNodeEndpointList = builder.customerNodeEndpointList;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public List<CustomerNodeEndpoint> customerNodeEndpointList() {
        return this.customerNodeEndpointList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerNodeEndpointList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMigrationRequest)) {
            return false;
        }
        StartMigrationRequest other = (StartMigrationRequest)((Object)obj);
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.customerNodeEndpointList(), other.customerNodeEndpointList());
    }

    public String toString() {
        return ToString.builder((String)"StartMigrationRequest").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("CustomerNodeEndpointList", this.customerNodeEndpointList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "CustomerNodeEndpointList": {
                return Optional.ofNullable(clazz.cast(this.customerNodeEndpointList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMigrationRequest, T> g) {
        return obj -> g.apply((StartMigrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private List<CustomerNodeEndpoint> customerNodeEndpointList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartMigrationRequest model) {
            super(model);
            this.replicationGroupId(model.replicationGroupId);
            this.customerNodeEndpointList(model.customerNodeEndpointList);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final Collection<CustomerNodeEndpoint.Builder> getCustomerNodeEndpointList() {
            return this.customerNodeEndpointList != null ? (Collection)this.customerNodeEndpointList.stream().map(CustomerNodeEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customerNodeEndpointList(Collection<CustomerNodeEndpoint> customerNodeEndpointList) {
            this.customerNodeEndpointList = CustomerNodeEndpointListCopier.copy(customerNodeEndpointList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerNodeEndpointList(CustomerNodeEndpoint ... customerNodeEndpointList) {
            this.customerNodeEndpointList(Arrays.asList(customerNodeEndpointList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerNodeEndpointList(Consumer<CustomerNodeEndpoint.Builder> ... customerNodeEndpointList) {
            this.customerNodeEndpointList(Stream.of(customerNodeEndpointList).map(c -> (CustomerNodeEndpoint)((CustomerNodeEndpoint.Builder)CustomerNodeEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomerNodeEndpointList(Collection<CustomerNodeEndpoint.BuilderImpl> customerNodeEndpointList) {
            this.customerNodeEndpointList = CustomerNodeEndpointListCopier.copyFromBuilder(customerNodeEndpointList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMigrationRequest build() {
            return new StartMigrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMigrationRequest> {
        public Builder replicationGroupId(String var1);

        public Builder customerNodeEndpointList(Collection<CustomerNodeEndpoint> var1);

        public Builder customerNodeEndpointList(CustomerNodeEndpoint ... var1);

        public Builder customerNodeEndpointList(Consumer<CustomerNodeEndpoint.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

