/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSnapshotRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, CreateSnapshotRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSnapshotRequest.getter(CreateSnapshotRequest::replicationGroupId)).setter(CreateSnapshotRequest.setter(Builder::replicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build()}).build();
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSnapshotRequest.getter(CreateSnapshotRequest::cacheClusterId)).setter(CreateSnapshotRequest.setter(Builder::cacheClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()}).build();
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSnapshotRequest.getter(CreateSnapshotRequest::snapshotName)).setter(CreateSnapshotRequest.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSnapshotRequest.getter(CreateSnapshotRequest::kmsKeyId)).setter(CreateSnapshotRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD, CACHE_CLUSTER_ID_FIELD, SNAPSHOT_NAME_FIELD, KMS_KEY_ID_FIELD));
    private final String replicationGroupId;
    private final String cacheClusterId;
    private final String snapshotName;
    private final String kmsKeyId;

    private CreateSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.cacheClusterId = builder.cacheClusterId;
        this.snapshotName = builder.snapshotName;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotRequest)) {
            return false;
        }
        CreateSnapshotRequest other = (CreateSnapshotRequest)((Object)obj);
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.snapshotName(), other.snapshotName()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public String toString() {
        return ToString.builder((String)"CreateSnapshotRequest").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("CacheClusterId", (Object)this.cacheClusterId()).add("SnapshotName", (Object)this.snapshotName()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "CacheClusterId": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterId()));
            }
            case "SnapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotRequest, T> g) {
        return obj -> g.apply((CreateSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String cacheClusterId;
        private String snapshotName;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotRequest model) {
            super(model);
            this.replicationGroupId(model.replicationGroupId);
            this.cacheClusterId(model.cacheClusterId);
            this.snapshotName(model.snapshotName);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSnapshotRequest build() {
            return new CreateSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSnapshotRequest> {
        public Builder replicationGroupId(String var1);

        public Builder cacheClusterId(String var1);

        public Builder snapshotName(String var1);

        public Builder kmsKeyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

