/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCapabilityRequest extends EksRequest implements
        ToCopyableBuilder<UpdateCapabilityRequest.Builder, UpdateCapabilityRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(UpdateCapabilityRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> CAPABILITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capabilityName").getter(getter(UpdateCapabilityRequest::capabilityName))
            .setter(setter(Builder::capabilityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("capabilityName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateCapabilityRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<UpdateCapabilityConfiguration> CONFIGURATION_FIELD = SdkField
            .<UpdateCapabilityConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(UpdateCapabilityRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(UpdateCapabilityConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(UpdateCapabilityRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DELETE_PROPAGATION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deletePropagationPolicy").getter(getter(UpdateCapabilityRequest::deletePropagationPolicyAsString))
            .setter(setter(Builder::deletePropagationPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletePropagationPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            CAPABILITY_NAME_FIELD, ROLE_ARN_FIELD, CONFIGURATION_FIELD, CLIENT_REQUEST_TOKEN_FIELD,
            DELETE_PROPAGATION_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterName;

    private final String capabilityName;

    private final String roleArn;

    private final UpdateCapabilityConfiguration configuration;

    private final String clientRequestToken;

    private final String deletePropagationPolicy;

    private UpdateCapabilityRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.capabilityName = builder.capabilityName;
        this.roleArn = builder.roleArn;
        this.configuration = builder.configuration;
        this.clientRequestToken = builder.clientRequestToken;
        this.deletePropagationPolicy = builder.deletePropagationPolicy;
    }

    /**
     * <p>
     * The name of the Amazon EKS cluster that contains the capability you want to update configuration for.
     * </p>
     * 
     * @return The name of the Amazon EKS cluster that contains the capability you want to update configuration for.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The name of the capability to update configuration for.
     * </p>
     * 
     * @return The name of the capability to update configuration for.
     */
    public final String capabilityName() {
        return capabilityName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that the capability uses to interact with Amazon Web Services
     * services. If you specify a new role ARN, the capability will start using the new role for all subsequent
     * operations.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that the capability uses to interact with Amazon Web
     *         Services services. If you specify a new role ARN, the capability will start using the new role for all
     *         subsequent operations.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The updated configuration settings for the capability. You only need to specify the configuration parameters you
     * want to change. For Argo CD capabilities, you can update RBAC role mappings and network access settings.
     * </p>
     * 
     * @return The updated configuration settings for the capability. You only need to specify the configuration
     *         parameters you want to change. For Argo CD capabilities, you can update RBAC role mappings and network
     *         access settings.
     */
    public final UpdateCapabilityConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This token is
     * valid for 24 hours after creation.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This token
     *         is valid for 24 hours after creation.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The updated delete propagation policy for the capability. Currently, the only supported value is
     * <code>RETAIN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deletePropagationPolicy} will return {@link CapabilityDeletePropagationPolicy#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #deletePropagationPolicyAsString}.
     * </p>
     * 
     * @return The updated delete propagation policy for the capability. Currently, the only supported value is
     *         <code>RETAIN</code>.
     * @see CapabilityDeletePropagationPolicy
     */
    public final CapabilityDeletePropagationPolicy deletePropagationPolicy() {
        return CapabilityDeletePropagationPolicy.fromValue(deletePropagationPolicy);
    }

    /**
     * <p>
     * The updated delete propagation policy for the capability. Currently, the only supported value is
     * <code>RETAIN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deletePropagationPolicy} will return {@link CapabilityDeletePropagationPolicy#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #deletePropagationPolicyAsString}.
     * </p>
     * 
     * @return The updated delete propagation policy for the capability. Currently, the only supported value is
     *         <code>RETAIN</code>.
     * @see CapabilityDeletePropagationPolicy
     */
    public final String deletePropagationPolicyAsString() {
        return deletePropagationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(capabilityName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(deletePropagationPolicyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCapabilityRequest)) {
            return false;
        }
        UpdateCapabilityRequest other = (UpdateCapabilityRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(capabilityName(), other.capabilityName())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(deletePropagationPolicyAsString(), other.deletePropagationPolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCapabilityRequest").add("ClusterName", clusterName())
                .add("CapabilityName", capabilityName()).add("RoleArn", roleArn()).add("Configuration", configuration())
                .add("ClientRequestToken", clientRequestToken())
                .add("DeletePropagationPolicy", deletePropagationPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "capabilityName":
            return Optional.ofNullable(clazz.cast(capabilityName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "deletePropagationPolicy":
            return Optional.ofNullable(clazz.cast(deletePropagationPolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", CLUSTER_NAME_FIELD);
        map.put("capabilityName", CAPABILITY_NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("deletePropagationPolicy", DELETE_PROPAGATION_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCapabilityRequest, T> g) {
        return obj -> g.apply((UpdateCapabilityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCapabilityRequest> {
        /**
         * <p>
         * The name of the Amazon EKS cluster that contains the capability you want to update configuration for.
         * </p>
         * 
         * @param clusterName
         *        The name of the Amazon EKS cluster that contains the capability you want to update configuration for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The name of the capability to update configuration for.
         * </p>
         * 
         * @param capabilityName
         *        The name of the capability to update configuration for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityName(String capabilityName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that the capability uses to interact with Amazon Web Services
         * services. If you specify a new role ARN, the capability will start using the new role for all subsequent
         * operations.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that the capability uses to interact with Amazon Web
         *        Services services. If you specify a new role ARN, the capability will start using the new role for all
         *        subsequent operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The updated configuration settings for the capability. You only need to specify the configuration parameters
         * you want to change. For Argo CD capabilities, you can update RBAC role mappings and network access settings.
         * </p>
         * 
         * @param configuration
         *        The updated configuration settings for the capability. You only need to specify the configuration
         *        parameters you want to change. For Argo CD capabilities, you can update RBAC role mappings and network
         *        access settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(UpdateCapabilityConfiguration configuration);

        /**
         * <p>
         * The updated configuration settings for the capability. You only need to specify the configuration parameters
         * you want to change. For Argo CD capabilities, you can update RBAC role mappings and network access settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateCapabilityConfiguration.Builder}
         * avoiding the need to create one manually via {@link UpdateCapabilityConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateCapabilityConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(UpdateCapabilityConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link UpdateCapabilityConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(UpdateCapabilityConfiguration)
         */
        default Builder configuration(Consumer<UpdateCapabilityConfiguration.Builder> configuration) {
            return configuration(UpdateCapabilityConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This token is
         * valid for 24 hours after creation.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This
         *        token is valid for 24 hours after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The updated delete propagation policy for the capability. Currently, the only supported value is
         * <code>RETAIN</code>.
         * </p>
         * 
         * @param deletePropagationPolicy
         *        The updated delete propagation policy for the capability. Currently, the only supported value is
         *        <code>RETAIN</code>.
         * @see CapabilityDeletePropagationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityDeletePropagationPolicy
         */
        Builder deletePropagationPolicy(String deletePropagationPolicy);

        /**
         * <p>
         * The updated delete propagation policy for the capability. Currently, the only supported value is
         * <code>RETAIN</code>.
         * </p>
         * 
         * @param deletePropagationPolicy
         *        The updated delete propagation policy for the capability. Currently, the only supported value is
         *        <code>RETAIN</code>.
         * @see CapabilityDeletePropagationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityDeletePropagationPolicy
         */
        Builder deletePropagationPolicy(CapabilityDeletePropagationPolicy deletePropagationPolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String capabilityName;

        private String roleArn;

        private UpdateCapabilityConfiguration configuration;

        private String clientRequestToken;

        private String deletePropagationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCapabilityRequest model) {
            super(model);
            clusterName(model.clusterName);
            capabilityName(model.capabilityName);
            roleArn(model.roleArn);
            configuration(model.configuration);
            clientRequestToken(model.clientRequestToken);
            deletePropagationPolicy(model.deletePropagationPolicy);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getCapabilityName() {
            return capabilityName;
        }

        public final void setCapabilityName(String capabilityName) {
            this.capabilityName = capabilityName;
        }

        @Override
        public final Builder capabilityName(String capabilityName) {
            this.capabilityName = capabilityName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final UpdateCapabilityConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(UpdateCapabilityConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(UpdateCapabilityConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getDeletePropagationPolicy() {
            return deletePropagationPolicy;
        }

        public final void setDeletePropagationPolicy(String deletePropagationPolicy) {
            this.deletePropagationPolicy = deletePropagationPolicy;
        }

        @Override
        public final Builder deletePropagationPolicy(String deletePropagationPolicy) {
            this.deletePropagationPolicy = deletePropagationPolicy;
            return this;
        }

        @Override
        public final Builder deletePropagationPolicy(CapabilityDeletePropagationPolicy deletePropagationPolicy) {
            this.deletePropagationPolicy(deletePropagationPolicy == null ? null : deletePropagationPolicy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCapabilityRequest build() {
            return new UpdateCapabilityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
