/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to update the configuration of the storage capability of your EKS Auto Mode cluster. For example, enable the
 * capability. For more information, see EKS Auto Mode block storage capability in the <i>Amazon EKS User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageConfigRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageConfigRequest.Builder, StorageConfigRequest> {
    private static final SdkField<BlockStorage> BLOCK_STORAGE_FIELD = SdkField.<BlockStorage> builder(MarshallingType.SDK_POJO)
            .memberName("blockStorage").getter(getter(StorageConfigRequest::blockStorage)).setter(setter(Builder::blockStorage))
            .constructor(BlockStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockStorage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_STORAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BlockStorage blockStorage;

    private StorageConfigRequest(BuilderImpl builder) {
        this.blockStorage = builder.blockStorage;
    }

    /**
     * <p>
     * Request to configure EBS Block Storage settings for your EKS Auto Mode cluster.
     * </p>
     * 
     * @return Request to configure EBS Block Storage settings for your EKS Auto Mode cluster.
     */
    public final BlockStorage blockStorage() {
        return blockStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blockStorage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageConfigRequest)) {
            return false;
        }
        StorageConfigRequest other = (StorageConfigRequest) obj;
        return Objects.equals(blockStorage(), other.blockStorage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageConfigRequest").add("BlockStorage", blockStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blockStorage":
            return Optional.ofNullable(clazz.cast(blockStorage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blockStorage", BLOCK_STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StorageConfigRequest, T> g) {
        return obj -> g.apply((StorageConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageConfigRequest> {
        /**
         * <p>
         * Request to configure EBS Block Storage settings for your EKS Auto Mode cluster.
         * </p>
         * 
         * @param blockStorage
         *        Request to configure EBS Block Storage settings for your EKS Auto Mode cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockStorage(BlockStorage blockStorage);

        /**
         * <p>
         * Request to configure EBS Block Storage settings for your EKS Auto Mode cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link BlockStorage.Builder} avoiding the need
         * to create one manually via {@link BlockStorage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #blockStorage(BlockStorage)}.
         * 
         * @param blockStorage
         *        a consumer that will call methods on {@link BlockStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockStorage(BlockStorage)
         */
        default Builder blockStorage(Consumer<BlockStorage.Builder> blockStorage) {
            return blockStorage(BlockStorage.builder().applyMutation(blockStorage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BlockStorage blockStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageConfigRequest model) {
            blockStorage(model.blockStorage);
        }

        public final BlockStorage.Builder getBlockStorage() {
            return blockStorage != null ? blockStorage.toBuilder() : null;
        }

        public final void setBlockStorage(BlockStorage.BuilderImpl blockStorage) {
            this.blockStorage = blockStorage != null ? blockStorage.build() : null;
        }

        @Override
        public final Builder blockStorage(BlockStorage blockStorage) {
            this.blockStorage = blockStorage;
            return this;
        }

        @Override
        public StorageConfigRequest build() {
            return new StorageConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
