/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration in the cluster for EKS Hybrid Nodes. You can add, change, or remove this configuration after the
 * cluster is created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoteNetworkConfigRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<RemoteNetworkConfigRequest.Builder, RemoteNetworkConfigRequest> {
    private static final SdkField<List<RemoteNodeNetwork>> REMOTE_NODE_NETWORKS_FIELD = SdkField
            .<List<RemoteNodeNetwork>> builder(MarshallingType.LIST)
            .memberName("remoteNodeNetworks")
            .getter(getter(RemoteNetworkConfigRequest::remoteNodeNetworks))
            .setter(setter(Builder::remoteNodeNetworks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteNodeNetworks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemoteNodeNetwork> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemoteNodeNetwork::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RemotePodNetwork>> REMOTE_POD_NETWORKS_FIELD = SdkField
            .<List<RemotePodNetwork>> builder(MarshallingType.LIST)
            .memberName("remotePodNetworks")
            .getter(getter(RemoteNetworkConfigRequest::remotePodNetworks))
            .setter(setter(Builder::remotePodNetworks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remotePodNetworks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemotePodNetwork> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemotePodNetwork::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOTE_NODE_NETWORKS_FIELD,
            REMOTE_POD_NETWORKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RemoteNodeNetwork> remoteNodeNetworks;

    private final List<RemotePodNetwork> remotePodNetworks;

    private RemoteNetworkConfigRequest(BuilderImpl builder) {
        this.remoteNodeNetworks = builder.remoteNodeNetworks;
        this.remotePodNetworks = builder.remotePodNetworks;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoteNodeNetworks property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoteNodeNetworks() {
        return remoteNodeNetworks != null && !(remoteNodeNetworks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of network CIDRs that can contain hybrid nodes.
     * </p>
     * <p>
     * These CIDR blocks define the expected IP address range of the hybrid nodes that join the cluster. These blocks
     * are typically determined by your network administrator.
     * </p>
     * <p>
     * Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example, <code> 10.2.0.0/16</code>).
     * </p>
     * <p>
     * It must satisfy the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /32, maximum
     * allowed size is /8. Publicly-routable addresses aren't supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of the
     * Kubernetes service IP range.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each block must have a route to the VPC that uses the VPC CIDR blocks, not public IPs or Elastic IPs. There are
     * many options including Transit Gateway, Site-to-Site VPN, or Direct Connect.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each host must allow outbound connection to the EKS cluster control plane on TCP ports <code>443</code> and
     * <code>10250</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each host must allow inbound connection from the EKS cluster control plane on TCP port 10250 for logs, exec and
     * port-forward operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each host must allow TCP and UDP network connectivity to and from other hosts that are running
     * <code>CoreDNS</code> on UDP port <code>53</code> for service and pod DNS names.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoteNodeNetworks} method.
     * </p>
     * 
     * @return The list of network CIDRs that can contain hybrid nodes.</p>
     *         <p>
     *         These CIDR blocks define the expected IP address range of the hybrid nodes that join the cluster. These
     *         blocks are typically determined by your network administrator.
     *         </p>
     *         <p>
     *         Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example,
     *         <code> 10.2.0.0/16</code>).
     *         </p>
     *         <p>
     *         It must satisfy the following requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /32,
     *         maximum allowed size is /8. Publicly-routable addresses aren't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of
     *         the Kubernetes service IP range.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each block must have a route to the VPC that uses the VPC CIDR blocks, not public IPs or Elastic IPs.
     *         There are many options including Transit Gateway, Site-to-Site VPN, or Direct Connect.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each host must allow outbound connection to the EKS cluster control plane on TCP ports <code>443</code>
     *         and <code>10250</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each host must allow inbound connection from the EKS cluster control plane on TCP port 10250 for logs,
     *         exec and port-forward operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each host must allow TCP and UDP network connectivity to and from other hosts that are running
     *         <code>CoreDNS</code> on UDP port <code>53</code> for service and pod DNS names.
     *         </p>
     *         </li>
     */
    public final List<RemoteNodeNetwork> remoteNodeNetworks() {
        return remoteNodeNetworks;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemotePodNetworks property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemotePodNetworks() {
        return remotePodNetworks != null && !(remotePodNetworks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.
     * </p>
     * <p>
     * These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We recommend the
     * Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't available for on-premises and
     * edge locations.
     * </p>
     * <p>
     * Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example, <code> 10.2.0.0/16</code>).
     * </p>
     * <p>
     * It must satisfy the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /32, maximum
     * allowed size is /8. Publicly-routable addresses aren't supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of the
     * Kubernetes service IP range.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemotePodNetworks} method.
     * </p>
     * 
     * @return The list of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.</p>
     *         <p>
     *         These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We
     *         recommend the Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't
     *         available for on-premises and edge locations.
     *         </p>
     *         <p>
     *         Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example,
     *         <code> 10.2.0.0/16</code>).
     *         </p>
     *         <p>
     *         It must satisfy the following requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /32,
     *         maximum allowed size is /8. Publicly-routable addresses aren't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of
     *         the Kubernetes service IP range.
     *         </p>
     *         </li>
     */
    public final List<RemotePodNetwork> remotePodNetworks() {
        return remotePodNetworks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoteNodeNetworks() ? remoteNodeNetworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemotePodNetworks() ? remotePodNetworks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteNetworkConfigRequest)) {
            return false;
        }
        RemoteNetworkConfigRequest other = (RemoteNetworkConfigRequest) obj;
        return hasRemoteNodeNetworks() == other.hasRemoteNodeNetworks()
                && Objects.equals(remoteNodeNetworks(), other.remoteNodeNetworks())
                && hasRemotePodNetworks() == other.hasRemotePodNetworks()
                && Objects.equals(remotePodNetworks(), other.remotePodNetworks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoteNetworkConfigRequest")
                .add("RemoteNodeNetworks", hasRemoteNodeNetworks() ? remoteNodeNetworks() : null)
                .add("RemotePodNetworks", hasRemotePodNetworks() ? remotePodNetworks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "remoteNodeNetworks":
            return Optional.ofNullable(clazz.cast(remoteNodeNetworks()));
        case "remotePodNetworks":
            return Optional.ofNullable(clazz.cast(remotePodNetworks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("remoteNodeNetworks", REMOTE_NODE_NETWORKS_FIELD);
        map.put("remotePodNetworks", REMOTE_POD_NETWORKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoteNetworkConfigRequest, T> g) {
        return obj -> g.apply((RemoteNetworkConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemoteNetworkConfigRequest> {
        /**
         * <p>
         * The list of network CIDRs that can contain hybrid nodes.
         * </p>
         * <p>
         * These CIDR blocks define the expected IP address range of the hybrid nodes that join the cluster. These
         * blocks are typically determined by your network administrator.
         * </p>
         * <p>
         * Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example, <code> 10.2.0.0/16</code>).
         * </p>
         * <p>
         * It must satisfy the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /32, maximum
         * allowed size is /8. Publicly-routable addresses aren't supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of the
         * Kubernetes service IP range.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each block must have a route to the VPC that uses the VPC CIDR blocks, not public IPs or Elastic IPs. There
         * are many options including Transit Gateway, Site-to-Site VPN, or Direct Connect.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each host must allow outbound connection to the EKS cluster control plane on TCP ports <code>443</code> and
         * <code>10250</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each host must allow inbound connection from the EKS cluster control plane on TCP port 10250 for logs, exec
         * and port-forward operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each host must allow TCP and UDP network connectivity to and from other hosts that are running
         * <code>CoreDNS</code> on UDP port <code>53</code> for service and pod DNS names.
         * </p>
         * </li>
         * </ul>
         * 
         * @param remoteNodeNetworks
         *        The list of network CIDRs that can contain hybrid nodes.</p>
         *        <p>
         *        These CIDR blocks define the expected IP address range of the hybrid nodes that join the cluster.
         *        These blocks are typically determined by your network administrator.
         *        </p>
         *        <p>
         *        Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example,
         *        <code> 10.2.0.0/16</code>).
         *        </p>
         *        <p>
         *        It must satisfy the following requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /32,
         *        maximum allowed size is /8. Publicly-routable addresses aren't supported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block
         *        of the Kubernetes service IP range.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each block must have a route to the VPC that uses the VPC CIDR blocks, not public IPs or Elastic IPs.
         *        There are many options including Transit Gateway, Site-to-Site VPN, or Direct Connect.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each host must allow outbound connection to the EKS cluster control plane on TCP ports
         *        <code>443</code> and <code>10250</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each host must allow inbound connection from the EKS cluster control plane on TCP port 10250 for logs,
         *        exec and port-forward operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each host must allow TCP and UDP network connectivity to and from other hosts that are running
         *        <code>CoreDNS</code> on UDP port <code>53</code> for service and pod DNS names.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteNodeNetworks(Collection<RemoteNodeNetwork> remoteNodeNetworks);

        /**
         * <p>
         * The list of network CIDRs that can contain hybrid nodes.
         * </p>
         * <p>
         * These CIDR blocks define the expected IP address range of the hybrid nodes that join the cluster. These
         * blocks are typically determined by your network administrator.
         * </p>
         * <p>
         * Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example, <code> 10.2.0.0/16</code>).
         * </p>
         * <p>
         * It must satisfy the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /32, maximum
         * allowed size is /8. Publicly-routable addresses aren't supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of the
         * Kubernetes service IP range.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each block must have a route to the VPC that uses the VPC CIDR blocks, not public IPs or Elastic IPs. There
         * are many options including Transit Gateway, Site-to-Site VPN, or Direct Connect.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each host must allow outbound connection to the EKS cluster control plane on TCP ports <code>443</code> and
         * <code>10250</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each host must allow inbound connection from the EKS cluster control plane on TCP port 10250 for logs, exec
         * and port-forward operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each host must allow TCP and UDP network connectivity to and from other hosts that are running
         * <code>CoreDNS</code> on UDP port <code>53</code> for service and pod DNS names.
         * </p>
         * </li>
         * </ul>
         * 
         * @param remoteNodeNetworks
         *        The list of network CIDRs that can contain hybrid nodes.</p>
         *        <p>
         *        These CIDR blocks define the expected IP address range of the hybrid nodes that join the cluster.
         *        These blocks are typically determined by your network administrator.
         *        </p>
         *        <p>
         *        Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example,
         *        <code> 10.2.0.0/16</code>).
         *        </p>
         *        <p>
         *        It must satisfy the following requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /32,
         *        maximum allowed size is /8. Publicly-routable addresses aren't supported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block
         *        of the Kubernetes service IP range.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each block must have a route to the VPC that uses the VPC CIDR blocks, not public IPs or Elastic IPs.
         *        There are many options including Transit Gateway, Site-to-Site VPN, or Direct Connect.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each host must allow outbound connection to the EKS cluster control plane on TCP ports
         *        <code>443</code> and <code>10250</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each host must allow inbound connection from the EKS cluster control plane on TCP port 10250 for logs,
         *        exec and port-forward operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each host must allow TCP and UDP network connectivity to and from other hosts that are running
         *        <code>CoreDNS</code> on UDP port <code>53</code> for service and pod DNS names.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteNodeNetworks(RemoteNodeNetwork... remoteNodeNetworks);

        /**
         * <p>
         * The list of network CIDRs that can contain hybrid nodes.
         * </p>
         * <p>
         * These CIDR blocks define the expected IP address range of the hybrid nodes that join the cluster. These
         * blocks are typically determined by your network administrator.
         * </p>
         * <p>
         * Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example, <code> 10.2.0.0/16</code>).
         * </p>
         * <p>
         * It must satisfy the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /32, maximum
         * allowed size is /8. Publicly-routable addresses aren't supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of the
         * Kubernetes service IP range.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each block must have a route to the VPC that uses the VPC CIDR blocks, not public IPs or Elastic IPs. There
         * are many options including Transit Gateway, Site-to-Site VPN, or Direct Connect.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each host must allow outbound connection to the EKS cluster control plane on TCP ports <code>443</code> and
         * <code>10250</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each host must allow inbound connection from the EKS cluster control plane on TCP port 10250 for logs, exec
         * and port-forward operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each host must allow TCP and UDP network connectivity to and from other hosts that are running
         * <code>CoreDNS</code> on UDP port <code>53</code> for service and pod DNS names.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.RemoteNodeNetwork.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.eks.model.RemoteNodeNetwork#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.RemoteNodeNetwork.Builder#build()} is called immediately and
         * its result is passed to {@link #remoteNodeNetworks(List<RemoteNodeNetwork>)}.
         * 
         * @param remoteNodeNetworks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.RemoteNodeNetwork.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteNodeNetworks(java.util.Collection<RemoteNodeNetwork>)
         */
        Builder remoteNodeNetworks(Consumer<RemoteNodeNetwork.Builder>... remoteNodeNetworks);

        /**
         * <p>
         * The list of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.
         * </p>
         * <p>
         * These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We recommend
         * the Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't available for
         * on-premises and edge locations.
         * </p>
         * <p>
         * Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example, <code> 10.2.0.0/16</code>).
         * </p>
         * <p>
         * It must satisfy the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /32, maximum
         * allowed size is /8. Publicly-routable addresses aren't supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of the
         * Kubernetes service IP range.
         * </p>
         * </li>
         * </ul>
         * 
         * @param remotePodNetworks
         *        The list of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.</p>
         *        <p>
         *        These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We
         *        recommend the Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't
         *        available for on-premises and edge locations.
         *        </p>
         *        <p>
         *        Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example,
         *        <code> 10.2.0.0/16</code>).
         *        </p>
         *        <p>
         *        It must satisfy the following requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /32,
         *        maximum allowed size is /8. Publicly-routable addresses aren't supported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block
         *        of the Kubernetes service IP range.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remotePodNetworks(Collection<RemotePodNetwork> remotePodNetworks);

        /**
         * <p>
         * The list of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.
         * </p>
         * <p>
         * These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We recommend
         * the Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't available for
         * on-premises and edge locations.
         * </p>
         * <p>
         * Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example, <code> 10.2.0.0/16</code>).
         * </p>
         * <p>
         * It must satisfy the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /32, maximum
         * allowed size is /8. Publicly-routable addresses aren't supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of the
         * Kubernetes service IP range.
         * </p>
         * </li>
         * </ul>
         * 
         * @param remotePodNetworks
         *        The list of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.</p>
         *        <p>
         *        These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We
         *        recommend the Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't
         *        available for on-premises and edge locations.
         *        </p>
         *        <p>
         *        Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example,
         *        <code> 10.2.0.0/16</code>).
         *        </p>
         *        <p>
         *        It must satisfy the following requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /32,
         *        maximum allowed size is /8. Publicly-routable addresses aren't supported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block
         *        of the Kubernetes service IP range.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remotePodNetworks(RemotePodNetwork... remotePodNetworks);

        /**
         * <p>
         * The list of network CIDRs that can contain pods that run Kubernetes webhooks on hybrid nodes.
         * </p>
         * <p>
         * These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We recommend
         * the Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't available for
         * on-premises and edge locations.
         * </p>
         * <p>
         * Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example, <code> 10.2.0.0/16</code>).
         * </p>
         * <p>
         * It must satisfy the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /32, maximum
         * allowed size is /8. Publicly-routable addresses aren't supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of the
         * Kubernetes service IP range.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.RemotePodNetwork.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.eks.model.RemotePodNetwork#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.RemotePodNetwork.Builder#build()} is called immediately and
         * its result is passed to {@link #remotePodNetworks(List<RemotePodNetwork>)}.
         * 
         * @param remotePodNetworks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.RemotePodNetwork.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remotePodNetworks(java.util.Collection<RemotePodNetwork>)
         */
        Builder remotePodNetworks(Consumer<RemotePodNetwork.Builder>... remotePodNetworks);
    }

    static final class BuilderImpl implements Builder {
        private List<RemoteNodeNetwork> remoteNodeNetworks = DefaultSdkAutoConstructList.getInstance();

        private List<RemotePodNetwork> remotePodNetworks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteNetworkConfigRequest model) {
            remoteNodeNetworks(model.remoteNodeNetworks);
            remotePodNetworks(model.remotePodNetworks);
        }

        public final List<RemoteNodeNetwork.Builder> getRemoteNodeNetworks() {
            List<RemoteNodeNetwork.Builder> result = RemoteNodeNetworkListCopier.copyToBuilder(this.remoteNodeNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoteNodeNetworks(Collection<RemoteNodeNetwork.BuilderImpl> remoteNodeNetworks) {
            this.remoteNodeNetworks = RemoteNodeNetworkListCopier.copyFromBuilder(remoteNodeNetworks);
        }

        @Override
        public final Builder remoteNodeNetworks(Collection<RemoteNodeNetwork> remoteNodeNetworks) {
            this.remoteNodeNetworks = RemoteNodeNetworkListCopier.copy(remoteNodeNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteNodeNetworks(RemoteNodeNetwork... remoteNodeNetworks) {
            remoteNodeNetworks(Arrays.asList(remoteNodeNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteNodeNetworks(Consumer<RemoteNodeNetwork.Builder>... remoteNodeNetworks) {
            remoteNodeNetworks(Stream.of(remoteNodeNetworks).map(c -> RemoteNodeNetwork.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RemotePodNetwork.Builder> getRemotePodNetworks() {
            List<RemotePodNetwork.Builder> result = RemotePodNetworkListCopier.copyToBuilder(this.remotePodNetworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemotePodNetworks(Collection<RemotePodNetwork.BuilderImpl> remotePodNetworks) {
            this.remotePodNetworks = RemotePodNetworkListCopier.copyFromBuilder(remotePodNetworks);
        }

        @Override
        public final Builder remotePodNetworks(Collection<RemotePodNetwork> remotePodNetworks) {
            this.remotePodNetworks = RemotePodNetworkListCopier.copy(remotePodNetworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remotePodNetworks(RemotePodNetwork... remotePodNetworks) {
            remotePodNetworks(Arrays.asList(remotePodNetworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remotePodNetworks(Consumer<RemotePodNetwork.Builder>... remotePodNetworks) {
            remotePodNetworks(Stream.of(remotePodNetworks).map(c -> RemotePodNetwork.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RemoteNetworkConfigRequest build() {
            return new RemoteNetworkConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
