/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCapabilityResponse extends EksResponse implements
        ToCopyableBuilder<DescribeCapabilityResponse.Builder, DescribeCapabilityResponse> {
    private static final SdkField<Capability> CAPABILITY_FIELD = SdkField.<Capability> builder(MarshallingType.SDK_POJO)
            .memberName("capability").getter(getter(DescribeCapabilityResponse::capability)).setter(setter(Builder::capability))
            .constructor(Capability::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capability").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Capability capability;

    private DescribeCapabilityResponse(BuilderImpl builder) {
        super(builder);
        this.capability = builder.capability;
    }

    /**
     * <p>
     * An object containing detailed information about the capability, including its name, ARN, type, status, version,
     * configuration, health status, and timestamps for when it was created and last modified.
     * </p>
     * 
     * @return An object containing detailed information about the capability, including its name, ARN, type, status,
     *         version, configuration, health status, and timestamps for when it was created and last modified.
     */
    public final Capability capability() {
        return capability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capability());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapabilityResponse)) {
            return false;
        }
        DescribeCapabilityResponse other = (DescribeCapabilityResponse) obj;
        return Objects.equals(capability(), other.capability());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCapabilityResponse").add("Capability", capability()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capability":
            return Optional.ofNullable(clazz.cast(capability()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("capability", CAPABILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapabilityResponse, T> g) {
        return obj -> g.apply((DescribeCapabilityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCapabilityResponse> {
        /**
         * <p>
         * An object containing detailed information about the capability, including its name, ARN, type, status,
         * version, configuration, health status, and timestamps for when it was created and last modified.
         * </p>
         * 
         * @param capability
         *        An object containing detailed information about the capability, including its name, ARN, type, status,
         *        version, configuration, health status, and timestamps for when it was created and last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capability(Capability capability);

        /**
         * <p>
         * An object containing detailed information about the capability, including its name, ARN, type, status,
         * version, configuration, health status, and timestamps for when it was created and last modified.
         * </p>
         * This is a convenience method that creates an instance of the {@link Capability.Builder} avoiding the need to
         * create one manually via {@link Capability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Capability.Builder#build()} is called immediately and its result
         * is passed to {@link #capability(Capability)}.
         * 
         * @param capability
         *        a consumer that will call methods on {@link Capability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capability(Capability)
         */
        default Builder capability(Consumer<Capability.Builder> capability) {
            return capability(Capability.builder().applyMutation(capability).build());
        }
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private Capability capability;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapabilityResponse model) {
            super(model);
            capability(model.capability);
        }

        public final Capability.Builder getCapability() {
            return capability != null ? capability.toBuilder() : null;
        }

        public final void setCapability(Capability.BuilderImpl capability) {
            this.capability = capability != null ? capability.build() : null;
        }

        @Override
        public final Builder capability(Capability capability) {
            this.capability = capability;
            return this;
        }

        @Override
        public DescribeCapabilityResponse build() {
            return new DescribeCapabilityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
