/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for integrating Argo CD with IAM Identity CenterIAM; Identity Center. This allows you to use your
 * organization's identity provider for authentication to Argo CD.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArgoCdAwsIdcConfigRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ArgoCdAwsIdcConfigRequest.Builder, ArgoCdAwsIdcConfigRequest> {
    private static final SdkField<String> IDC_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idcInstanceArn").getter(getter(ArgoCdAwsIdcConfigRequest::idcInstanceArn))
            .setter(setter(Builder::idcInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idcInstanceArn").build()).build();

    private static final SdkField<String> IDC_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idcRegion").getter(getter(ArgoCdAwsIdcConfigRequest::idcRegion)).setter(setter(Builder::idcRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idcRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDC_INSTANCE_ARN_FIELD,
            IDC_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String idcInstanceArn;

    private final String idcRegion;

    private ArgoCdAwsIdcConfigRequest(BuilderImpl builder) {
        this.idcInstanceArn = builder.idcInstanceArn;
        this.idcRegion = builder.idcRegion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM Identity CenterIAM; Identity Center instance to use for authentication.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM Identity CenterIAM; Identity Center instance to use for
     *         authentication.
     */
    public final String idcInstanceArn() {
        return idcInstanceArn;
    }

    /**
     * <p>
     * The Region where your IAM Identity CenterIAM; Identity Center instance is located.
     * </p>
     * 
     * @return The Region where your IAM Identity CenterIAM; Identity Center instance is located.
     */
    public final String idcRegion() {
        return idcRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idcInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(idcRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArgoCdAwsIdcConfigRequest)) {
            return false;
        }
        ArgoCdAwsIdcConfigRequest other = (ArgoCdAwsIdcConfigRequest) obj;
        return Objects.equals(idcInstanceArn(), other.idcInstanceArn()) && Objects.equals(idcRegion(), other.idcRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArgoCdAwsIdcConfigRequest").add("IdcInstanceArn", idcInstanceArn())
                .add("IdcRegion", idcRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idcInstanceArn":
            return Optional.ofNullable(clazz.cast(idcInstanceArn()));
        case "idcRegion":
            return Optional.ofNullable(clazz.cast(idcRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("idcInstanceArn", IDC_INSTANCE_ARN_FIELD);
        map.put("idcRegion", IDC_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArgoCdAwsIdcConfigRequest, T> g) {
        return obj -> g.apply((ArgoCdAwsIdcConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArgoCdAwsIdcConfigRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM Identity CenterIAM; Identity Center instance to use for
         * authentication.
         * </p>
         * 
         * @param idcInstanceArn
         *        The Amazon Resource Name (ARN) of the IAM Identity CenterIAM; Identity Center instance to use for
         *        authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idcInstanceArn(String idcInstanceArn);

        /**
         * <p>
         * The Region where your IAM Identity CenterIAM; Identity Center instance is located.
         * </p>
         * 
         * @param idcRegion
         *        The Region where your IAM Identity CenterIAM; Identity Center instance is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idcRegion(String idcRegion);
    }

    static final class BuilderImpl implements Builder {
        private String idcInstanceArn;

        private String idcRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ArgoCdAwsIdcConfigRequest model) {
            idcInstanceArn(model.idcInstanceArn);
            idcRegion(model.idcRegion);
        }

        public final String getIdcInstanceArn() {
            return idcInstanceArn;
        }

        public final void setIdcInstanceArn(String idcInstanceArn) {
            this.idcInstanceArn = idcInstanceArn;
        }

        @Override
        public final Builder idcInstanceArn(String idcInstanceArn) {
            this.idcInstanceArn = idcInstanceArn;
            return this;
        }

        public final String getIdcRegion() {
            return idcRegion;
        }

        public final void setIdcRegion(String idcRegion) {
            this.idcRegion = idcRegion;
        }

        @Override
        public final Builder idcRegion(String idcRegion) {
            this.idcRegion = idcRegion;
            return this;
        }

        @Override
        public ArgoCdAwsIdcConfigRequest build() {
            return new ArgoCdAwsIdcConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
