/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.CapabilityConfigurationRequest;
import software.amazon.awssdk.services.eks.model.CapabilityDeletePropagationPolicy;
import software.amazon.awssdk.services.eks.model.CapabilityType;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCapabilityRequest
extends EksRequest
implements ToCopyableBuilder<Builder, CreateCapabilityRequest> {
    private static final SdkField<String> CAPABILITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capabilityName").getter(CreateCapabilityRequest.getter(CreateCapabilityRequest::capabilityName)).setter(CreateCapabilityRequest.setter(Builder::capabilityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityName").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(CreateCapabilityRequest.getter(CreateCapabilityRequest::clusterName)).setter(CreateCapabilityRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateCapabilityRequest.getter(CreateCapabilityRequest::clientRequestToken)).setter(CreateCapabilityRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateCapabilityRequest.getter(CreateCapabilityRequest::typeAsString)).setter(CreateCapabilityRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateCapabilityRequest.getter(CreateCapabilityRequest::roleArn)).setter(CreateCapabilityRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<CapabilityConfigurationRequest> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(CreateCapabilityRequest.getter(CreateCapabilityRequest::configuration)).setter(CreateCapabilityRequest.setter(Builder::configuration)).constructor(CapabilityConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateCapabilityRequest.getter(CreateCapabilityRequest::tags)).setter(CreateCapabilityRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DELETE_PROPAGATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deletePropagationPolicy").getter(CreateCapabilityRequest.getter(CreateCapabilityRequest::deletePropagationPolicyAsString)).setter(CreateCapabilityRequest.setter(Builder::deletePropagationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletePropagationPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITY_NAME_FIELD, CLUSTER_NAME_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TYPE_FIELD, ROLE_ARN_FIELD, CONFIGURATION_FIELD, TAGS_FIELD, DELETE_PROPAGATION_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCapabilityRequest.memberNameToFieldInitializer();
    private final String capabilityName;
    private final String clusterName;
    private final String clientRequestToken;
    private final String type;
    private final String roleArn;
    private final CapabilityConfigurationRequest configuration;
    private final Map<String, String> tags;
    private final String deletePropagationPolicy;

    private CreateCapabilityRequest(BuilderImpl builder) {
        super(builder);
        this.capabilityName = builder.capabilityName;
        this.clusterName = builder.clusterName;
        this.clientRequestToken = builder.clientRequestToken;
        this.type = builder.type;
        this.roleArn = builder.roleArn;
        this.configuration = builder.configuration;
        this.tags = builder.tags;
        this.deletePropagationPolicy = builder.deletePropagationPolicy;
    }

    public final String capabilityName() {
        return this.capabilityName;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final CapabilityType type() {
        return CapabilityType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final CapabilityConfigurationRequest configuration() {
        return this.configuration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final CapabilityDeletePropagationPolicy deletePropagationPolicy() {
        return CapabilityDeletePropagationPolicy.fromValue(this.deletePropagationPolicy);
    }

    public final String deletePropagationPolicyAsString() {
        return this.deletePropagationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deletePropagationPolicyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapabilityRequest)) {
            return false;
        }
        CreateCapabilityRequest other = (CreateCapabilityRequest)((Object)obj);
        return Objects.equals(this.capabilityName(), other.capabilityName()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.configuration(), other.configuration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.deletePropagationPolicyAsString(), other.deletePropagationPolicyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCapabilityRequest").add("CapabilityName", (Object)this.capabilityName()).add("ClusterName", (Object)this.clusterName()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Type", (Object)this.typeAsString()).add("RoleArn", (Object)this.roleArn()).add("Configuration", (Object)this.configuration()).add("Tags", this.hasTags() ? this.tags() : null).add("DeletePropagationPolicy", (Object)this.deletePropagationPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "capabilityName": {
                return Optional.ofNullable(clazz.cast(this.capabilityName()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "deletePropagationPolicy": {
                return Optional.ofNullable(clazz.cast(this.deletePropagationPolicyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("capabilityName", CAPABILITY_NAME_FIELD);
        map.put("name", CLUSTER_NAME_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("deletePropagationPolicy", DELETE_PROPAGATION_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCapabilityRequest, T> g) {
        return obj -> g.apply((CreateCapabilityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String capabilityName;
        private String clusterName;
        private String clientRequestToken;
        private String type;
        private String roleArn;
        private CapabilityConfigurationRequest configuration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String deletePropagationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapabilityRequest model) {
            super(model);
            this.capabilityName(model.capabilityName);
            this.clusterName(model.clusterName);
            this.clientRequestToken(model.clientRequestToken);
            this.type(model.type);
            this.roleArn(model.roleArn);
            this.configuration(model.configuration);
            this.tags(model.tags);
            this.deletePropagationPolicy(model.deletePropagationPolicy);
        }

        public final String getCapabilityName() {
            return this.capabilityName;
        }

        public final void setCapabilityName(String capabilityName) {
            this.capabilityName = capabilityName;
        }

        @Override
        public final Builder capabilityName(String capabilityName) {
            this.capabilityName = capabilityName;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CapabilityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final CapabilityConfigurationRequest.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(CapabilityConfigurationRequest.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CapabilityConfigurationRequest configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getDeletePropagationPolicy() {
            return this.deletePropagationPolicy;
        }

        public final void setDeletePropagationPolicy(String deletePropagationPolicy) {
            this.deletePropagationPolicy = deletePropagationPolicy;
        }

        @Override
        public final Builder deletePropagationPolicy(String deletePropagationPolicy) {
            this.deletePropagationPolicy = deletePropagationPolicy;
            return this;
        }

        @Override
        public final Builder deletePropagationPolicy(CapabilityDeletePropagationPolicy deletePropagationPolicy) {
            this.deletePropagationPolicy(deletePropagationPolicy == null ? null : deletePropagationPolicy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCapabilityRequest build() {
            return new CreateCapabilityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCapabilityRequest> {
        public Builder capabilityName(String var1);

        public Builder clusterName(String var1);

        public Builder clientRequestToken(String var1);

        public Builder type(String var1);

        public Builder type(CapabilityType var1);

        public Builder roleArn(String var1);

        public Builder configuration(CapabilityConfigurationRequest var1);

        default public Builder configuration(Consumer<CapabilityConfigurationRequest.Builder> configuration) {
            return this.configuration((CapabilityConfigurationRequest)((CapabilityConfigurationRequest.Builder)CapabilityConfigurationRequest.builder().applyMutation(configuration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder deletePropagationPolicy(String var1);

        public Builder deletePropagationPolicy(CapabilityDeletePropagationPolicy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

